/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.bank;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.bank.CommandBank;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.ServiceVault;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/general/bank/CommandBankWithdraw;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandBank.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBank.kt\norg/kingdoms/commands/general/bank/CommandBankWithdraw\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class CommandBankWithdraw
extends KingdomsCommand {
    public CommandBankWithdraw(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("withdraw", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        CommandResult commandResult;
        CommandResult commandResult2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AtomicDouble atomicRef = new AtomicDouble(0.0);
        CommandResult it = commandResult2 = CommandBank.Companion.handleCommons(context, atomicRef);
        boolean bl = false;
        CommandResult commandResult3 = commandResult = it != CommandResult.SUCCESS ? commandResult2 : null;
        if (commandResult != null) {
            it = commandResult;
            boolean bl2 = false;
            return it;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        double amount = atomicRef.get();
        Kingdom kingdom = context.getKingdom();
        context.var("amount", amount);
        if (!kp.hasPermission(StandardKingdomPermission.WITHDRAW)) {
            StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        if (!KingdomsConfig.ECONOMY_BANK_WITHDRAW_ENABLED.getBoolean()) {
            KingdomsLang.COMMAND_BANK_WITHDRAW_DISABLED.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        double minAmount = KingdomsConfig.ECONOMY_BANK_WITHDRAW_MIN.getDouble();
        if (amount < minAmount) {
            Object[] objectArray = new Object[]{"min", minAmount};
            KingdomsLang.COMMAND_BANK_WITHDRAW_MIN.sendError((CommandSender)player, objectArray);
            return CommandResult.FAILED;
        }
        Kingdom kingdom2 = kingdom;
        Intrinsics.checkNotNull((Object)kingdom2);
        if (kingdom2.getBank().compareTo(amount) < 0) {
            Object[] objectArray = new Object[]{"amount", amount};
            KingdomsLang.COMMAND_BANK_NOT_ENOUGH_KINGDOM_MONEY.sendError((CommandSender)player, objectArray);
            return CommandResult.FAILED;
        }
        kingdom.getBank().add(-amount);
        ServiceVault.deposit((OfflinePlayer)player, amount);
        Object[] objectArray = new Object[]{"amount", amount, "translated", amount, "balance", ServiceVault.getMoney((OfflinePlayer)player)};
        KingdomsLang.COMMAND_BANK_WITHDRAW_SUCCESS.sendMessage((CommandSender)player, objectArray);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(1)) {
            List<String> list = KingdomsCommand.tabComplete("<amount>");
            Intrinsics.checkNotNullExpressionValue(list, (String)"tabComplete(...)");
            return list;
        }
        return new ArrayList();
    }
}

