/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.admin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.internal.ProxyBytecodeManipulator;
import org.kingdoms.utils.network.UpdateChecker;

public class CommandUpdates
extends KingdomsCommand {
    public CommandUpdates() {
        super("updates");
    }

    private static void download(CommandSender sender) {
        Path updateFolder = Bukkit.getUpdateFolderFile().toPath();
        if (!Files.exists(updateFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(updateFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        UpdateChecker.downloadRepositoryToConfiguredPath();
        MessageHandler.sendMessage(sender, "&2Downloaded the plugin to&8: &6" + updateFolder.toAbsolutePath());
    }

    private static void forceUpdate() {
        Path destJar = plugin.getDataFolder().toPath().resolve(UpdateChecker.getJarName());
        UpdateChecker.downloadRepository(destJar).thenAccept(updated -> {
            try {
                ProxyBytecodeManipulator.unloadPlugin((Plugin)plugin);
                Plugin pl = Bukkit.getPluginManager().loadPlugin(destJar.toFile());
                Bukkit.getPluginManager().enablePlugin(pl);
            }
            catch (InvalidDescriptionException | InvalidPluginException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CommandResult execute(CommandContext context) {
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        if (sender instanceof Player) {
            MessageHandler.sendPluginMessage(sender, "&2Checking for updates...");
        }
        UpdateChecker.checkForUpdates().thenRunAsync(() -> {
            if (UpdateChecker.canUpdate()) {
                MessageHandler.sendPluginMessage(sender, UpdateChecker.updateText());
            } else {
                MessageHandler.sendPluginMessage(sender, "&2No updates found &8- &8(&6v" + UpdateChecker.getCurrentVersion() + "&8)");
            }
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("force")) {
                    if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_UPDATES_FORCE, true)) {
                        KingdomsLang.COMMANDS_INSUFFICIENT_PERMISSION.sendMessage(sender);
                        return;
                    }
                    KLogger.warn("A force update has been requested. The plugin is vulnerable to data loss or unexpected errors.");
                    CommandUpdates.forceUpdate();
                } else if (args[0].equalsIgnoreCase("download") && UpdateChecker.canUpdate()) {
                    if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_UPDATES_DOWNLOAD, true)) {
                        KingdomsLang.COMMANDS_INSUFFICIENT_PERMISSION.sendMessage(sender);
                        return;
                    }
                    if (!UpdateChecker.canUpdate()) {
                        MessageHandler.sendMessage(sender, "&4The plugin is already up to date.");
                        return;
                    }
                    MessageHandler.sendMessage(sender, "&2Downloading version &6" + UpdateChecker.getLatestVersion());
                    CommandUpdates.download(sender);
                }
            }
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.isAtArg(0) ? Collections.singletonList("download") : CommandUpdates.emptyTab();
    }
}

