/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.resourcepoints.ResourcePointManager;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandAdminItemInject
extends KingdomsCommand {
    public CommandAdminItemInject(KingdomsParentCommand parent) {
        super("inject", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        ItemMeta meta;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (!context.isNumber(0)) {
            context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(0));
            return CommandResult.FAILED;
        }
        double worth = MathUtils.parseDouble(context.arg(0));
        Player player = context.senderAsPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_INJECT_NO_ITEM, new Object[0]);
            return CommandResult.FAILED;
        }
        item = ResourcePointManager.injectWorth(item, worth).getItem();
        player.getInventory().setItemInMainHand(item);
        String name = null;
        if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
            name = meta.getDisplayName();
        }
        if (name == null) {
            name = XMaterial.matchXMaterial((ItemStack)item).toString();
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ITEM_INJECT_DONE, "rp", Numbers.toFancyNumber(worth), "item", name);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandAdminItemInject.tabComplete("&2<amount>");
        }
        return CommandAdminItemInject.emptyTab();
    }
}

