/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.info;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.others.CommandShow;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/info/CommandAdminInfoKingdom;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminInfoKingdom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminInfoKingdom.kt\norg/kingdoms/commands/admin/info/CommandAdminInfoKingdom\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,29:1\n39#2:30\n*S KotlinDebug\n*F\n+ 1 CommandAdminInfoKingdom.kt\norg/kingdoms/commands/admin/info/CommandAdminInfoKingdom\n*L\n20#1:30\n*E\n"})
public final class CommandAdminInfoKingdom
extends KingdomsCommand {
    public CommandAdminInfoKingdom(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("kingdom", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        MessagePlaceholderProvider messagePlaceholderProvider;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom2 = kingdom;
        MessagePlaceholderProvider $this$execute_u24lambda_u240 = messagePlaceholderProvider = context.getMessageContext().withContext(kingdom2);
        boolean bl = false;
        $this$execute_u24lambda_u240.raw("id", kingdom2.getId());
        $this$execute_u24lambda_u240.raw("ranks", kingdom2.getRanks().toString());
        KingdomPlayer kingdomPlayer = kingdom2.getKing();
        if (kingdomPlayer == null || (kingdomPlayer = kingdomPlayer.getOfflinePlayer()) == null) {
            OfflinePlayer offlinePlayer;
            Set<UUID> set = kingdom2.getMembers();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getMembers(...)");
            UUID uUID = (UUID)CollectionsKt.first((Iterable)set);
            if (uUID != null) {
                KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
                UUID $this$asOfflinePlayer$iv = uUID;
                boolean $i$f$asOfflinePlayer = false;
                OfflinePlayer offlinePlayer2 = Bukkit.getOfflinePlayer((UUID)$this$asOfflinePlayer$iv);
                offlinePlayer = offlinePlayer2;
                Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer2, (String)"getOfflinePlayer(...)");
            } else {
                offlinePlayer = null;
            }
            kingdomPlayer = offlinePlayer;
            Intrinsics.checkNotNull(offlinePlayer);
        }
        KingdomPlayer placeholder = kingdomPlayer;
        CommandShow.show(context.getMessageReceiver(), kingdom2, PlaceholderTarget.Companion.of((OfflinePlayer)placeholder), true, false);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_INFO_KINGDOM_MESSAGE, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list = context.getKingdoms(0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getKingdoms(...)");
        return list;
    }
}

