/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.profiles.builder.ProfileInstruction;
import org.kingdoms.libs.xseries.profiles.builder.XSkull;
import org.kingdoms.libs.xseries.profiles.exceptions.ProfileException;
import org.kingdoms.libs.xseries.profiles.objects.ProfileInputType;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/admin/debugging/CommandAdminSkull;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "waitMessage", "", "context", "Lorg/kingdoms/commands/CommandContext;", "execute", "Lorg/kingdoms/commands/CommandResult;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminSkull.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminSkull.kt\norg/kingdoms/commands/admin/debugging/CommandAdminSkull\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class CommandAdminSkull
extends KingdomsCommand {
    public CommandAdminSkull(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("skull", parent);
    }

    private final void waitMessage(CommandContext context) {
        context.sendMessage((Messenger)new StaticMessenger("{$p}Please wait while skull information is being processed..."), new Object[0]);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Object object;
        Profileable profile;
        Profileable profileable;
        ProfileInputType profileInputType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.assertArgs(1)) {
            if (context.isPlayer()) {
                context.wrongUsage();
                return CommandResult.FAILED;
            }
            Player player = context.senderAsPlayer();
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
            ItemStack item = itemStack;
            if (XMaterial.PLAYER_HEAD.isSimilar(item)) {
                this.waitMessage(context);
                GameProfile profile2 = XSkull.of((ItemStack)item).getProfile();
                context.var("skull-value", profile2);
                context.sendMessage((Messenger)new StaticMessenger("{$p}Final skull value{$sep}: {$s}%skull-value%"), new Object[0]);
                return CommandResult.SUCCESS;
            }
            CommandResult commandResult = context.fail(new StaticMessenger("{$e}The item in your hand cannot contain skull information."));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        boolean applyToBlock = context.argEquals(0, "block");
        if (!applyToBlock && context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        String skull = applyToBlock ? (context.assertArgs(2) ? context.arg(1) : null) : (context.assertArgs(1) ? context.arg(0) : null);
        this.waitMessage(context);
        String string = skull;
        if (string != null) {
            String it = string;
            boolean bl = false;
            profileInputType = ProfileInputType.typeOf((String)skull);
        } else {
            profileInputType = null;
        }
        ProfileInputType idType = profileInputType;
        String string2 = skull;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            profileable = Profileable.detect((String)skull);
        } else {
            profileable = profile = null;
        }
        if (profile != null) {
            try {
                profile.getProfile();
            }
            catch (ProfileException ex) {
                CommandResult commandResult = context.fail(new StaticMessenger("{$e}Failed to get profile{$colon} {$es}" + ex.getMessage()));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
        }
        if (context.isPlayer()) {
            Player player = context.senderAsPlayer();
            if (applyToBlock) {
                Block block = player.getTargetBlockExact(10);
                if (block == null) {
                    CommandResult commandResult = context.fail(new StaticMessenger("{$e}You must look at the skull you want to change."));
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                    return commandResult;
                }
                Block lookingAtBlock = block;
                if (!XBlock.isSimilar((Block)lookingAtBlock, (XMaterial)XMaterial.PLAYER_HEAD)) {
                    CommandResult commandResult = context.fail(new StaticMessenger("{$e}That block is not a player head{$sp}: {$es}" + XMaterial.matchXMaterial((Material)lookingAtBlock.getType())));
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                    return commandResult;
                }
                ProfileInstruction profileInstruction = XSkull.of((Block)lookingAtBlock);
                Intrinsics.checkNotNullExpressionValue((Object)profileInstruction, (String)"of(...)");
                ProfileInstruction blockProfile = profileInstruction;
                if (profile == null) {
                    context.sendMessage((Messenger)new StaticMessenger("{$p}Block skull value{$sep}: {$s}" + blockProfile.getProfile()), new Object[0]);
                    return CommandResult.SUCCESS;
                }
                Object object2 = blockProfile.profile(profile).apply();
                Intrinsics.checkNotNull((Object)object2);
            } else {
                if (profile == null) {
                    context.wrongUsage();
                    return CommandResult.FAILED;
                }
                Object object3 = XSkull.createItem().profile(profile).apply();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"apply(...)");
                ItemStack skullItem = (ItemStack)object3;
                ItemStack[] itemStackArray = new ItemStack[]{skullItem};
                HashMap hashMap = player.getInventory().addItem(itemStackArray);
                Intrinsics.checkNotNull((Object)hashMap);
            }
        }
        if ((object = idType) == null) {
            object = "null";
        }
        context.var("skull-type", object);
        Object object4 = profile;
        if (object4 == null || (object4 = object4.getProfile()) == null) {
            ProfileInputType profileInputType2 = idType;
            object4 = profileInputType2 != null ? profileInputType2.getProfile(skull) : null;
            if (object4 == null) {
                object4 = "null";
            }
        }
        context.var("skull-value", object4);
        context.sendMessage((Messenger)new StaticMessenger("{$p}Detected skull type{$sep}: {$s}%skull-type%"), new Object[0]);
        context.sendMessage((Messenger)new StaticMessenger("{$p}Final skull value{$sep}: {$s}%skull-value%"), new Object[0]);
        return CommandResult.SUCCESS;
    }
}

