/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.time.TimeFormatter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/commands/admin/debugging/CommandAdminEntity;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "Companion", "core"})
public final class CommandAdminEntity
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandAdminEntity(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("entity", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        boolean showDetails;
        double d;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertArgs(1)) {
            Double d2 = context.getDouble(0);
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"getDouble(...)");
            d = ((Number)d2).doubleValue();
        } else {
            d = 10.0;
        }
        double radius = d;
        Integer stay = context.assertArgs(2) ? context.getInt(1) : Integer.valueOf(1);
        boolean bl = showDetails = context.assertArgs(3) && StringsKt.equals((String)context.arg(2), (String)"true", (boolean)true);
        if (radius <= 1.0) {
            MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&cNegative radius&8: &e" + radius);
        }
        if (stay <= 0) {
            MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&cNegative stay number&8: &e" + stay);
        }
        AtomicInteger total = new AtomicInteger();
        Player player = context.senderAsPlayer();
        new BukkitRunnable(stay, player, radius, showDetails, total){
            private Integer times;
            private boolean looping;
            final /* synthetic */ Player $player;
            final /* synthetic */ double $radius;
            final /* synthetic */ boolean $showDetails;
            final /* synthetic */ AtomicInteger $total;
            {
                this.$player = $player;
                this.$radius = $radius;
                this.$showDetails = $showDetails;
                this.$total = $total;
                this.times = $stay;
            }

            public final Integer getTimes() {
                return this.times;
            }

            public final void setTimes(Integer n) {
                this.times = n;
            }

            public final boolean getLooping() {
                return this.looping;
            }

            public final void setLooping(boolean bl) {
                this.looping = bl;
            }

            public void run() {
                for (Entity entity2 : this.$player.getNearbyEntities(this.$radius, this.$radius, this.$radius)) {
                    if (!this.looping) {
                        String string;
                        Location loc;
                        Intrinsics.checkNotNullExpressionValue((Object)entity2.getLocation(), (String)"getLocation(...)");
                        CommandSender commandSender = (CommandSender)this.$player;
                        StringBuilder stringBuilder = new StringBuilder().append("&8\u26ab &2").append(entity2.getType()).append(" (").append(entity2.getCustomName()).append("&2) &6hover:{").append(LocationUtils.toReadableLoc(loc)).append(";&9Click to teleport;/minecraft:tp ").append(loc.getX()).append(' ').append(loc.getY()).append(' ').append(loc.getZ()).append('}');
                        if (this.$showDetails) {
                            Intrinsics.checkNotNull((Object)entity2);
                            string = CommandAdminEntity.Companion.details(entity2);
                        } else {
                            string = "";
                        }
                        MessageHandler.sendMessage(commandSender, stringBuilder.append(string).toString());
                    }
                    ParticleDisplay.of((XParticle)XParticle.FLAME).withLocation(entity2.getLocation()).withCount(20).offset(0.3).spawn();
                    Particles.line((Location)this.$player.getLocation(), (Location)entity2.getLocation(), (double)0.5, (ParticleDisplay)ParticleDisplay.of((XParticle)XParticle.WITCH));
                    if (this.looping) continue;
                    this.$total.incrementAndGet();
                }
                if (!this.looping) {
                    this.looping = true;
                    MessageHandler.sendPluginMessage((CommandSender)this.$player, "&2Found a total of &6" + this.$total + " &2entities within &6" + this.$radius + " &2block radius.");
                }
                this.times = this.times + -1;
                if (this.times <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)KingdomsCommand.plugin, 0L, 5L);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            List<String> list2 = KingdomsCommand.tabComplete("[radius]");
            Intrinsics.checkNotNullExpressionValue(list2, (String)"tabComplete(...)");
            return list2;
        }
        if (context.isAtArg(1)) {
            List<String> list3 = KingdomsCommand.tabComplete("[stay]");
            Intrinsics.checkNotNullExpressionValue(list3, (String)"tabComplete(...)");
            return list3;
        }
        if (context.isAtArg(2)) {
            List<String> list4 = KingdomsCommand.tabComplete("[show details?]");
            list = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"tabComplete(...)");
        } else {
            List<String> list5 = KingdomsCommand.emptyTab();
            list = list5;
            Intrinsics.checkNotNullExpressionValue(list5, (String)"emptyTab(...)");
        }
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/commands/admin/debugging/CommandAdminEntity$Companion;", "", "<init>", "()V", "details", "", "entity", "Lorg/bukkit/entity/Entity;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String details(@NotNull Entity entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            List details = new ArrayList();
            List flags = new ArrayList();
            if (entity2.isFrozen()) {
                flags.add("Frozen");
            }
            if (entity2.isInvulnerable()) {
                flags.add("Invulnerable");
            }
            if (entity2.isSilent()) {
                flags.add("Silent");
            }
            if (entity2 instanceof LivingEntity) {
                Entity zom;
                Pair<String, Integer> pair = Pair.of("No Damage Ticks", ((LivingEntity)entity2).getNoDamageTicks());
                Intrinsics.checkNotNullExpressionValue(pair, (String)"of(...)");
                details.add(pair);
                if (((LivingEntity)entity2).isCollidable()) {
                    flags.add("Collidable");
                }
                if (((LivingEntity)entity2).isInvisible()) {
                    flags.add("Invisible");
                }
                if (XReflection.supports((int)13) && entity2 instanceof Zombie && ((Zombie)(zom = entity2)).isConverting()) {
                    Pair<String, MessageObjectBuilder> pair2 = Pair.of("Convertion Time", TimeFormatter.of(((Zombie)zom).getConversionTime()));
                    Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"of(...)");
                    details.add(pair2);
                }
            }
            StringBuilder detailsStr = new StringBuilder();
            if (!((Collection)flags).isEmpty()) {
                detailsStr.append("\n   &8| &9");
                detailsStr.append(String.join((CharSequence)"&7, &9", flags));
            }
            for (Pair pair : details) {
                String key = (String)((Map.Entry)pair).getKey();
                Object value = ((Map.Entry)pair).getValue();
                if (value instanceof Number && ((Number)value).doubleValue() == 0.0) continue;
                detailsStr.append("\n   &8| &2").append(key).append("&7: &9").append(value);
            }
            String string = detailsStr.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

