/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.create;

import java.util.Iterator;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.claiming.CommandClaimSquare;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.claiming.bulk.BasicBulkClaimProcessor;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/admin/create/CommandAdminCreateSuper;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandAdminCreateSuper
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandAdminCreateSuper(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("super", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.getKingdomPlayer().hasKingdom()) {
            context.sendError(KingdomsLang.COMMAND_CREATE_ALREADY_IN_KINGDOM, new Object[0]);
            return CommandResult.FAILED;
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_CREATE_SUPER_CREATING, new Object[0]);
        Player player = context.senderAsPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"senderAsPlayer(...)");
        Companion.superCreate(player);
        return CommandResult.SUCCESS;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/admin/create/CommandAdminCreateSuper$Companion;", "", "<init>", "()V", "superCreate", "", "player", "Lorg/bukkit/entity/Player;", "initSuperKingdom", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandAdminCreate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminCreate.kt\norg/kingdoms/commands/admin/create/CommandAdminCreateSuper$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,187:1\n216#2,2:188\n*S KotlinDebug\n*F\n+ 1 CommandAdminCreate.kt\norg/kingdoms/commands/admin/create/CommandAdminCreateSuper$Companion\n*L\n125#1:188,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void superCreate(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int name = 0;
            while (Kingdom.getKingdom(String.valueOf(name)) != null) {
                ++name;
            }
            Kingdom kingdom = new Kingdom(player.getUniqueId(), String.valueOf(name));
            this.initSuperKingdom(player, kingdom);
        }

        public final void initSuperKingdom(@NotNull Player player, @NotNull Kingdom kingdom) {
            Block block;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            KingdomPlayer kp = kingdomPlayer;
            kingdom.getResourcePoints().add(MathUtils.randInt(5000, 10000));
            kingdom.getBank().add(MathUtils.randInt(5000, 10000));
            KingdomItemCreateSettings settings = new KingdomItemCreateSettings(kingdom, kp);
            TurretRegistry.get().getStyles().values().stream().map(arg_0 -> Companion.initSuperKingdom$lambda$1(arg_0 -> Companion.initSuperKingdom$lambda$0(settings, arg_0), arg_0)).forEach(arg_0 -> Companion.initSuperKingdom$lambda$3(arg_0 -> Companion.initSuperKingdom$lambda$2(player, arg_0), arg_0));
            StructureRegistry.get().getStyles().values().stream().filter(arg_0 -> Companion.initSuperKingdom$lambda$5(Companion::initSuperKingdom$lambda$4, arg_0)).map(arg_0 -> Companion.initSuperKingdom$lambda$7(arg_0 -> Companion.initSuperKingdom$lambda$6(settings, arg_0), arg_0)).forEach(arg_0 -> Companion.initSuperKingdom$lambda$9(arg_0 -> Companion.initSuperKingdom$lambda$8(player, arg_0), arg_0));
            SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
            Pair<SimpleChunkLocation, SimpleChunkLocation> corners = CommandClaimSquare.getCenteredSquareCorners(chunk, 5);
            BasicBulkClaimProcessor<AbstractClaimProcessor> result = CommandClaimSquare.squared((AbstractClaimProcessor)ClaimProcessor.build(chunk, KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), kingdom), corners.getKey(), corners.getValue(), false);
            Map $this$forEach$iv = result.getProcessedClaims();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                BlockVector2 k = (BlockVector2)entry.getKey();
                AbstractClaimProcessor v = (AbstractClaimProcessor)entry.getValue();
                kingdom.claim(new SimpleChunkLocation(player.getWorld().getName(), k.getX(), k.getZ()), kp, ClaimLandEvent.Reason.ADMIN);
            }
            Land land = SimpleChunkLocation.of(player.getLocation()).getLand();
            CommandSetHome.setHome(kingdom, BukkitAdapter.adapt(player.getLocation().add(0.0, 1.0, 0.0)), kp);
            if (land != null && kingdom.isClaimed(land.getLocation()) && !LocationUtils.exceedsBuildLimit(player.getLocation()) && (block = LocationUtils.findEmptyBlock(player.getLocation().getBlock())) != null) {
                Location location = BukkitAdapter.adapt(block.getLocation());
                Intrinsics.checkNotNull((Object)location);
                kingdom.placeOrMoveNexus(location, KingdomPlayer.getKingdomPlayer((OfflinePlayer)player));
            }
            XSound.play((String)KingdomsConfig.CREATION_KINGDOMS_SOUND.getString(), arg_0 -> Companion.initSuperKingdom$lambda$11(player, arg_0));
        }

        private static final KingdomItem initSuperKingdom$lambda$0(KingdomItemCreateSettings $settings, TurretStyle t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return t.buildItem($settings);
        }

        private static final KingdomItem initSuperKingdom$lambda$1(Function1 $tmp0, Object p0) {
            return (KingdomItem)$tmp0.invoke(p0);
        }

        private static final Unit initSuperKingdom$lambda$2(Player $player, KingdomItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            ItemStack[] itemStackArray = new ItemStack[]{item.getItem()};
            $player.getInventory().addItem(itemStackArray);
            return Unit.INSTANCE;
        }

        private static final void initSuperKingdom$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final boolean initSuperKingdom$lambda$4(StructureStyle t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return !((StructureType)t.getType()).isNexus();
        }

        private static final boolean initSuperKingdom$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final KingdomItem initSuperKingdom$lambda$6(KingdomItemCreateSettings $settings, StructureStyle t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return t.buildItem($settings);
        }

        private static final KingdomItem initSuperKingdom$lambda$7(Function1 $tmp0, Object p0) {
            return (KingdomItem)$tmp0.invoke(p0);
        }

        private static final Unit initSuperKingdom$lambda$8(Player $player, KingdomItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            ItemStack[] itemStackArray = new ItemStack[]{item.getItem()};
            $player.getInventory().addItem(itemStackArray);
            return Unit.INSTANCE;
        }

        private static final void initSuperKingdom$lambda$9(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void initSuperKingdom$lambda$11(Player $player, XSound.SoundPlayer x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Player[] playerArray = new Player[]{$player};
            x.forPlayers(playerArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

