/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.create;

import java.util.UUID;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.create.CommandAdminCreateAny;
import org.kingdoms.commands.admin.create.CommandAdminCreateKingless;
import org.kingdoms.commands.admin.create.CommandAdminCreateSimple;
import org.kingdoms.commands.admin.create.CommandAdminCreateSuper;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/commands/admin/create/CommandAdminCreate;", "Lorg/kingdoms/commands/KingdomsParentCommand;", "parent", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "Companion", "core"})
public final class CommandAdminCreate
extends KingdomsParentCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandAdminCreate(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("create", parent);
        new CommandAdminCreateSimple(this);
        new CommandAdminCreateKingless(this);
        new CommandAdminCreateAny(this);
        new CommandAdminCreateSuper(this);
    }

    @JvmStatic
    @Nullable
    public static final Kingdom create(@NotNull CommandContext context, @Nullable UUID king) {
        return Companion.create(context, king);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/admin/create/CommandAdminCreate$Companion;", "", "<init>", "()V", "create", "Lorg/kingdoms/constants/group/Kingdom;", "context", "Lorg/kingdoms/commands/CommandContext;", "king", "Ljava/util/UUID;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Kingdom create(@NotNull CommandContext context, @Nullable UUID king) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String name = context.arg(0);
            Kingdom existingKingdom = Kingdom.getKingdom(name);
            context.var("kingdom", name);
            if (existingKingdom != null) {
                context.getMessageContext().withContext(existingKingdom);
                context.fail(KingdomsLang.COMMAND_ADMIN_CREATE_ALREADY_EXISTS);
                return null;
            }
            Kingdom kingdom = new Kingdom(king, name);
            context.getMessageContext().withContext(kingdom);
            return kingdom;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

