/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.claim;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.claim.CommandAdminUnclaimAll;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.StaticMessenger;

public class CommandAdminUnclaim
extends KingdomsParentCommand {
    public CommandAdminUnclaim(KingdomsParentCommand parent) {
        super("unclaim", parent);
        new CommandAdminUnclaimAll(this);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        Land land = Land.getLand(player.getLocation());
        Kingdom kingdom2 = kingdom = land == null ? null : land.getKingdom();
        if (kingdom == null) {
            KingdomsLang.COMMAND_ADMIN_UNCLAIM_NOT_CLAIMED.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        SimpleChunkLocation chunk = land.getLocation();
        if (!kingdom.isClaimed(chunk)) {
            land.silentUnclaim();
            context.sendError(new StaticMessenger("{$e}It seems like your kingdoms data is corrupted. Please run {$es}/k admin FSCK"), new Object[0]);
        } else if (land.unclaim(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), UnclaimLandEvent.Reason.ADMIN).isCancelled()) {
            return CommandResult.FAILED;
        }
        KingdomsLang.COMMAND_ADMIN_UNCLAIM_SUCCESS.sendMessage((CommandSender)player, "x", chunk.getX(), "z", chunk.getZ(), "kingdom", kingdom.getName());
        return CommandResult.SUCCESS;
    }
}

