/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.claim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandAdminClaim
extends KingdomsCommand {
    public CommandAdminClaim(KingdomsParentCommand parent) {
        super("claim", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom landOwner;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
        Land land = chunk.getLand();
        if (land != null && (landOwner = land.getKingdom()) != null) {
            context.getMessageContext().withContext(landOwner);
            context.fail(KingdomsLang.COMMAND_ADMIN_CLAIM_ALREADY_CLAIMED);
            return CommandResult.FAILED;
        }
        if (kingdom.claim(Collections.singleton(chunk), kp, ClaimLandEvent.Reason.ADMIN, false).isCancelled()) {
            return CommandResult.FAILED;
        }
        KingdomsLang.COMMAND_ADMIN_CLAIM_SUCCESS.sendMessage((CommandSender)player, "x", chunk.getX(), "z", chunk.getZ(), "kingdom", kingdom.getName());
        new LandVisualizer().forPlayer(player, kp).forLand(land, chunk.toChunk()).display(true);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isPlayer() && context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        return new ArrayList<String>();
    }
}

