/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.hash.EntityUUIDHashSet;
import org.kingdoms.utils.internal.uuid.FastUUID;

public final class CommandAdminTrack
extends KingdomsCommand {
    private static final EntityUUIDHashSet<Player> TRACKERS = ((EntityHashSet.UUIDBuilder)EntityHashSet.uuidBuilder(Player.class).onLeave(EntityUUIDHashSet::remove)).build();

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        UUID id;
        UUID uUID = id = context.isPlayer() ? context.senderAsPlayer().getUniqueId() : FastUUID.ZERO;
        if (TRACKERS.contains(id)) {
            TRACKERS.remove(id);
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_TRACK_DISABLED, new Object[0]);
        } else {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_TRACK_ENABLED, new Object[0]);
            TRACKERS.add(id);
        }
        return CommandResult.SUCCESS;
    }

    public CommandAdminTrack(@NotNull KingdomsParentCommand parent) {
        super("track", parent);
    }

    public static boolean isTracking(@NotNull CommandSender sender) {
        UUID id = sender instanceof Player ? ((Player)sender).getUniqueId() : FastUUID.ZERO;
        return TRACKERS.contains(id);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getPlayers(0);
        }
        return context.emptyTab();
    }
}

