/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.kotlin.text.MatchResult;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.snakeyaml.comments.CommentLine;
import org.kingdoms.libs.snakeyaml.comments.CommentType;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u000eH\u0002J\u001b\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminSearchConfig;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "executeAsync", "", "compileColorsToObj", "Lorg/kingdoms/locale/compiler/MessageObject;", "", "compileColorsToProvider", "Lorg/kingdoms/locale/provider/MessageProvider;", "compileColors", "wordListToRegex", "Ljava/util/regex/Pattern;", "keywords", "", "([Ljava/lang/String;)Ljava/util/regex/Pattern;", "ConfigSearcher", "ConfigSearchResult", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminSearchConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminSearchConfig.kt\norg/kingdoms/commands/admin/CommandAdminSearchConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n756#2,10:226\n1#3:236\n*S KotlinDebug\n*F\n+ 1 CommandAdminSearchConfig.kt\norg/kingdoms/commands/admin/CommandAdminSearchConfig\n*L\n81#1:226,10\n*E\n"})
public final class CommandAdminSearchConfig
extends KingdomsCommand {
    public CommandAdminSearchConfig(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("searchConfig", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Kingdoms.taskScheduler().async().execute(() -> CommandAdminSearchConfig.execute$lambda$0(this, context));
        return CommandResult.SUCCESS;
    }

    private final void executeAsync(CommandContext context) {
        Pattern e2;
        Pattern pattern;
        try {
            pattern = Pattern.compile(context.arg(0));
            Intrinsics.checkNotNull((Object)pattern);
        }
        catch (PatternSyntaxException e2) {
            KLogger.debug((DebugNS)KingdomsDebug.INVALID$REGEX, "Invalid pattern for /k admin searchConfig: " + e2.getDescription());
            Intrinsics.checkNotNullExpressionValue((Object)context.args, (String)"args");
            pattern = this.wordListToRegex(context.args);
        }
        Pattern contentPattern = pattern;
        try {
            e2 = Pattern.compile(context.arg(1));
            Intrinsics.checkNotNull((Object)e2);
        }
        catch (PatternSyntaxException e3) {
            KLogger.debug((DebugNS)KingdomsDebug.INVALID$REGEX, "Invalid pattern for /k admin searchConfig: " + e3.getDescription());
            Intrinsics.checkNotNullExpressionValue((Object)context.args, (String)"args");
            e2 = this.wordListToRegex(context.args);
        }
        Pattern filePattern = e2;
        context.var("pattern", contentPattern.pattern());
        context.var("file-pattern", filePattern.pattern());
        List<YamlResource> list = ConfigManager.getConfigs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getConfigs(...)");
        ConfigSearcher searcher = new ConfigSearcher(list, filePattern, contentPattern);
        searcher.find();
        List<Pair<YamlContainer, List<ConfigSearchResult>>> result = searcher.getResult();
        if (result.isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_SEARCHCONFIG_NO_RESULTS, new Object[0]);
        } else {
            int lineNumberPadding = String.valueOf(searcher.getLargestLineNumber()).length();
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_SEARCHCONFIG_FOUND, new Object[0]);
            for (Pair<YamlContainer, List<ConfigSearchResult>> file : result) {
                YamlContainer adapter = (YamlContainer)file.component1();
                List result2 = (List)file.component2();
                Object[] objectArray = new Object[2];
                objectArray[0] = "path";
                File file2 = adapter.getFile();
                objectArray[1] = file2 != null ? file2.getPath() : null;
                context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_SEARCHCONFIG_ENTRY, objectArray);
                for (ConfigSearchResult entry : result2) {
                    int line = entry.getLine();
                    if (entry.getEntryKey().getComments() != null) {
                        List<CommentLine> it;
                        boolean bl = false;
                        String commentColor = "{#0e7822}";
                        Iterable $this$dropWhile$iv = it;
                        boolean $i$f$dropWhile = false;
                        boolean yielding$iv = false;
                        ArrayList list$iv = new ArrayList();
                        for (Object item$iv : $this$dropWhile$iv) {
                            if (yielding$iv) {
                                list$iv.add(item$iv);
                                continue;
                            }
                            CommentLine x = (CommentLine)item$iv;
                            boolean bl2 = false;
                            if (x.getCommentType() == CommentType.BLANK_LINE) continue;
                            list$iv.add(item$iv);
                            yielding$iv = true;
                        }
                        Iterator iterator = ((Iterable)list$iv).iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            int index = n++;
                            CommentLine blockComment = (CommentLine)iterator.next();
                            int startLine = line - it.size() + index;
                            StaticMessenger staticMessenger = new StaticMessenger(CommandAdminSearchConfig.executeAsync$lineNumber(lineNumberPadding, startLine) + commentColor + "#%comment%");
                            CommandSender commandSender = context.getMessageReceiver();
                            MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider();
                            String string = blockComment.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                            staticMessenger.sendMessage(commandSender, messagePlaceholderProvider.parse("comment", CommandAdminSearchConfig.executeAsync$replaceMatched(string, this, context, contentPattern, this.compileColors(commentColor))));
                        }
                    }
                    Pair<String, String> value = CommandAdminSearchConfig.executeAsync$nodeToString(this, entry.getEntryValue());
                    String keyColor = "{#0ca874}";
                    StringBuilder stringBuilder = new StringBuilder().append(CommandAdminSearchConfig.executeAsync$lineNumber(lineNumberPadding, line)).append(keyColor);
                    Node node = entry.getEntryKey();
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.snakeyaml.nodes.ScalarNode");
                    String string = ((ScalarNode)node).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    new StaticMessenger(this.compileColorsToProvider(stringBuilder.append(CommandAdminSearchConfig.executeAsync$replaceMatched(string, this, context, contentPattern, this.compileColors(keyColor))).append("{$sep}: %value%").toString())).sendMessage(context.getMessageReceiver(), new MessagePlaceholderProvider().raw("value", this.compileColors((String)value.getFirst()) + CommandAdminSearchConfig.executeAsync$replaceMatched((String)value.getSecond(), this, context, contentPattern, this.compileColors((String)value.getFirst()))));
                    context.sendMessage((Messenger)new StaticMessenger("&7-------------------------------------"), new Object[0]);
                }
                context.sendMessage((Messenger)new StaticMessenger("&8======================================================"), new Object[0]);
            }
        }
    }

    private final MessageObject compileColorsToObj(String $this$compileColorsToObj) {
        MessageObject messageObject = new MessageCompiler($this$compileColorsToObj, MessageCompilerSettings.none().translatePlaceholders().colorize()).compileObject();
        Intrinsics.checkNotNullExpressionValue((Object)messageObject, (String)"compileObject(...)");
        return messageObject;
    }

    private final MessageProvider compileColorsToProvider(String $this$compileColorsToProvider) {
        return new MessageProvider(this.compileColorsToObj($this$compileColorsToProvider));
    }

    private final String compileColors(String $this$compileColors) {
        String string = this.compileColorsToObj($this$compileColors).buildPlain(new MessagePlaceholderProvider());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildPlain(...)");
        return string;
    }

    private final Pattern wordListToRegex(String[] keywords) {
        Pattern pattern = Pattern.compile(ArraysKt.joinToString$default((Object[])keywords, (CharSequence)"|", null, null, (int)0, null, CommandAdminSearchConfig::wordListToRegex$lambda$6, (int)30, null));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        return pattern;
    }

    private static final void execute$lambda$0(CommandAdminSearchConfig this$0, CommandContext $context) {
        this$0.executeAsync($context);
    }

    private static final CharSequence executeAsync$replaceMatched$lambda$1(CommandAdminSearchConfig this$0, CommandContext $context, String $next, MatchResult x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this$0.compileColors("{#FF0000}") + ChatColor.UNDERLINE + x.getValue() + ChatColor.RESET + ($context.isPlayer() ? "" : " ") + $next;
    }

    private static final String executeAsync$replaceMatched(String $this$executeAsync_u24replaceMatched, CommandAdminSearchConfig this$0, CommandContext $context, Pattern pattern, String next) {
        return new Regex(pattern).replace((CharSequence)$this$executeAsync_u24replaceMatched, arg_0 -> CommandAdminSearchConfig.executeAsync$replaceMatched$lambda$1(this$0, $context, next, arg_0));
    }

    private static final String executeAsync$lineNumber(int lineNumberPadding, int line) {
        return "&7" + StringsKt.padEnd$default((String)String.valueOf(line), (int)lineNumberPadding, (char)'\u0000', (int)2, null) + " | ";
    }

    private static final String executeAsync$toSimpleString(ScalarNode $this$executeAsync_u24toSimpleString) {
        String string;
        String value = $this$executeAsync_u24toSimpleString.getValue();
        ScalarStyle scalarStyle = $this$executeAsync_u24toSimpleString.getScalarStyle();
        switch (scalarStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scalarStyle.ordinal()]) {
            case 1: {
                string = '\'' + value + '\'';
                break;
            }
            case 2: {
                string = '\"' + value + '\"';
                break;
            }
            case 3: {
                string = ">\n" + value;
                break;
            }
            case 4: {
                string = "|\n" + value;
                break;
            }
            default: {
                Intrinsics.checkNotNull((Object)value);
                string = value;
            }
        }
        return string;
    }

    private static final CharSequence executeAsync$nodeToString$lambda$5(CommandAdminSearchConfig this$0, Node ele) {
        Intrinsics.checkNotNull((Object)ele);
        Pair<String, String> it = CommandAdminSearchConfig.executeAsync$nodeToString(this$0, ele);
        boolean bl = false;
        return (String)it.getFirst() + (String)it.getSecond();
    }

    private static final Pair<String, String> executeAsync$nodeToString(CommandAdminSearchConfig this$0, Node node) {
        Pair pair;
        Node node2 = node;
        if (node2 instanceof MappingNode) {
            pair = new Pair((Object)"{$p}", (Object)"{...}");
        } else if (node2 instanceof SequenceNode) {
            StringBuilder stringBuilder = new StringBuilder().append("&8[ ");
            Collection collection = ((SequenceNode)node).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getValue(...)");
            pair = new Pair((Object)"{$sep}", (Object)this$0.compileColors(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"&7, ", null, null, (int)0, null, arg_0 -> CommandAdminSearchConfig.executeAsync$nodeToString$lambda$5(this$0, arg_0), (int)30, null)).append(" &8]").toString()));
        } else if (node2 instanceof ScalarNode) {
            String string;
            Tag tag = ((ScalarNode)node).getTag();
            if (Intrinsics.areEqual((Object)tag, (Object)Tag.BOOL)) {
                Object object = ((ScalarNode)node).getParsed();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                string = ((Boolean)object).booleanValue() ? "&2" : "&c";
            } else {
                string = Intrinsics.areEqual((Object)tag, (Object)Tag.INT) ? "&9" : (Intrinsics.areEqual((Object)tag, (Object)Tag.NULL) ? "&4" : (Intrinsics.areEqual((Object)tag, (Object)Tag.STR) ? "&6" : (Intrinsics.areEqual((Object)tag, (Object)CustomConfigValidators.MATH) ? "&5" : (Intrinsics.areEqual((Object)tag, (Object)CustomConfigValidators.PERIOD) ? "{#28869e}" : "{#929e28}"))));
            }
            pair = new Pair((Object)string, (Object)CommandAdminSearchConfig.executeAsync$toSimpleString((ScalarNode)node));
        } else {
            pair = new Pair((Object)"{$s}", (Object)node.toString());
        }
        return pair;
    }

    private static final CharSequence wordListToRegex$lambda$6(String x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        String string = Pattern.quote(x);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminSearchConfig$ConfigSearchResult;", "", "entryKey", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "entryValue", "<init>", "(Lorg/kingdoms/commands/admin/CommandAdminSearchConfig;Lorg/snakeyaml/nodes/Node;Lorg/snakeyaml/nodes/Node;)V", "getEntryKey", "()Lorg/snakeyaml/nodes/Node;", "getEntryValue", "getLine", "", "core"})
    public final class ConfigSearchResult {
        @NotNull
        private final Node entryKey;
        @NotNull
        private final Node entryValue;

        public ConfigSearchResult(@NotNull Node entryKey, Node entryValue) {
            Intrinsics.checkNotNullParameter((Object)entryKey, (String)"entryKey");
            Intrinsics.checkNotNullParameter((Object)entryValue, (String)"entryValue");
            this.entryKey = entryKey;
            this.entryValue = entryValue;
        }

        @NotNull
        public final Node getEntryKey() {
            return this.entryKey;
        }

        @NotNull
        public final Node getEntryValue() {
            return this.entryValue;
        }

        public final int getLine() {
            return this.entryValue.getStartMark().getLine();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\f0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/kingdoms/commands/admin/CommandAdminSearchConfig$ConfigSearcher;", "", "configs", "", "Lorg/kingdoms/utils/config/adapters/YamlContainer;", "filesPattern", "Ljava/util/regex/Pattern;", "pattern", "<init>", "(Lorg/kingdoms/commands/admin/CommandAdminSearchConfig;Ljava/util/List;Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;)V", "Lorg/kingdoms/libs/kotlin/text/Regex;", "result", "", "Lorg/kingdoms/libs/kotlin/Pair;", "Lorg/kingdoms/commands/admin/CommandAdminSearchConfig$ConfigSearchResult;", "Lorg/kingdoms/commands/admin/CommandAdminSearchConfig;", "getResult", "()Ljava/util/List;", "largestLineNumber", "", "getLargestLineNumber", "()I", "setLargestLineNumber", "(I)V", "find", "", "searchNode", "", "node", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "findInnerSections", "section", "Lorg/kingdoms/libs/snakeyaml/nodes/MappingNode;", "results", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandAdminSearchConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminSearchConfig.kt\norg/kingdoms/commands/admin/CommandAdminSearchConfig$ConfigSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n774#2:226\n865#2,2:227\n1755#2,3:229\n1755#2,3:233\n1#3:232\n*S KotlinDebug\n*F\n+ 1 CommandAdminSearchConfig.kt\norg/kingdoms/commands/admin/CommandAdminSearchConfig$ConfigSearcher\n*L\n183#1:226\n183#1:227,2\n201#1:229,3\n211#1:233,3\n*E\n"})
    public final class ConfigSearcher {
        @NotNull
        private final List<YamlContainer> configs;
        @Nullable
        private final Regex filesPattern;
        @NotNull
        private final Regex pattern;
        @NotNull
        private final List<Pair<YamlContainer, List<ConfigSearchResult>>> result;
        private int largestLineNumber;

        public ConfigSearcher(@Nullable List<? extends YamlContainer> configs, @NotNull Pattern filesPattern, Pattern pattern) {
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.configs = configs;
            this.filesPattern = filesPattern != null ? new Regex(filesPattern) : null;
            this.pattern = new Regex(pattern);
            this.result = new ArrayList();
        }

        @NotNull
        public final List<Pair<YamlContainer, List<ConfigSearchResult>>> getResult() {
            return this.result;
        }

        public final int getLargestLineNumber() {
            return this.largestLineNumber;
        }

        public final void setLargestLineNumber(int n) {
            this.largestLineNumber = n;
        }

        /*
         * WARNING - void declaration
         */
        public final void find() {
            List list;
            if (this.filesPattern != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.configs;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    YamlContainer it = (YamlContainer)element$iv$iv;
                    boolean bl = false;
                    Path path = Kingdoms.getFolder().toAbsolutePath();
                    File file = it.getFile();
                    Intrinsics.checkNotNull((Object)file);
                    String name = ((Object)path.relativize(file.toPath().toAbsolutePath())).toString();
                    CharSequence charSequence = name;
                    if (!this.filesPattern.containsMatchIn(charSequence)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = this.configs;
            }
            List searchConfigs = list;
            for (YamlContainer adapter : searchConfigs) {
                List innerResults = new ArrayList();
                MappingNode mappingNode = adapter.getConfig().getNode();
                Intrinsics.checkNotNullExpressionValue((Object)mappingNode, (String)"getNode(...)");
                this.findInnerSections(mappingNode, innerResults);
                if (!(!((Collection)innerResults).isEmpty())) continue;
                this.result.add((Pair<YamlContainer, List<ConfigSearchResult>>)new Pair((Object)adapter, (Object)innerResults));
            }
        }

        private final boolean searchNode(Node node) {
            boolean bl;
            block7: {
                Node node2 = node;
                if (node2 instanceof ScalarNode) {
                    String string = ((ScalarNode)node).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    CharSequence charSequence = string;
                    bl = this.pattern.containsMatchIn(charSequence);
                } else if (node2 instanceof SequenceNode) {
                    Collection collection = ((SequenceNode)node).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getValue(...)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Node ele = (Node)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)ele);
                            if (!this.searchNode(ele)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        private final void findInnerSections(MappingNode section, List<ConfigSearchResult> results) {
            v0 = section.getPairs();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getPairs(...)");
            for (Map.Entry<K, V> var4_4 : ((Map)v0).entrySet()) {
                block9: {
                    v1 = var4_4.getKey();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"component1(...)");
                    key = (String)v1;
                    v2 = var4_4.getValue();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"component2(...)");
                    pair = (NodePair)v2;
                    node = pair.getValue();
                    var9_9 = key;
                    if (this.pattern.containsMatchIn(var9_9)) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)node);
                    if (this.searchNode(node)) ** GOTO lbl-1000
                    if (node.getComments() != null) {
                        $i$a$-let-CommandAdminSearchConfig$ConfigSearcher$findInnerSections$matches$1 = false;
                        $this$any$iv = it;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v3 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                x = (CommentLine)element$iv;
                                $i$a$-any-CommandAdminSearchConfig$ConfigSearcher$findInnerSections$matches$1$1 = false;
                                v4 = x.getValue();
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getValue(...)");
                                var18_18 = v4;
                                if (!this.pattern.containsMatchIn(var18_18)) continue;
                                v3 = true;
                                break block9;
                            }
                            v3 = false;
                        }
                    } else {
                        v3 = false;
                    }
                }
                if (v3) lbl-1000:
                // 3 sources

                {
                    v5 = true;
                } else {
                    v5 = matches = false;
                }
                if (matches) {
                    this.largestLineNumber = RangesKt.coerceAtLeast((int)this.largestLineNumber, (int)node.getStartMark().getLine());
                    v6 = pair.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getKey(...)");
                    v7 = v6;
                    Intrinsics.checkNotNull((Object)node);
                    results.add(new ConfigSearchResult(v7, node));
                }
                if (!(node instanceof MappingNode)) continue;
                this.findInnerSections((MappingNode)node, results);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScalarStyle.values().length];
            try {
                nArray[ScalarStyle.SINGLE_QUOTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScalarStyle.DOUBLE_QUOTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScalarStyle.FOLDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScalarStyle.LITERAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

