/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;

public class CommandAdminRename
extends KingdomsCommand {
    public CommandAdminRename(KingdomsParentCommand parent) {
        super("rename", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (!context.assertArgs(2)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RENAME_USAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        String newName = context.arg(1);
        String oldName = kingdom.getName();
        Kingdom renameKingdom = Kingdom.getKingdom(newName);
        if (renameKingdom != null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RENAME_ALREADY_EXISTS, new Object[0]);
            return CommandResult.FAILED;
        }
        if (kingdom.rename(newName, null).isCancelled()) {
            return CommandResult.FAILED;
        }
        context.var("old_name", oldName);
        context.var("old_name", kingdom.getName());
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_RENAME_RENAMED, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        if (context.isAtArg(1)) {
            return CommandAdminRename.tabComplete("&2<name>");
        }
        return CommandAdminRename.emptyTab();
    }
}

