/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Arrays;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.nexus.CommandNexus;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.buildings.structures.NexusManager;

public class CommandAdminNexus
extends KingdomsCommand {
    public CommandAdminNexus(KingdomsParentCommand admin) {
        super("nexus", admin);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        boolean notAdmin;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        if (context.argEquals(1, "tp")) {
            SimpleLocation nexus = kingdom.getNexus();
            if (nexus == null) {
                KingdomsLang.COMMAND_ADMIN_NEXUS_TP_NOT_SET.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
                return CommandResult.FAILED;
            }
            KingdomsLang.COMMAND_ADMIN_NEXUS_TP.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            player.teleport(nexus.toBukkitLocation());
            return CommandResult.FAILED;
        }
        if (context.argEquals(1, "place")) {
            CommandNexus.startSession(player, kingdom);
            return CommandResult.SUCCESS;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean bl = notAdmin = !kp.isAdmin();
        if (notAdmin) {
            kp.setAdmin(true);
        }
        new NexusManager(kingdom, player).openNexus();
        if (notAdmin) {
            kp.setAdmin(false);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        if (context.isAtArg(1)) {
            return Arrays.asList("tp", "place");
        }
        return context.emptyTab();
    }
}

