/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.abstraction.ProlongedDurationTask;

public class CommandAdminMasswar
extends KingdomsCommand {
    public CommandAdminMasswar(KingdomsParentCommand parent) {
        super("masswar", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        String option = args[0].toLowerCase(Locale.ENGLISH);
        Masswar masswar = Masswar.getInstance();
        ProlongedDurationTask.State state = masswar.getState();
        switch (option) {
            case "start": {
                if (state != ProlongedDurationTask.State.NOT_STARTED) {
                    KingdomsLang.COMMAND_ADMIN_MASSWAR_RUNNING.sendMessage(sender);
                    return CommandResult.FAILED;
                }
                masswar.runAndRenew();
                break;
            }
            case "resume": {
                if (state == ProlongedDurationTask.State.NOT_STARTED) {
                    KingdomsLang.COMMAND_ADMIN_MASSWAR_NOT_RUNNING.sendMessage(sender);
                    return CommandResult.FAILED;
                }
                if (state != ProlongedDurationTask.State.PAUSED) {
                    KingdomsLang.COMMAND_ADMIN_MASSWAR_NOT_PAUSED.sendMessage(sender);
                    return CommandResult.FAILED;
                }
                masswar.resume();
                break;
            }
            case "pause": {
                if (state == ProlongedDurationTask.State.NOT_STARTED) {
                    KingdomsLang.COMMAND_ADMIN_MASSWAR_NOT_RUNNING.sendMessage(sender);
                    return CommandResult.FAILED;
                }
                if (state == ProlongedDurationTask.State.PAUSED) {
                    KingdomsLang.COMMAND_ADMIN_MASSWAR_ALREADY_PAUSED.sendMessage(sender);
                    return CommandResult.FAILED;
                }
                masswar.pause();
                break;
            }
            case "end": {
                if (state == ProlongedDurationTask.State.NOT_STARTED) {
                    KingdomsLang.COMMAND_ADMIN_MASSWAR_NOT_RUNNING.sendMessage(sender);
                    return CommandResult.FAILED;
                }
                masswar.stop();
                break;
            }
            default: {
                KingdomsLang.COMMAND_ADMIN_MASSWAR_USAGE.sendMessage(sender);
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return Arrays.asList("start", "end", "resume", "pause");
    }
}

