/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.CommandAdminLanguagePacksInstall;
import org.kingdoms.commands.admin.CommandAdminLanguagePacksUninstall;
import org.kingdoms.commands.admin.CommandAdminLanguagePacksUpdate;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.ArrayIteratorKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.profiles.builder.ProfileInstruction;
import org.kingdoms.libs.xseries.profiles.builder.XSkull;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.locale.ContextualMessageSender;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.LanguagePackDownloader;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.TextProgressBar;
import org.kingdoms.utils.cache.RunnableCountDownLatch;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.network.CommitDifference;
import org.kingdoms.utils.network.JSONRequester;
import org.kingdoms.utils.string.tree.StringPathBuilder;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.TreeColorScheme;
import org.kingdoms.utils.string.tree.TreeStyle;
import org.kingdoms.utils.string.tree.TreeTokenType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminLanguagePack;", "Lorg/kingdoms/commands/KingdomsParentCommand;", "parent", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandAdminLanguagePack
extends KingdomsParentCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final QuickEnumMap<SupportedLanguage, CommitDifference> UPDATES = new QuickEnumMap((Enum[])SupportedLanguage.VALUES);
    @Nullable
    private static String lastCheckedCommit;
    @NotNull
    private static AtomicReference<String> inProgress;
    private static final Map<TreeColorScheme, String> DEFAULT_COLOR_SET;
    @NotNull
    private static final TreeStyle TREE_STYLE;
    @NotNull
    private static final TreeStyle TREE_STYLE_NO_LIMIT;

    public CommandAdminLanguagePack(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("languagepack", parent);
        new CommandAdminLanguagePacksInstall(this);
        new CommandAdminLanguagePacksUpdate(this);
        new CommandAdminLanguagePacksUninstall(this);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            Kingdoms.taskScheduler().async().execute(() -> CommandAdminLanguagePack.execute$lambda$0(context));
            return CommandResult.SUCCESS;
        }
        CommandResult commandResult = super.execute(context);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"execute(...)");
        return commandResult;
    }

    private static final void execute$lambda$0(CommandContext $context) {
        Player player = $context.senderAsPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"senderAsPlayer(...)");
        Companion.openGUI(player);
    }

    @JvmStatic
    @Nullable
    public static final SupportedLanguage getLanguageParameter(@NotNull CommandContext context) {
        return Companion.getLanguageParameter(context);
    }

    @JvmStatic
    @NotNull
    public static final List<String> tabCompleteLanguages(@NotNull CommandTabContext context, @NotNull Predicate<SupportedLanguage> onlyIf) {
        return Companion.tabCompleteLanguages(context, onlyIf);
    }

    @JvmStatic
    public static final boolean checkForUpdates() {
        return Companion.checkForUpdates();
    }

    @JvmStatic
    public static final void notifyAboutUpdates(@NotNull CommandSender sender) {
        Companion.notifyAboutUpdates(sender);
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<Void> createLanguageProcessor(@NotNull ContextualMessageSender context, @NotNull SupportedLanguage lang, @Nullable CommitDifference difference) {
        return Companion.createLanguageProcessor(context, lang, difference);
    }

    @JvmStatic
    public static final boolean indexLanguages(@NotNull CommandSender sender) {
        return Companion.indexLanguages(sender);
    }

    @JvmStatic
    public static final void openGUI(@NotNull Player player) {
        Companion.openGUI(player);
    }

    @JvmStatic
    public static final void uninstall(@NotNull CommandSender player, @NotNull SupportedLanguage lang) {
        Companion.uninstall(player, lang);
    }

    @JvmStatic
    public static final boolean downloadOrUpdate(@Nullable Boolean strictDownload, @NotNull CommandSender player, @NotNull SupportedLanguage lang, @NotNull ContextualMessageSender messenger) {
        return Companion.downloadOrUpdate(strictDownload, player, lang, messenger);
    }

    @JvmStatic
    public static final void showInfo(@NotNull CommandSender player, @Nullable CommitDifference diff) {
        Companion.showInfo(player, diff);
    }

    static {
        inProgress = new AtomicReference();
        Object object = new EnumMap<TreeColorScheme, String>(TreeColorScheme.class);
        EnumMap<TreeColorScheme, String> $this$DEFAULT_COLOR_SET_u24lambda_u241 = object;
        boolean bl = false;
        $this$DEFAULT_COLOR_SET_u24lambda_u241.put((TreeColorScheme)((Enum)TreeColorScheme.INDICATORS), ChatColor.DARK_GRAY.toString());
        $this$DEFAULT_COLOR_SET_u24lambda_u241.put((TreeColorScheme)((Enum)TreeColorScheme.PATH_SEPARATORS), ChatColor.GRAY.toString());
        $this$DEFAULT_COLOR_SET_u24lambda_u241.put((TreeColorScheme)((Enum)TreeColorScheme.ENTRIES), ChatColor.BLUE.toString());
        DEFAULT_COLOR_SET = Collections.unmodifiableMap((Map)object);
        Map<TreeTokenType, String> map = StringTree.Companion.getUTF_CHARACTER_SET();
        Map<TreeColorScheme, String> map2 = DEFAULT_COLOR_SET;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"DEFAULT_COLOR_SET");
        Object $this$TREE_STYLE_u24lambda_u242 = object = new TreeStyle(map, map2);
        boolean bl2 = false;
        ((TreeStyle)$this$TREE_STYLE_u24lambda_u242).setFlatten(true);
        ((TreeStyle)$this$TREE_STYLE_u24lambda_u242).setIndentation(1);
        ((TreeStyle)$this$TREE_STYLE_u24lambda_u242).setMaxEntries(10);
        ((TreeStyle)$this$TREE_STYLE_u24lambda_u242).setMaxNestLevel(8);
        TREE_STYLE = object;
        Map<TreeTokenType, String> map3 = StringTree.Companion.getUTF_CHARACTER_SET();
        Map<TreeColorScheme, String> map4 = DEFAULT_COLOR_SET;
        Intrinsics.checkNotNullExpressionValue(map4, (String)"DEFAULT_COLOR_SET");
        Object $this$TREE_STYLE_NO_LIMIT_u24lambda_u243 = object = new TreeStyle(map3, map4);
        boolean bl3 = false;
        ((TreeStyle)$this$TREE_STYLE_NO_LIMIT_u24lambda_u243).setFlatten(true);
        ((TreeStyle)$this$TREE_STYLE_NO_LIMIT_u24lambda_u243).setIndentation(1);
        TREE_STYLE_NO_LIMIT = object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u001a\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0007J\b\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007J(\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001a\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00062\b\u0010,\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010-\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0007J\u0018\u00101\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u00020*H\u0002J\u0018\u00103\u001a\u00020$2\u0006\u0010/\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0006H\u0007J/\u00104\u001a\u00020\"2\b\u00105\u001a\u0004\u0018\u00010\"2\u0006\u0010/\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00062\u0006\u00102\u001a\u00020*H\u0007\u00a2\u0006\u0002\u00106J\u001a\u00107\u001a\u00020$2\u0006\u0010/\u001a\u00020&2\b\u00108\u001a\u0004\u0018\u00010\u0007H\u0007R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000RP\u0010\u000e\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000b0\u000b \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00120\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminLanguagePack$Companion;", "", "<init>", "()V", "UPDATES", "Lorg/kingdoms/utils/internal/enumeration/QuickEnumMap;", "Lorg/kingdoms/locale/SupportedLanguage;", "Lorg/kingdoms/utils/network/CommitDifference;", "getUPDATES$core", "()Lorg/kingdoms/utils/internal/enumeration/QuickEnumMap;", "lastCheckedCommit", "", "inProgress", "Ljava/util/concurrent/atomic/AtomicReference;", "DEFAULT_COLOR_SET", "", "Lorg/kingdoms/utils/string/tree/TreeColorScheme;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "", "Ljava/util/Map;", "TREE_STYLE", "Lorg/kingdoms/utils/string/tree/TreeStyle;", "getTREE_STYLE", "()Lorg/kingdoms/utils/string/tree/TreeStyle;", "TREE_STYLE_NO_LIMIT", "getLanguageParameter", "context", "Lorg/kingdoms/commands/CommandContext;", "tabCompleteLanguages", "", "Lorg/kingdoms/commands/CommandTabContext;", "onlyIf", "Ljava/util/function/Predicate;", "checkForUpdates", "", "notifyAboutUpdates", "", "sender", "Lorg/bukkit/command/CommandSender;", "createLanguageProcessor", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Lorg/kingdoms/locale/ContextualMessageSender;", "lang", "difference", "indexLanguages", "openGUI", "player", "Lorg/bukkit/entity/Player;", "downloadAll", "messenger", "uninstall", "downloadOrUpdate", "strictDownload", "(Ljava/lang/Boolean;Lorg/bukkit/command/CommandSender;Lorg/kingdoms/locale/SupportedLanguage;Lorg/kingdoms/locale/ContextualMessageSender;)Z", "showInfo", "diff", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandAdminLanguagePack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminLanguagePack.kt\norg/kingdoms/commands/admin/CommandAdminLanguagePack$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,488:1\n3829#2:489\n4344#2,2:490\n1557#3:492\n1628#3,3:493\n1557#3:503\n1628#3,3:504\n1557#3:507\n1628#3,3:508\n535#4:496\n520#4,6:497\n*S KotlinDebug\n*F\n+ 1 CommandAdminLanguagePack.kt\norg/kingdoms/commands/admin/CommandAdminLanguagePack$Companion\n*L\n144#1:489\n144#1:490,2\n145#1:492\n145#1:493,3\n480#1:503\n480#1:504,3\n310#1:507\n310#1:508,3\n180#1:496\n180#1:497,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QuickEnumMap<SupportedLanguage, CommitDifference> getUPDATES$core() {
            return UPDATES;
        }

        @NotNull
        public final TreeStyle getTREE_STYLE() {
            return TREE_STYLE;
        }

        @JvmStatic
        @Nullable
        public final SupportedLanguage getLanguageParameter(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CommandSender commandSender = context.getMessageReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getMessageReceiver(...)");
            if (!this.indexLanguages(commandSender)) {
                return null;
            }
            String languageName = context.nextString();
            context.var("language_pack", languageName);
            SupportedLanguage language = SupportedLanguage.fromName(languageName);
            if (language == null) {
                context.fail(KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_UNKNOWN_LANGUAGEPACK);
                return null;
            }
            context.var("language_pack", language.getNativeName());
            return language;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> tabCompleteLanguages(@NotNull CommandTabContext context, @NotNull Predicate<SupportedLanguage> onlyIf) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(onlyIf, (String)"onlyIf");
            Intrinsics.checkNotNullExpressionValue((Object)SupportedLanguage.VALUES, (String)"VALUES");
            Object[] objectArray = SupportedLanguage.VALUES;
            boolean $i$f$filter = false;
            void var6_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (SupportedLanguage element$iv$iv : $this$filterTo$iv$iv) {
                SupportedLanguage x = element$iv$iv;
                boolean bl = false;
                if (!(x != SupportedLanguage.EN && onlyIf.test(x))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                SupportedLanguage element$iv$iv;
                element$iv$iv = (SupportedLanguage)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(x.getNativeName());
            }
            List suggest = (List)destination$iv$iv;
            List<String> list = context.tabComplete((Collection<String>)context.tabComplete(suggest));
            Intrinsics.checkNotNullExpressionValue(list, (String)"tabComplete(...)");
            return list;
        }

        @JvmStatic
        public final boolean checkForUpdates() {
            Object object;
            try {
                object = JSONRequester.getMASTER_SHA().get();
            }
            catch (Exception ex) {
                KLogger.warn("Failed to get the latest language pack information: " + ex.getMessage());
                return false;
            }
            String latestCommit = object;
            object = ArrayIteratorKt.iterator((Object[])SupportedLanguage.VALUES);
            while (object.hasNext()) {
                SupportedLanguage lang = (SupportedLanguage)object.next();
                if (lang == Language.Companion.getDefault() || !lang.isInstalled() || Intrinsics.areEqual((Object)lang.getInstalledCommitSHA(), (Object)latestCommit) || Intrinsics.areEqual((Object)lastCheckedCommit, (Object)latestCommit)) continue;
                String string = lang.getInstalledCommitSHA();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstalledCommitSHA(...)");
                String[] stringArray = new String[]{"resources/languages/" + lang.getLowerCaseName() + '/'};
                CommitDifference diff = JSONRequester.getDifference(string, stringArray);
                if (!(!((Collection)diff.getFiles()).isEmpty())) continue;
                ((Map)this.getUPDATES$core()).put(lang, diff);
            }
            lastCheckedCommit = latestCommit;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void notifyAboutUpdates(@NotNull CommandSender sender) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            if (this.getUPDATES$core().isEmpty()) {
                return;
            }
            boolean isPlayer = sender instanceof Player;
            Map map = this.getUPDATES$core();
            StringBuilder stringBuilder = new StringBuilder().append("{$p}");
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry x = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!((SupportedLanguage)x.getKey()).isInstalled()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            String list = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)destination$iv$iv.entrySet(), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> Companion.notifyAboutUpdates$lambda$3(isPlayer, arg_0), (int)30, null)).toString();
            MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider().parse("update", list);
            Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"parse(...)");
            KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_NOTIFICATION.sendMessage(sender, messagePlaceholderProvider);
        }

        @JvmStatic
        @NotNull
        public final CompletableFuture<Void> createLanguageProcessor(@NotNull ContextualMessageSender context, @NotNull SupportedLanguage lang, @Nullable CommitDifference difference) {
            LanguagePackDownloader languagePackDownloader;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            LanguagePackDownloader downloader = new LanguagePackDownloader(lang);
            downloader.update(difference);
            context.getMessageContext().raw("lang", lang.getLowerCaseName());
            BossBar bossbar = null;
            AtomicInteger downloaded = new AtomicInteger();
            int totalFiles = downloader.getTotalFiles();
            if (context.isPlayer()) {
                bossbar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
                CommandSender commandSender = context.getMessageReceiver();
                Intrinsics.checkNotNull((Object)commandSender, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
                Player player = (Player)commandSender;
                bossbar.addPlayer(player);
                bossbar.setProgress(0.0);
                context.getMessageContext().raw("total", totalFiles);
                org.kingdoms.commands.admin.CommandAdminLanguagePack$Companion.createLanguageProcessor$updateBossBarTitle(context, downloaded, bossbar);
                languagePackDownloader = downloader.onFileStateChange(arg_0 -> Companion.createLanguageProcessor$lambda$4(bossbar, downloaded, totalFiles, context, arg_0));
            } else {
                bossbar = null;
                Ref.DoubleRef lastProgress = new Ref.DoubleRef();
                languagePackDownloader = downloader.onFileStateChange(arg_0 -> Companion.createLanguageProcessor$lambda$5(downloaded, totalFiles, lastProgress, context, arg_0));
            }
            CompletionStage completionStage = downloader.downloadAsync().thenRun(() -> Companion.createLanguageProcessor$lambda$6(downloader, context, bossbar));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenRun(...)");
            return completionStage;
        }

        @JvmStatic
        public final boolean indexLanguages(@NotNull CommandSender sender) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_INDEXING.sendMessage(sender);
            if (!this.checkForUpdates()) {
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_INDEXING_FAILED.sendError(sender, new Object[0]);
                return false;
            }
            return true;
        }

        @JvmStatic
        public final void openGUI(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.LANGUAGE$PACKS);
            if (!this.indexLanguages((CommandSender)player)) {
                return;
            }
            ReusableOptionHandler reusableOptionHandler = gui.getReusableOption("languages");
            Intrinsics.checkNotNull((Object)reusableOptionHandler);
            ReusableOptionHandler languages = reusableOptionHandler;
            Language language = Language.Companion.getDefault();
            String string = KingdomsGUI.LANGUAGES.getGUIPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGUIPath(...)");
            GUIObject gUIObject = language.getGUIOrDefault(string, false);
            Intrinsics.checkNotNull((Object)gUIObject);
            Object object = new String[]{"skulls"};
            ConfigSection skulls = gUIObject.getConfig().getConfig().getSection((String[])object);
            object = ArrayIteratorKt.iterator((Object[])SupportedLanguage.VALUES);
            while (object.hasNext()) {
                SupportedLanguage lang = (SupportedLanguage)object.next();
                if (lang == Language.Companion.getDefault()) continue;
                CommitDifference diff = this.getUPDATES$core().get(lang);
                boolean updated = diff == null;
                Object[] objectArray = new Object[]{"lang", lang.name(), "native-name", lang.getNativeName(), "installed", lang.isInstalled(), "updated", updated};
                languages.setEdits(objectArray);
                languages.editItem(arg_0 -> Companion.openGUI$lambda$8(skulls, lang, updated, diff, arg_0));
                if (lang.isInstalled() && !updated) {
                    languages.on(ClickType.MIDDLE, () -> Companion.openGUI$lambda$9(player, diff));
                }
                if (!lang.isInstalled() || !updated) {
                    languages.on(ClickType.LEFT, () -> Companion.openGUI$lambda$10(player, lang, gui));
                }
                if (lang.isInstalled()) {
                    languages.on(ClickType.RIGHT, () -> Companion.openGUI$lambda$11(player, lang));
                }
                languages.done();
            }
            gui.push("download-all", () -> Companion.openGUI$lambda$12(player, gui), new Object[0]);
            InteractiveGUI.open$default(gui, false, false, 3, null);
        }

        private final void downloadAll(Player player, ContextualMessageSender messenger) {
            KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_ALL.sendError((CommandSender)player, new Object[0]);
            inProgress.set("download all");
            RunnableCountDownLatch latch = new RunnableCountDownLatch(1, arg_0 -> Companion.downloadAll$lambda$13(player, arg_0));
            Iterator iterator = ArrayIteratorKt.iterator((Object[])SupportedLanguage.VALUES);
            while (iterator.hasNext()) {
                SupportedLanguage lang = (SupportedLanguage)iterator.next();
                if (lang == Language.Companion.getDefault()) continue;
                CommitDifference updateInfo = this.getUPDATES$core().get(lang);
                if (lang.isInstalled() && updateInfo == null) continue;
                latch.increase();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> Companion.downloadAll$lambda$16(lang, player, messenger, updateInfo, latch));
            }
            latch.countDown();
        }

        @JvmStatic
        public final void uninstall(@NotNull CommandSender player, @NotNull SupportedLanguage lang) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            if (!lang.isInstalled()) {
                Object[] objectArray = new Object[]{"lang", lang.getNativeName()};
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_UNINSTALL_NOT_INSTALLED.sendError(player, objectArray);
                return;
            }
            if (inProgress.get() != null) {
                Object[] objectArray = new Object[]{"current_process", inProgress.get()};
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_IN_PROGRESS.sendError(player, objectArray);
                return;
            }
            inProgress.set("Uninstalling " + lang.getNativeName());
            Object[] objectArray = new Object[]{"lang", lang.getNativeName()};
            KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_UNINSTALL_UNINSTALLING.sendMessage(player, objectArray);
            LanguageManager.uninstall(lang);
            inProgress.set(null);
        }

        @JvmStatic
        public final boolean downloadOrUpdate(@Nullable Boolean strictDownload, @NotNull CommandSender player, @NotNull SupportedLanguage lang, @NotNull ContextualMessageSender messenger) {
            CompletionStage completionStage;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
            CommitDifference diff = this.getUPDATES$core().get(lang);
            if (inProgress.get() != null) {
                Object[] objectArray = new Object[]{"current_process", inProgress.get()};
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_IN_PROGRESS.sendError(player, objectArray);
                return true;
            }
            if (strictDownload != null) {
                if (strictDownload.booleanValue() && lang.isInstalled()) {
                    messenger.sendError(KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_ALREADY_INSTALLED, new Object[0]);
                    return true;
                }
                if (!strictDownload.booleanValue() && !lang.isInstalled()) {
                    messenger.sendError(KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_NOT_INSTALLED, new Object[0]);
                    return true;
                }
            }
            Boolean bl = strictDownload;
            String name = bl == null ? "Downloading" : (bl != false ? "Installing" : "Updating");
            inProgress.set(name + ' ' + lang.getNativeName());
            RunnableCountDownLatch latch = new RunnableCountDownLatch(1, arg_0 -> Companion.downloadOrUpdate$lambda$17(lang, arg_0));
            if (lang.isInstalled()) {
                StringBuilder stringBuilder = new StringBuilder().append("Updating language pack: ").append(lang).append(' ');
                CommitDifference commitDifference = diff;
                Intrinsics.checkNotNull((Object)commitDifference);
                KLogger.info(stringBuilder.append(commitDifference.getHeadSHA()).toString());
                Object[] objectArray = new Object[]{"lang", lang.getLowerCaseName()};
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_UPDATING.sendMessage(player, objectArray);
                completionStage = this.createLanguageProcessor(messenger, lang, diff).thenRun(() -> Companion.downloadOrUpdate$lambda$18(latch));
            } else {
                KLogger.info("Installing language pack: " + lang + ' ' + lastCheckedCommit);
                completionStage = this.createLanguageProcessor(messenger, lang, null).thenRun(() -> Companion.downloadOrUpdate$lambda$19(latch));
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void showInfo(@NotNull CommandSender player, @Nullable CommitDifference diff) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            CommitDifference commitDifference = diff;
            Intrinsics.checkNotNull((Object)commitDifference);
            Iterable $this$map$iv = commitDifference.getFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void x;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)x, (String)"guis/", (boolean)false, (int)2, null)) {
                    String string3 = x.substring(5);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string = x;
                }
                collection.add(string);
            }
            List files = (List)destination$iv$iv;
            Iterator<StringBuilder> iterator = new StringPathBuilder(files).toStringTree(TREE_STYLE_NO_LIMIT).print().getLines().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<StringBuilder> iterator2 = iterator;
            while (iterator2.hasNext()) {
                StringBuilder line;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                player.sendMessage(line.toString());
            }
        }

        private static final CharSequence notifyAboutUpdates$lambda$3(boolean $isPlayer, Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            SupportedLanguage lang = (SupportedLanguage)entry.getKey();
            CommitDifference diff = (CommitDifference)entry.getValue();
            return $isPlayer ? (CharSequence)("  {$sep}\u25cf {$p}" + lang + " {$s}" + diff.getBaseSHA() + " {$sep}\u279c {$s}" + lastCheckedCommit) : (CharSequence)("  {$sep}| {$p}" + lang + " {$s}" + diff.getBaseSHA() + " {$sep}-> {$s}" + lastCheckedCommit);
        }

        private static final void createLanguageProcessor$updateBossBarTitle(ContextualMessageSender $context, AtomicInteger downloaded, BossBar bossbar) {
            $context.getMessageContext().raw("downloaded", downloaded.get());
            bossbar.setTitle(KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_PROGRESS.parse($context.getMessageContext()));
        }

        private static final void createLanguageProcessor$lambda$4(BossBar $bossbar, AtomicInteger $downloaded, int $totalFiles, ContextualMessageSender $context, LanguagePackDownloader.Downloader it) {
            if (it.state != LanguagePackDownloader.DownloadState.RETRYING) {
                $bossbar.setProgress((double)$downloaded.incrementAndGet() / (double)$totalFiles);
                org.kingdoms.commands.admin.CommandAdminLanguagePack$Companion.createLanguageProcessor$updateBossBarTitle($context, $downloaded, $bossbar);
            }
        }

        private static final void createLanguageProcessor$lambda$5(AtomicInteger $downloaded, int $totalFiles, Ref.DoubleRef $lastProgress, ContextualMessageSender $context, LanguagePackDownloader.Downloader it) {
            double progress = (double)$downloaded.incrementAndGet() / (double)$totalFiles;
            double diff = progress - $lastProgress.element;
            if (diff > 0.1 || progress == 1.0) {
                $lastProgress.element = progress;
                if (it.state != LanguagePackDownloader.DownloadState.RETRYING) {
                    TextProgressBar textProgress = new TextProgressBar(progress, 10);
                    $context.var("progress", textProgress.progressMessage());
                    $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_PROGRESS_BAR, new Object[0]);
                }
            }
        }

        private static final void createLanguageProcessor$lambda$6(LanguagePackDownloader $downloader, ContextualMessageSender $context, BossBar $bossbar) {
            Map<LanguagePackDownloader.DownloadState, List<LanguagePackDownloader.Downloader>> downloads = $downloader.getDownloads();
            List<LanguagePackDownloader.Downloader> list = downloads.get((Object)LanguagePackDownloader.DownloadState.DONE);
            int done = list != null ? list.size() : 0;
            List<LanguagePackDownloader.Downloader> list2 = downloads.get((Object)LanguagePackDownloader.DownloadState.FAILED_RETRYING);
            int failedRetrying = list2 != null ? list2.size() : 0;
            List<LanguagePackDownloader.Downloader> list3 = downloads.get((Object)LanguagePackDownloader.DownloadState.FAILED_CRITICAL);
            int failedCritical = list3 != null ? list3.size() : 0;
            List<LanguagePackDownloader.Downloader> list4 = downloads.get((Object)LanguagePackDownloader.DownloadState.NOT_FOUND);
            int notFound = list4 != null ? list4.size() : 0;
            $context.getMessageContext().raw("downloads_done", done).raw("downloads_failed_retrying", failedRetrying).raw("downloads_failed_critical", failedCritical).raw("downloads_notFound", notFound);
            BossBar bossBar = $bossbar;
            if (bossBar != null) {
                bossBar.removeAll();
            }
            $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_DONE, new Object[0]);
            if (failedRetrying > 0 || failedCritical > 0 || notFound > 0) {
                $context.sendError(KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_DONE_ERROR, new Object[0]);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final ItemStack openGUI$lambda$8(ConfigSection $skulls, SupportedLanguage $lang, boolean $updated, CommitDifference $diff, ItemStack item) {
            ItemMeta itemMeta = item.getItemMeta();
            Intrinsics.checkNotNull((Object)itemMeta);
            ItemMeta meta = itemMeta;
            ProfileInstruction profileInstruction = XSkull.of((ItemMeta)meta);
            String string = $skulls.getString($lang.getLowerCaseName());
            if (string == null) {
                string = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGZkNWJkZTk5NGUwYTY0N2FmMTgyMzY4MWE2MTNjMmJmYzNkOTczNmY4ODlkYmY4YzNiYmJhNWExM2Y4ZWQifX19";
            }
            profileInstruction.profile(Profileable.detect((String)string)).apply();
            if ($lang.isInstalled() && !$updated) {
                void $this$mapTo$iv$iv;
                List list = meta.getLore();
                if (list == null) {
                    list = new ArrayList();
                }
                List lore = list;
                CommitDifference commitDifference = $diff;
                Intrinsics.checkNotNull((Object)commitDifference);
                Iterable $this$map$iv = commitDifference.getFiles();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2;
                    void x;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)x, (String)"guis/", (boolean)false, (int)2, null)) {
                        String string4 = x.substring(5);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    } else {
                        string2 = x;
                    }
                    collection.add(string2);
                }
                List files = (List)destination$iv$iv;
                Iterator<StringBuilder> iterator = new StringPathBuilder(files).toStringTree(Companion.getTREE_STYLE()).print().getLines().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<StringBuilder> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    StringBuilder line;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    lore.add(line.toString());
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }

        private static final void openGUI$lambda$9(Player $player, CommitDifference $diff) {
            $player.closeInventory();
            Companion.showInfo((CommandSender)$player, $diff);
        }

        private static final void openGUI$lambda$10(Player $player, SupportedLanguage $lang, InteractiveGUI $gui) {
            $player.closeInventory();
            CommandSender commandSender = (CommandSender)$player;
            Intrinsics.checkNotNull((Object)$lang);
            Intrinsics.checkNotNull((Object)$gui);
            Companion.downloadOrUpdate(null, commandSender, $lang, $gui);
        }

        private static final void openGUI$lambda$11(Player $player, SupportedLanguage $lang) {
            $player.closeInventory();
            CommandSender commandSender = (CommandSender)$player;
            Intrinsics.checkNotNull((Object)$lang);
            Companion.uninstall(commandSender, $lang);
        }

        private static final void openGUI$lambda$12(Player $player, InteractiveGUI $gui) {
            $player.closeInventory();
            Intrinsics.checkNotNull((Object)$gui);
            Companion.downloadAll($player, $gui);
        }

        private static final void downloadAll$lambda$13(Player $player, RunnableCountDownLatch it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.getTotal().get() == 1) {
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_ALL_NO_ACTION_NEEDED.sendMessage((CommandSender)$player);
            } else {
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_ALL_DONE.sendError((CommandSender)$player, new Object[0]);
            }
            inProgress.set(null);
        }

        private static final void downloadAll$lambda$16$lambda$14(RunnableCountDownLatch $latch) {
            $latch.countDown();
        }

        private static final void downloadAll$lambda$16$lambda$15(RunnableCountDownLatch $latch) {
            $latch.countDown();
        }

        private static final void downloadAll$lambda$16(SupportedLanguage $lang, Player $player, ContextualMessageSender $messenger, CommitDifference $updateInfo, RunnableCountDownLatch $latch) {
            CompletionStage completionStage;
            Object[] objectArray;
            if ($lang.isInstalled()) {
                objectArray = new Object[]{"lang", $lang.getLowerCaseName()};
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_UPDATING.sendMessage((CommandSender)$player, objectArray);
                Intrinsics.checkNotNull((Object)$lang);
                completionStage = Companion.createLanguageProcessor($messenger, $lang, $updateInfo).thenRun(() -> Companion.downloadAll$lambda$16$lambda$14($latch));
            } else {
                objectArray = new Object[]{"lang", $lang.getLowerCaseName()};
                KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_DOWNLOADING.sendMessage((CommandSender)$player, objectArray);
                Intrinsics.checkNotNull((Object)$lang);
                completionStage = Companion.createLanguageProcessor($messenger, $lang, null).thenRun(() -> Companion.downloadAll$lambda$16$lambda$15($latch));
            }
            objectArray = new Object[]{"lang", $lang.getLowerCaseName()};
            KingdomsLang.COMMAND_ADMIN_LANGUAGEPACK_DONE.sendMessage((CommandSender)$player, objectArray);
            $latch.countDown();
        }

        private static final void downloadOrUpdate$lambda$17(SupportedLanguage $lang, RunnableCountDownLatch it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            inProgress.set(null);
            Companion.getUPDATES$core().remove($lang);
        }

        private static final void downloadOrUpdate$lambda$18(RunnableCountDownLatch $latch) {
            $latch.countDown();
        }

        private static final void downloadOrUpdate$lambda$19(RunnableCountDownLatch $latch) {
            $latch.countDown();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

