/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;

public class CommandAdminHome
extends KingdomsCommand {
    public CommandAdminHome(KingdomsParentCommand parent) {
        super("home", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Location home;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (!context.assertArgs(1)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_HOME_USAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Location location = home = kingdom.getHome() == null ? null : BukkitAdapter.adapt(kingdom.getHome());
        if (home == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_HOME_HOMELESS, "kingdom", kingdom.getName());
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        player.teleport(home);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_HOME_TELEPORTED, "kingdom", kingdom.getName());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        return context.emptyTab();
    }
}

