/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Collection;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.commands.ConfigCommand;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.conditions.ConditionProcessor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminForeach;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminForeach.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminForeach.kt\norg/kingdoms/commands/admin/CommandAdminForeach\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1863#2,2:87\n1863#2,2:89\n*S KotlinDebug\n*F\n+ 1 CommandAdminForeach.kt\norg/kingdoms/commands/admin/CommandAdminForeach\n*L\n33#1:87,2\n42#1:89,2\n*E\n"})
public final class CommandAdminForeach
extends KingdomsCommand {
    public CommandAdminForeach(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("forEach", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(3)) {
            return CommandResult.FAILED;
        }
        try {
            String string = context.required("contextType");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"required(...)");
            String contextType = string;
            String string2 = context.required("command");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"required(...)");
            String commandStr = string2;
            String conditionStr = context.optional("condition");
            CharSequence charSequence = conditionStr;
            ConditionalCompiler.LogicalOperand condition = charSequence == null || charSequence.length() == 0 ? null : ConditionalCompiler.compile(conditionStr).evaluate();
            Object object = new String[]{commandStr};
            List<ConfigCommand> command = ConfigCommand.parse(CollectionsKt.arrayListOf((Object[])object));
            switch (contextType) {
                case "allKingdoms": {
                    Collection collection = Kingdoms.get().getDataCenter().getKingdomManager().peekAllData();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"peekAllData(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Kingdom kingdom = (Kingdom)element$iv;
                        boolean bl = false;
                        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(kingdom);
                        if (condition != null && !ConditionProcessor.process(condition, settings)) continue;
                        ConfigCommand.execute(null, (Collection<ConfigCommand>)command, settings, false);
                    }
                    break;
                }
                case "allNations": {
                    Collection collection = Kingdoms.get().getDataCenter().getNationManager().peekAllData();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"peekAllData(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Nation nation = (Nation)element$iv;
                        boolean bl = false;
                        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(nation);
                        if (condition != null && !ConditionProcessor.process(condition, settings)) continue;
                        ConfigCommand.execute(null, (Collection<ConfigCommand>)command, settings, false);
                    }
                    break;
                }
                case "kingdomsInNation": {
                    String string3 = context.required("context");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"required(...)");
                    String contextStr = string3;
                    Nation nation = Nation.getNation(contextStr);
                    context.var("nation", contextStr);
                    if (nation == null) {
                        CommandResult commandResult = context.fail(KingdomsLang.NOT_FOUND_NATION);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                        return commandResult;
                    }
                    for (Kingdom kingdom : nation.getKingdoms()) {
                        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(kingdom);
                        if (condition != null && !ConditionProcessor.process(condition, settings)) continue;
                        ConfigCommand.execute(null, (Collection<ConfigCommand>)command, settings, false);
                    }
                    break;
                }
                case "playersInKingdom": {
                    String string4 = context.required("context");
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"required(...)");
                    String contextStr = string4;
                    Kingdom kingdom = Kingdom.getKingdom(contextStr);
                    context.var("kingdom", contextStr);
                    if (kingdom == null) {
                        CommandResult commandResult = context.fail(KingdomsLang.NOT_FOUND_KINGDOM);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                        return commandResult;
                    }
                    for (OfflinePlayer member : kingdom.getPlayerMembers()) {
                        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(member);
                        if (condition != null && !ConditionProcessor.process(condition, settings)) continue;
                        ConfigCommand.execute(member.getPlayer(), (Collection<ConfigCommand>)command, settings, true);
                    }
                    break;
                }
                default: {
                    CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_FOREACH_UNKNOWN_CONTEXT_TYPE);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                    return commandResult;
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while running command: '" + context.args + "' ", ex);
        }
        return CommandResult.SUCCESS;
    }
}

