/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.daily.DailyChecksManager;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public class CommandAdminDailyChecks
extends KingdomsCommand {
    public CommandAdminDailyChecks(KingdomsParentCommand parent) {
        super("dailychecks", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertArgs(1)) {
            switch (context.arg(0).toLowerCase(Locale.ENGLISH)) {
                case "run": {
                    context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_RUN, new Object[0]);
                    Kingdoms.taskScheduler().async().execute(() -> DailyChecksManager.getInstance().runAndRenew());
                    return CommandResult.FAILED;
                }
                case "skip": {
                    if (DailyChecksManager.getInstance().isSkipping()) {
                        context.sendError(KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_SKIPPED, new Object[0]);
                        return CommandResult.FAILED;
                    }
                    context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_SKIP, new Object[0]);
                    DailyChecksManager.getInstance().setSkipped(true);
                    return CommandResult.FAILED;
                }
                case "resume": {
                    if (!DailyChecksManager.getInstance().isSkipping()) {
                        context.sendError(KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_RESUMED, new Object[0]);
                        return CommandResult.FAILED;
                    }
                    context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_RESUME, new Object[0]);
                    DailyChecksManager.getInstance().setSkipped(false);
                    return CommandResult.FAILED;
                }
            }
            context.sendError(KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_USAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        LocalDateTime lastPerform = DailyChecksManager.getInstance().lastPerform();
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_DAILYCHECKS_INFO, "next", TimeFormatter.of(DailyChecksManager.getInstance().untilNextRun(ChronoUnit.MILLIS)), "daily_checks", TimeZoneHandler.DAILY_CHECKS.toString(), "time", TimeUtils.TIME_FORMAT.format(LocalTime.now(TimeZoneHandler.SERVER_TIME_ZONE)), "last_perform", lastPerform == null ? KingdomsLang.NONE : lastPerform, "state", DailyChecksManager.getInstance().isSkipping() ? "&4Skip" : "&2Ongoing");
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandAdminDailyChecks.tabComplete("run", "skip", "resume");
        }
        return CommandAdminDailyChecks.emptyTab();
    }
}

