/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandAdminBank
extends KingdomsCommand {
    public CommandAdminBank(KingdomsParentCommand parent) {
        super("bank", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom = (Kingdom)context.generalSelector(false);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Balance old = kingdom.getBank();
        AnyNumber result = context.numberModifier("money", old.get(), new NumberConstraint[0]);
        old.set(result.getValue());
        context.getMessageContext().withContext(kingdom).raws("bank", Numbers.toFancyNumber(old.get()), "kingdom", kingdom.getName());
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BANK_DONE, new Object[0]);
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_ADMIN_BANK_ADDED.sendMessage((CommandSender)member, context.getMessageContext());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, false, null).then(() -> context.tabCompleteNumberModifier("money", new NumberConstraint[0])).build();
    }
}

