/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.utils.PaginatedCommandHelp;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.internal.functional.Fn;

public abstract class KingdomsParentCommand
extends KingdomsCommand {
    protected final Map<Language, Map<String, KingdomsCommand>> children = (Map)Fn.cast(new QuickEnumMap((Enum[])SupportedLanguage.VALUES));

    public KingdomsParentCommand(@NonNull String name, @Nullable KingdomsParentCommand parent, PermissionDefault permissionDefault) {
        super(name, parent, permissionDefault);
    }

    public KingdomsParentCommand(@NonNull String name, @Nullable KingdomsParentCommand parent) {
        super(name, parent, null);
    }

    public KingdomsParentCommand(@NonNull String name, boolean playerCmd) {
        super(name, playerCmd);
    }

    public KingdomsParentCommand(@NonNull String name) {
        super(name, false);
    }

    public final @NonNull Collection<KingdomsCommand> getChildren(Language language) {
        return Objects.requireNonNull(this.children.get(language), () -> "Null children for command '" + this.name + "' for language: " + language).values();
    }

    public Map<Language, Map<String, KingdomsCommand>> getChildren() {
        return this.children;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return context.isAtArg(0) ? TabCompleteManager.tabCompleteSubCommands(context.getMessageReceiver(), this, context.args) : KingdomsParentCommand.emptyTab();
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Set filtered = Collections.newSetFromMap(new IdentityHashMap(this.children.size()));
        boolean isAdmin = context.isPlayer() && context.getKingdomPlayer().isAdmin();
        KingdomsCommand[] subCommands = (KingdomsCommand[])this.getChildren((SupportedLanguage)context.getMessageContext().getLanguage()).stream().filter(filtered::add).filter(c -> isAdmin || c.hasPermission(context.getMessageReceiver())).toArray(KingdomsCommand[]::new);
        new PaginatedCommandHelp(context, 100, this.getDisplayName(), () -> subCommands).execute();
        return CommandResult.SUCCESS;
    }
}

