/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.data.Pair;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.internal.functional.SecondarySupplier;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.internal.string.QuantumString;
import org.kingdoms.utils.string.Strings;

public class CommandTabContext
extends CommandContext {
    public CommandTabContext(Kingdoms plugin, KingdomsCommand command, CommandSender sender, String[] args) {
        super(plugin, command, sender, args);
    }

    public static @NonNull List<String> getKingdomMembers(@NonNull Nation nation, @Nullable String starts, @Nullable Predicate<Kingdom> predicate) {
        List<Kingdom> kingdoms = nation.getKingdoms();
        ArrayList<String> names = new ArrayList<String>(kingdoms.size());
        boolean empty = starts.isEmpty();
        for (Kingdom kingdom : kingdoms) {
            String name = kingdom.getName();
            if (!empty && !name.toLowerCase(Locale.ENGLISH).startsWith(starts) || predicate != null && !predicate.test(kingdom)) continue;
            names.add(name);
        }
        return names;
    }

    private static @NonNull List<String> getGroups(@NonNull Map<QuantumString, UUID> names, @Nullable QuantumString starts, @Nullable Predicate<String> predicate) {
        ArrayList<String> groups = new ArrayList<String>(Math.max(names.size() / Math.max(1, starts.length()), 30));
        String startsqBit = starts.getQuantum();
        for (QuantumString name : names.keySet()) {
            String quantum = name.getQuantum();
            if (predicate != null && !predicate.test(quantum)) continue;
            if (starts.isEmpty()) {
                groups.add(quantum);
                continue;
            }
            if (!name.getQuantum().startsWith(startsqBit)) continue;
            groups.add(quantum);
        }
        return groups;
    }

    @ApiStatus.Internal
    public static String processTabMessage(String str) {
        MessageObject compiler = MessageCompiler.compile(str);
        if (KingdomsCommand.COLORIZE_TAB_COMPLETES) {
            return compiler.buildPlain(MessagePlaceholderProvider.DEFAULT);
        }
        return compiler.buildPlain(new MessagePlaceholderProvider().ignoreColors());
    }

    public String tab(String path) {
        String obj = this.lang("tab-completion", path).parse(this.messageSettings);
        return obj == null ? "" : obj;
    }

    public @NonNull List<String> getNations(int index) {
        return this.getNations(0, null);
    }

    public static @NonNull List<String> getNations(@Nullable String starts, @Nullable Predicate<String> predicate) {
        NationManager nationManager = Kingdoms.get().getDataCenter().getNationManager();
        return CommandTabContext.getGroups(nationManager.getNames(), nationManager.toQuantumName(starts), predicate);
    }

    public Stream<String> filter(Stream<String> stream, int index) {
        return !this.assertArgs(index - 1) ? stream : stream.filter(x -> x.startsWith(this.arg(index)));
    }

    public List<String> suggest(int index, Collection<String> items) {
        return this.suggest(index, items.toArray(new String[0]));
    }

    public List<String> suggest(int index, String ... items) {
        String starts = this.arg(index);
        if (starts.isEmpty()) {
            return Arrays.asList(items);
        }
        ArrayList<String> suggestions = new ArrayList<String>(items.length);
        starts = Strings.toLatinLowerCase(starts);
        for (String item : items) {
            if (!Strings.toLatinLowerCase(item).startsWith(starts)) continue;
            suggestions.add(item);
        }
        if (suggestions.size() <= 5) {
            for (String item : items) {
                if (!Strings.toLatinLowerCase(item).contains(starts)) continue;
                suggestions.add(item);
            }
        }
        return suggestions;
    }

    public List<String> getChannels(int index, Predicate<KingdomsChatChannel> filter) {
        return this.suggest(index, (String[])KingdomsChatChannel.getChannels().values().stream().filter(filter).map(x -> {
            MessageObjectBuilder messageObjectBuilder = x.getName();
            return messageObjectBuilder.buildPlain(this.getMessageContext());
        }).toArray(String[]::new));
    }

    public @NonNull List<String> getPlayers(int index) {
        return this.getPlayers(index, null);
    }

    public List<String> add(List<String> list, String ... others) {
        list.addAll(Arrays.asList(others));
        return list;
    }

    public @NonNull List<String> getPlayers(int index, Predicate<OfflinePlayer> filter) {
        return this.getPlayers(Bukkit.getOnlinePlayers(), this.arg(index), false, filter);
    }

    public @NonNull List<String> getPlayers(Collection<? extends OfflinePlayer> players, @NonNull String starts, boolean admin, Predicate<OfflinePlayer> filter) {
        return TabCompleteManager.getPlayers(players, starts, admin, filter);
    }

    public String currentArg() {
        return this.args[this.args.length - 1];
    }

    public @NonNull List<String> getKingdomPlayers(@NonNull Kingdom kingdom, int index) {
        return this.getPlayers(kingdom.getPlayerMembers(), this.arg(index), true, null);
    }

    public @NonNull List<String> getKingdomPlayers(@NonNull Kingdom kingdom, @NonNull String starts, Predicate<OfflinePlayer> filter) {
        return this.getPlayers(kingdom.getPlayerMembers(), starts, true, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processTabMessage(Messenger msg) {
        MessageObject msgObject = msg.getMessageObject(this.messageSettings.getLanguage());
        if (!KingdomsCommand.COLORIZE_TAB_COMPLETES) {
            this.messageSettings.ignoreColors();
        }
        try {
            String string = msgObject.buildPlain(this.messageSettings);
            return string;
        }
        finally {
            this.messageSettings.dontIgnoreColors();
        }
    }

    public List<String> tabComplete(Messenger messenger) {
        return Collections.singletonList(this.processTabMessage(messenger));
    }

    public List<String> tabComplete(Messenger ... completions) {
        return Arrays.stream(completions).map(this::processTabMessage).collect(Collectors.toList());
    }

    public List<String> tabComplete(String ... completions) {
        return this.tabComplete(Arrays.asList(completions));
    }

    public List<String> tabComplete(Collection<String> completions) {
        ArrayList<String> tabs = new ArrayList<String>(completions.size());
        for (String str : completions) {
            tabs.add(CommandTabContext.processTabMessage(str));
        }
        return tabs;
    }

    protected static OfflinePlayer getPlayer(CommandSender sender, String name) {
        OfflinePlayer player = PlayerUtils.getOfflinePlayer(name);
        if (player == null) {
            KingdomsLang.NOT_FOUND_PLAYER.sendError(sender, new Object[0]);
        }
        return player;
    }

    public List<String> emptyTab() {
        return Collections.emptyList();
    }

    public @NonNull List<String> getKingdoms(int index) {
        return this.getKingdoms(index, null);
    }

    public @NonNull List<String> getKingdoms(int index, @Nullable Predicate<String> predicate) {
        KingdomManager kingdomManager = Kingdoms.get().getDataCenter().getKingdomManager();
        return CommandTabContext.getGroups(kingdomManager.getNames(), this.assertArgs(index + 1) ? kingdomManager.toQuantumName(this.arg(index)) : QuantumString.empty(), predicate);
    }

    public Completer tabCompleteKingdoms() {
        int index = this.nextArg();
        return this.isAtCurrentParameter() ? this.complete(this.getKingdoms(index)) : this.completeEmpty();
    }

    private List<String> getNumberModifierTabSuggestions() {
        return Stream.of(KingdomsLang.SETTERS_TYPE_ADD, KingdomsLang.SETTERS_TYPE_SUBTRACT, KingdomsLang.SETTERS_TYPE_SET).flatMap(x -> Arrays.stream(Strings.splitArray(x.parse(this.messageSettings), ' '))).collect(Collectors.toList());
    }

    public Messenger tabParameter(String name, boolean required) {
        char firstChar = required ? (char)'<' : '[';
        char secChar = required ? (char)'>' : ']';
        String color = required ? "{$e}" : "{$p}";
        return DefaultedMessenger.oneOf(this.getCommand().lang("tab-completion-" + (required ? "required" : "optional"), name), () -> this.getCommand().lang("tab-completion", name), () -> new StaticMessenger("{$sep}" + firstChar + color + name + "{$sep}" + secChar));
    }

    public Completer tabCompleteNumberModifier(String numberName, NumberConstraint ... constraints) {
        int from = this.nextArg();
        boolean atCurrArg = this.isAtCurrentParameter();
        if (atCurrArg) {
            Messenger numError;
            Messenger requiredArgName = this.tabParameter(numberName, true);
            Pair<AnyNumber, Messenger> noSetterTypeNumber = this.getNumber(from, requiredArgName, constraints);
            if (noSetterTypeNumber.getKey() != null) {
                return this.complete(requiredArgName);
            }
            if (noSetterTypeNumber.getValue() != null && (numError = noSetterTypeNumber.getValue()) != KingdomsLang.INVALID_NUMBER) {
                return this.complete(numError);
            }
            String setterTypeStr = this.args[from];
            CommandContext.SetterType setterType = this.getNumberModifierType(setterTypeStr);
            if (setterType == null) {
                this.var("setter_type", setterTypeStr);
                List<String> suggestions = this.suggest(from, this.getNumberModifierTabSuggestions());
                if (suggestions.isEmpty() && !setterTypeStr.isEmpty()) {
                    suggestions.add(KingdomsLang.SETTERS_TYPE_UNKNOWN.parse(this.messageSettings));
                }
                return this.complete(suggestions);
            }
            this.completeEmpty();
        }
        if (this.hasMoreParameters()) {
            int numIndex = this.nextArg();
            if (this.isAtCurrentParameter()) {
                String setterTypeStr = this.args[numIndex - 1];
                CommandContext.SetterType setterType = this.getNumberModifierType(setterTypeStr);
                if (setterType != null) {
                    return this.complete(this.tabParameter(numberName, true));
                }
                return this.completeEmpty();
            }
        }
        return this.completeEmpty();
    }

    @SafeVarargs
    public final List<String> merge(List<String> ... tabCompletions) {
        ArrayList<String> merged = new ArrayList<String>(Arrays.stream(tabCompletions).mapToInt(List::size).sum());
        for (List<String> tabCompletion : tabCompletions) {
            merged.addAll(tabCompletion);
        }
        return merged;
    }

    public <T extends Group> Completer tabCompleteGeneralSelector(boolean targetNation, boolean includeIfNotExist, Predicate<T> filter) {
        String startsWith;
        int from = this.nextArg();
        boolean isAtTagsParameter = from == this.args.length - 1;
        boolean isAtSpecificParameter = from == this.args.length - 2;
        String playerTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_PLAYERS.parse(this.sender, new Object[0]);
        String kingdomTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_KINGDOMS.parse(this.sender, new Object[0]);
        String nationTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_NATIONS.parse(this.sender, new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        boolean addPlayerNames = false;
        boolean addKingdomNames = false;
        boolean addNationNames = false;
        if (isAtTagsParameter) {
            startsWith = this.args[from];
            list.add(playerTag);
            list.add(kingdomTag);
            if (targetNation) {
                list.add(nationTag);
            }
            if (startsWith.isEmpty()) {
                list.add(KingdomsLang.COMMANDS_TAGS_PLAYERS.parse(this.sender, new Object[0]));
                list.add(KingdomsLang.COMMANDS_TAGS_KINGDOMS.parse(this.sender, new Object[0]));
                if (targetNation) {
                    list.add(KingdomsLang.COMMANDS_TAGS_NATIONS.parse(this.sender, new Object[0]));
                }
            } else {
                addNationNames = true;
                addKingdomNames = true;
                addPlayerNames = true;
            }
        } else if (this.hasMoreParameters()) {
            from = this.nextArg();
            startsWith = this.args[from];
            if (from > 0) {
                String previous = this.args[from - 1].toLowerCase();
                if (previous.equals(playerTag.toLowerCase())) {
                    addPlayerNames = true;
                } else if (previous.equals(kingdomTag.toLowerCase())) {
                    addKingdomNames = true;
                } else if (targetNation && previous.equals(nationTag.toLowerCase())) {
                    addNationNames = true;
                }
            }
            if (!(addPlayerNames || addKingdomNames || addNationNames)) {
                this.previousArg();
                return this.completeEmpty();
            }
        } else {
            return this.completeEmpty();
        }
        if (!isAtTagsParameter && !isAtSpecificParameter) {
            return this.completeEmpty();
        }
        if (addPlayerNames) {
            list.addAll(TabCompleteManager.getPlayers(startsWith, player -> {
                Kingdom kingdom;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
                Group group = kingdom = kp.getKingdom();
                if (targetNation && kingdom != null) {
                    group = kingdom.getNation();
                }
                if (group == null) {
                    return includeIfNotExist;
                }
                return filter.test(group);
            }));
        }
        if (addKingdomNames) {
            list.addAll(TabCompleteManager.getKingdoms(startsWith, kingdomName -> {
                Kingdom kingdom;
                Group group = kingdom = Kingdom.getKingdom(kingdomName);
                if (targetNation && kingdom != null) {
                    group = kingdom.getNation();
                }
                if (group == null) {
                    return includeIfNotExist;
                }
                return filter.test(group);
            }));
        }
        if (targetNation && addNationNames) {
            list.addAll(TabCompleteManager.getNations(startsWith, nationName -> filter.test(Nation.getNation(nationName))));
        }
        return this.complete(list);
    }

    public @NonNull List<String> getNations(int index, @Nullable Predicate<String> predicate) {
        NationManager nationManager = Kingdoms.get().getDataCenter().getNationManager();
        return CommandTabContext.getGroups(nationManager.getNames(), this.assertArgs(index + 1) ? nationManager.toQuantumName(this.arg(index)) : QuantumString.empty(), predicate);
    }

    private Completer completeEmpty() {
        return new Completer(null);
    }

    public Completer complete(Messenger ... completion) {
        return this.complete(this.tabComplete(completion));
    }

    public Completer complete(List<String> completion) {
        return new Completer(completion);
    }

    public Completer completeNext(Supplier<Messenger> completion) {
        this.nextArg();
        if (this.isAtCurrentParameter()) {
            return this.complete(this.tabComplete(completion.get()));
        }
        return new Completer(null);
    }

    public Completer completeNext(SecondarySupplier<List<String>> completion) {
        this.nextArg();
        if (this.isAtCurrentParameter()) {
            return new Completer(completion.get());
        }
        return new Completer(null);
    }

    public final class Completer {
        private List<String> result;

        public Completer(List<String> result) {
            this.result = result;
        }

        public Completer then(SecondarySupplier<List<String>> other) {
            if (this.result == null) {
                CommandTabContext.this.nextArg();
                if (CommandTabContext.this.isAtCurrentParameter()) {
                    this.result = other.get();
                }
            }
            return this;
        }

        public Completer then(Supplier<Completer> other) {
            if (this.result == null) {
                this.result = other.get().result;
            }
            return this;
        }

        public List<String> build() {
            return this.result == null ? new ArrayList() : this.result;
        }
    }
}

