/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandLoggingLevel;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandUserError;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.admin.CommandSession;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.SimpleContextualMessageSender;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.ProcessToMessage;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.internal.arrays.FunctionalList;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.internal.numbers.NumberProcessor;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeUtils;

public class CommandContext
extends SimpleContextualMessageSender {
    private static final Cache<UUID, CommandConfirmation> CONFIRMATION_COOLDOWN = CacheHandler.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    public final Kingdoms plugin;
    public final String[] args;
    private final KingdomsCommand command;
    protected Map<String, String> mappedArguments;
    protected Messenger result;
    protected CommandLoggingLevel loggingLevel = CommandLoggingLevel.ALL;
    private static final int MAX_ARGS = 5;
    protected int argPosition;
    private boolean nextArgumentReady = false;
    private CommandSession.Session session;

    public CommandContext(Kingdoms plugin, KingdomsCommand command, CommandSender sender, String[] args) {
        super(sender, new MessagePlaceholderProvider().withContext(sender));
        this.messageSettings.lang(this.isPlayer() ? this.getKingdomPlayer().getLanguage() : Language.getDefault());
        this.plugin = plugin;
        this.command = command;
        this.args = args;
    }

    public String arg(@IntRange(from=0L, to=5L) int index) {
        if (index >= this.args.length) {
            throw this.error(this.command.getUsage());
        }
        this.argPosition = index + 1;
        return this.args[index];
    }

    public boolean argIsAny(@IntRange(from=0L, to=5L) int index, String ... options) {
        String arg = this.arg(index).toLowerCase();
        for (String option : options) {
            if (!arg.equals(option)) continue;
            return true;
        }
        return false;
    }

    public String joinArgs() {
        return this.joinArgs(" ");
    }

    public String joinArgs(String delimiter) {
        return String.join((CharSequence)delimiter, this.args);
    }

    public String joinArgs(String delimiter, @IntRange(from=0L, to=5L) int fromIndex) {
        StringJoiner joiner = new StringJoiner(delimiter);
        while (fromIndex < this.args.length) {
            joiner.add(this.args[fromIndex++]);
        }
        return joiner.toString();
    }

    public boolean hasPermission() {
        return !(this.sender instanceof Player) || this.command.hasPermission(this.sender) || KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)this.sender)).isAdmin();
    }

    public void requireYesNo(Duration expiresIn, CommandSession.SessionCallback callback) {
        CommandSession.addSession(this, expiresIn, callback);
    }

    public void requireYesNo(Messenger confirmationMessage) {
        Namespace ns;
        Cache<Integer, CommandSession.Session> session;
        if (this.session != null && (session = CommandSession.SESSIONS.get(ns = Namespace.kingdoms("COMMAND_" + this.command.name.toUpperCase(Locale.ENGLISH)))) != null && session.getIfPresent((Object)this.session.getId()) != null) {
            return;
        }
        this.session = CommandSession.addSession(this, Duration.ofSeconds(30L), answer -> {
            if (answer.equalsIgnoreCase("yes")) {
                this.command.execute(this);
            } else {
                this.sendError(new StaticMessenger("&4Unknown answer&8: &e" + answer), new Object[0]);
            }
            return false;
        });
        throw this.error(confirmationMessage);
    }

    public boolean requireConfirmation(@NonNull Messenger confirmMessage) {
        UUID id = this.isPlayer() ? this.senderAsPlayer().getUniqueId() : new UUID(0L, 0L);
        CommandConfirmation confirmation = (CommandConfirmation)CONFIRMATION_COOLDOWN.getIfPresent((Object)id);
        if (confirmation != null && confirmation.command == this.command && Arrays.equals(confirmation.arguments, this.args)) {
            return false;
        }
        this.sendError(confirmMessage, new Object[0]);
        CONFIRMATION_COOLDOWN.put((Object)id, (Object)new CommandConfirmation(this.command, this.args, Duration.ofSeconds(30L)));
        return true;
    }

    public KingdomsCommand getCommand() {
        return this.command;
    }

    public Integer parseInt(int index, Messenger argName, boolean allowNegative) {
        String arg = this.arg(index);
        this.messageSettings.raw("arg", argName);
        try {
            int num = Integer.parseInt(arg);
            if (allowNegative) {
                return num;
            }
            if (num < 0) {
                this.sendMessage(this.command.getUsage(), this.messageSettings);
                this.sendError(KingdomsLang.INVALID_NUMBER_NEGATIVE, new Object[0]);
                return null;
            }
            return num;
        }
        catch (NumberFormatException ex) {
            this.sendMessage(this.command.getUsage(), this.messageSettings);
            this.sendError(KingdomsLang.INVALID_NUMBER, new Object[0]);
            return null;
        }
    }

    public void setLoggingLevel(CommandLoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public CommandLoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public void sendMessage(CommandSender sender, Messenger lang, Object ... edits) {
        if (this.loggingLevel.atLeast(this.sender == sender ? CommandLoggingLevel.ALL : CommandLoggingLevel.INFO)) {
            super.sendMessage(sender, lang, edits);
        }
    }

    @Override
    public void sendError(@NotNull Messenger lang, Object ... edits) {
        if (this.loggingLevel.atLeast(CommandLoggingLevel.ERRORS)) {
            super.sendError(lang, edits);
        }
    }

    public Boolean parseBool(@IntRange(from=0L, to=5L) int index) {
        String str = this.arg(index).toLowerCase(Locale.ENGLISH);
        if (str.equals("true") || KingdomsLang.TRUE.parse(this.sender, new Object[0]).toLowerCase().equals(str)) {
            return true;
        }
        if (str.equals("false") || KingdomsLang.FALSE.parse(this.sender, new Object[0]).toLowerCase().equals(str)) {
            return false;
        }
        this.sendError(KingdomsLang.INVALID_BOOLEAN, "arg", this.arg(index));
        return null;
    }

    public String arg(@IntRange(from=0L, to=5L) int index, String def) {
        return this.assertArgs(index + 1) ? this.args[index] : def;
    }

    public CommandContext debug(String msg) {
        KLogger.info(msg);
        return this;
    }

    public int nextArg() {
        this.nextArgumentReady = true;
        return this.argPosition++;
    }

    public int previousArg() {
        return --this.argPosition;
    }

    public String nextString() {
        return this.arg(this.nextArg());
    }

    public Namespace nextNamespace() {
        String ns = this.nextString();
        try {
            return Namespace.fromString(ns);
        }
        catch (IllegalArgumentException ex) {
            throw this.error(KingdomsLang.NO_KINGDOM_DEFAULT);
        }
    }

    private boolean matchesAny(String setterTypeStr, Messenger messenger) {
        String list = messenger.parse(this.messageSettings);
        for (String typeAlias : Strings.splitArray(list, ' ')) {
            if (!setterTypeStr.equals(typeAlias)) continue;
            return true;
        }
        return false;
    }

    protected SetterType getNumberModifierType(String setterTypeStr) {
        if (this.matchesAny(setterTypeStr, KingdomsLang.SETTERS_TYPE_ADD)) {
            return SetterType.ADDITION;
        }
        if (this.matchesAny(setterTypeStr, KingdomsLang.SETTERS_TYPE_SUBTRACT)) {
            return SetterType.SUBTRACTION;
        }
        if (this.matchesAny(setterTypeStr, KingdomsLang.SETTERS_TYPE_SET)) {
            return SetterType.SET;
        }
        return null;
    }

    public AnyNumber numberModifier(String argumentName, Number currentValue, NumberConstraint ... constraints) {
        int fromIndex = this.nextArg();
        String setterTypeStr = this.arg(fromIndex);
        SetterType setterType = this.getNumberModifierType(setterTypeStr);
        DefaultedMessenger argMsg = DefaultedMessenger.of(this.command.lang("parameters", argumentName), new StaticMessenger(argumentName));
        if (setterType == null) {
            this.var("setter_type", setterTypeStr);
            Pair<AnyNumber, Messenger> number = this.getNumber(fromIndex, argMsg, constraints);
            if (number.getValue() == null) {
                return SetterType.ADDITION.handle(AnyNumber.of(currentValue), number.getKey());
            }
            if (setterTypeStr.isEmpty()) {
                throw this.emptyError();
            }
            throw this.error(KingdomsLang.SETTERS_TYPE_UNKNOWN);
        }
        if (!this.hasMoreParameters()) {
            throw this.error(this.command.getUsage());
        }
        Pair<AnyNumber, Messenger> number = this.getNumber(this.nextArg(), argMsg, constraints);
        if (number.getValue() != null) {
            throw this.error(number.getValue());
        }
        return setterType.handle(AnyNumber.of(currentValue), number.getKey());
    }

    public AnyNumber durationModifier(String argumentName, Duration currentValue) {
        int fromIndex = this.nextArg();
        String setterTypeStr = this.arg(fromIndex);
        SetterType setterType = this.getNumberModifierType(setterTypeStr);
        if (setterType == null) {
            this.var("setter_type", setterTypeStr);
            Long time = TimeUtils.parseTime(this.arg(fromIndex));
            if (time != null) {
                return SetterType.ADDITION.handle(AnyNumber.of(currentValue.toMillis()), AnyNumber.of(time));
            }
            if (setterTypeStr.isEmpty()) {
                throw this.emptyError();
            }
            throw this.error(KingdomsLang.SETTERS_TYPE_UNKNOWN);
        }
        if (!this.hasMoreParameters()) {
            throw this.error(this.command.getUsage());
        }
        String timeArg = this.arg(this.nextArg());
        Long time = TimeUtils.parseTime(timeArg);
        if (time == null) {
            this.var("time", timeArg);
            throw this.error(KingdomsLang.INVALID_TIME);
        }
        return setterType.handle(AnyNumber.of(currentValue.toMillis()), AnyNumber.of(time));
    }

    public <T extends Group> T generalSelector(boolean targetNation) {
        OfflinePlayer player;
        Kingdom kingdom;
        KingdomsLang msg;
        String second;
        String playerTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_PLAYERS.parse(this.sender, new Object[0]).toLowerCase();
        String kingdomTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_KINGDOMS.parse(this.sender, new Object[0]).toLowerCase();
        String nationTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_NATIONS.parse(this.sender, new Object[0]).toLowerCase();
        int from = this.nextArg();
        String identifier = this.args[from].toLowerCase();
        String string = second = this.args.length - 1 < from + 1 ? null : this.args[this.nextArg()];
        if (identifier.equals(playerTag) || identifier.equals(KingdomsLang.COMMANDS_TAGS_IDENTIFIER_PLAYERS.parse(Language.getDefault(), new MessagePlaceholderProvider()).toLowerCase())) {
            if (second == null) {
                this.wrongUsage();
                return null;
            }
            OfflinePlayer player2 = this.getOfflinePlayer(from + 1);
            if (player2 == null) {
                return null;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player2);
            Kingdom kingdom2 = kp.getKingdom();
            if (kingdom2 == null) {
                this.sendError(KingdomsLang.NOT_FOUND_PLAYER_NO_KINGDOM, new Object[0]);
                return null;
            }
            Group group = kingdom2;
            if (targetNation) {
                group = kingdom2.getNation();
            }
            if (group == null) {
                this.sendError(KingdomsLang.NOT_FOUND_PLAYER_NO_NATION, new Object[0]);
                return null;
            }
            return (T)group;
        }
        if (identifier.equals(kingdomTag) || identifier.equals(KingdomsLang.COMMANDS_TAGS_IDENTIFIER_KINGDOMS.parse(Language.getDefault(), new MessagePlaceholderProvider()).toLowerCase())) {
            if (second == null) {
                this.wrongUsage();
                return null;
            }
            Kingdom kingdom3 = this.getKingdom(from + 1);
            if (kingdom3 == null) {
                return null;
            }
            Group group = kingdom3;
            if (targetNation) {
                group = kingdom3.getNation();
            }
            if (group == null) {
                this.sendError(KingdomsLang.NO_NATION_OTHER, new Object[0]);
                return null;
            }
            return (T)group;
        }
        if (targetNation && (identifier.equals(nationTag) || identifier.equals(KingdomsLang.COMMANDS_TAGS_IDENTIFIER_NATIONS.parse(Language.getDefault(), new MessagePlaceholderProvider()).toLowerCase()))) {
            if (second == null) {
                this.wrongUsage();
                return null;
            }
            return (T)this.getNation(from + 1);
        }
        identifier = this.arg(from);
        Group group = null;
        KingdomsLang kingdomsLang = msg = targetNation ? KingdomsLang.NOT_FOUND_NATION_KINGDOM_PLAYER : KingdomsLang.NOT_FOUND_KINGDOM_PLAYER;
        if (targetNation) {
            group = Nation.getNation(identifier);
        }
        if (group == null && (kingdom = Kingdom.getKingdom(identifier)) != null) {
            if (targetNation) {
                msg = KingdomsLang.NO_NATION_OTHER;
                group = kingdom.getNation();
            } else {
                group = kingdom;
            }
        }
        if (group == null && (player = PlayerUtils.getOfflinePlayer(identifier)) != null) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
            Kingdom kingdom4 = kp.getKingdom();
            if (kingdom4 != null) {
                if (targetNation) {
                    msg = KingdomsLang.NOT_FOUND_PLAYER_NO_NATION;
                    group = kingdom4.getNation();
                } else {
                    group = kingdom4;
                }
            } else {
                msg = KingdomsLang.NOT_FOUND_PLAYER_NO_KINGDOM;
            }
        }
        if (group == null) {
            this.messageSettings.raw("arg", identifier);
            this.sendError(msg, new Object[0]);
        }
        return (T)group;
    }

    public CommandResult fail(Messenger lang) {
        super.sendError(lang, new Object[0]);
        this.result = lang;
        return CommandResult.FAILED;
    }

    @ApiStatus.Internal
    public Messenger getResult() {
        return this.result;
    }

    public void wrongUsage() {
        this.fail(this.command.getUsage());
    }

    public boolean assertPlayer() {
        if (this.isPlayer()) {
            return false;
        }
        this.fail(KingdomsLang.COMMANDS_PLAYERS_ONLY);
        return true;
    }

    public boolean assertEnabledWorld() {
        if (!this.isPlayer()) {
            return false;
        }
        Player player = this.senderAsPlayer();
        String world = player.getWorld().getName();
        if (KingdomsConfig.DISABLED_WORLDS.getStringList().contains(world)) {
            this.var("world", world);
            this.fail(KingdomsLang.DISABLED_WORLD);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public CommandContext var(@NotNull String variable, @org.kingdoms.libs.jetbrains.annotations.Nullable Object replacement) {
        super.var(variable, replacement);
        return this;
    }

    public Kingdoms getPlugin() {
        return this.plugin;
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Player senderAsPlayer() {
        return (Player)this.sender;
    }

    public boolean assertArgs(@IntRange(from=1L, to=5L) int len) {
        return this.args.length >= len;
    }

    public boolean requireArgs(@IntRange(from=1L, to=5L) int len) {
        if (!this.assertArgs(len)) {
            this.wrongUsage();
            return true;
        }
        return false;
    }

    protected CommandUserError emptyError() {
        return new CommandUserError("Please report to the developers if you see this message", this, null);
    }

    protected CommandUserError error(Messenger error) {
        this.result = error;
        return new CommandUserError("Please report to the developers if you see this message", this, error);
    }

    private void ensureMapped() {
        if (this.mappedArguments == null) {
            this.mapArguments();
        }
    }

    public @NonNull String required(String name) {
        this.ensureMapped();
        String arg = this.mappedArguments.get(name);
        if (arg == null) {
            throw this.error(KingdomsLang.COMMANDS_MAPPED_ARGUMENTS_MISSING);
        }
        return arg;
    }

    public @Nullable String optional(String name) {
        this.ensureMapped();
        return this.mappedArguments.get(name);
    }

    public void mapArguments() {
        this.mappedArguments = new HashMap<String, String>(10);
        String currentKey = null;
        String currentValue = null;
        for (String arg : this.args) {
            int equals = arg.indexOf(61);
            if (equals > 0) {
                if (currentKey != null) {
                    throw new IllegalArgumentException("End quote for argument '" + currentKey + "' not found: " + this.joinArgs());
                }
                boolean hadQuotes = arg.length() > equals + 1 && arg.charAt(equals + 1) == '\"';
                currentKey = arg.substring(0, equals);
                currentValue = arg.substring(hadQuotes ? equals + 2 : equals + 1);
                if (hadQuotes) continue;
                this.mappedArguments.put(currentKey, currentValue);
                currentKey = null;
                currentValue = null;
                continue;
            }
            if (currentKey == null) {
                throw new IllegalArgumentException("No context key found: " + this.joinArgs());
            }
            if (arg.endsWith("\"")) {
                currentValue = currentValue + ' ' + arg.substring(0, arg.length() - 1);
                this.mappedArguments.put(currentKey, currentValue);
                currentKey = null;
                currentValue = null;
                continue;
            }
            currentValue = currentValue + ' ' + arg;
        }
    }

    public boolean assertHasKingdom() {
        if (!this.getKingdomPlayer().hasKingdom()) {
            this.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return true;
        }
        return false;
    }

    public boolean assertPublicKingdom() {
        if (this.getKingdom().isPrivate()) {
            this.sendError(KingdomsLang.NO_KINGDOM_PRIVATE, new Object[0]);
            return false;
        }
        return true;
    }

    public boolean assertHasNation() {
        KingdomPlayer kp = this.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            this.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return true;
        }
        if (!kingdom.hasNation()) {
            this.sendError(KingdomsLang.NO_NATION, new Object[0]);
            return true;
        }
        return false;
    }

    public Messenger lang(String ... entries) {
        return this.command.lang(entries);
    }

    public boolean argsLengthEquals(int len) {
        return this.args.length == len;
    }

    public boolean isAtArg(@IntRange(from=0L, to=5L) int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Cannot check negative index: " + index);
        }
        if (this.args.length == 0 && index == 0) {
            return true;
        }
        return this.args.length == index + 1;
    }

    public boolean isAtCurrentParameter() {
        Validate.isTrue(this.nextArgumentReady, "Next argument is not ready for " + this.argPosition);
        this.nextArgumentReady = false;
        return this.isAtArg(this.argPosition - 1);
    }

    public boolean hasMoreParameters() {
        return this.argPosition < this.args.length;
    }

    public @IntRange(from=1L, to=5L) int getParameterPosition() {
        return this.args.length;
    }

    public int intArg(@IntRange(from=0L, to=5L) int index) {
        return Integer.parseInt(this.arg(index));
    }

    public boolean isNumber(int index) {
        try {
            Double.parseDouble(this.arg(index));
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Double getDouble(int index) {
        AnyNumber num = this.getNumber(index, false, true, null);
        return num == null ? null : Double.valueOf(num.getValue().doubleValue());
    }

    public Integer getInt(int index) {
        AnyNumber num = this.getNumber(index, true, true, null);
        return num == null ? null : Integer.valueOf(num.getValue().intValue());
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.args.length) {
            throw new IllegalArgumentException("Cannot get parameter at index " + index + " with parameters: (" + this.args.length + ')' + Arrays.toString(this.args));
        }
    }

    public AnyNumber getNumber(int index, boolean integerOnly, boolean positiveOnly, Messenger argName) {
        Pair<AnyNumber, Messenger> processed = this.getNumber(index, argName, FunctionalList.create().addIf(integerOnly, NumberConstraint.INTEGER_ONLY).addIf(positiveOnly, NumberConstraint.POSITIVE).toArray((NumberConstraint[])new NumberConstraint[0]));
        if (processed.getValue() != null) {
            this.fail(processed.getValue());
            return null;
        }
        return processed.getKey();
    }

    public Pair<AnyNumber, Messenger> getNumber(int index, Messenger argName, NumberConstraint ... constraints) {
        this.checkIndex(index);
        this.messageSettings.raw("arg", this.args[index]).raw("needed", argName);
        return ProcessToMessage.getNumber(new NumberProcessor(this.arg(index)).withAllDecorators().withConstraints(constraints));
    }

    public KingdomPlayer getKingdomPlayer() {
        return KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.senderAsPlayer());
    }

    public Kingdom getKingdom() {
        return this.getKingdomPlayer().getKingdom();
    }

    public Kingdom getKingdom(int index) {
        Kingdom kingdom = Kingdom.getKingdom(this.arg(index));
        if (kingdom == null) {
            this.messageSettings.raw("kingdom", this.arg(index));
            this.sendError(KingdomsLang.NOT_FOUND_KINGDOM, new Object[0]);
        }
        return kingdom;
    }

    public Nation getNation(int index) {
        Nation nation = Nation.getNation(this.arg(index));
        if (nation == null) {
            this.messageSettings.raw("nation", this.arg(index));
            this.sendError(KingdomsLang.NOT_FOUND_NATION, new Object[0]);
        }
        return nation;
    }

    public boolean argEquals(int index, KingdomsLang lang) {
        return this.argEquals(index, lang.parse(new Object[0]));
    }

    public boolean argEquals(int index, String str) {
        return this.args.length > index && this.arg(index).equals(str);
    }

    @Override
    public CommandSender getMessageReceiver() {
        return this.sender;
    }

    public boolean hasPermission(KingdomsDefaultPluginPermission permission) {
        return this.hasPermission(permission, true);
    }

    public boolean hasPermission(KingdomsDefaultPluginPermission permission, boolean checkAdmin) {
        return permission.hasPermission(this.sender, checkAdmin);
    }

    public boolean isAdmin() {
        return !this.isPlayer() || this.getKingdomPlayer().isAdmin();
    }

    public @Nullable Player getPlayer(int index) {
        return this.getPlayer(index, true);
    }

    public @Nullable Player getPlayer(int index, boolean exact) {
        String name = this.arg(index);
        if (!PlayerUtils.isValidUsername(name)) {
            this.messageSettings.raw("name", name);
            this.sendError(KingdomsLang.INVALID_USERNAME, new Object[0]);
            return null;
        }
        Player player = PlayerUtils.getPlayer(name, exact);
        if (player == null) {
            this.messageSettings.raw("name", name);
            this.sendError(KingdomsLang.NOT_FOUND_PLAYER, new Object[0]);
        }
        return player;
    }

    public @Nullable OfflinePlayer getOfflinePlayer(int index) {
        String name = this.arg(index);
        if (!PlayerUtils.isValidUsername(name)) {
            this.messageSettings.raw("name", name);
            this.sendError(KingdomsLang.INVALID_USERNAME, new Object[0]);
            return null;
        }
        OfflinePlayer player = PlayerUtils.getOfflinePlayer(name);
        if (player == null) {
            this.messageSettings.raw("name", name);
            this.sendError(KingdomsLang.NOT_FOUND_PLAYER, new Object[0]);
        }
        return player;
    }

    private static final class CommandConfirmation {
        private final KingdomsCommand command;
        private final String[] arguments;
        private final Duration expiresAfter;

        private CommandConfirmation(KingdomsCommand command, String[] arguments, Duration expiresAfter) {
            this.command = command;
            this.arguments = arguments;
            this.expiresAfter = expiresAfter;
        }
    }

    protected static enum SetterType {
        ADDITION{

            @Override
            public AnyNumber handle(AnyNumber currentValue, AnyNumber modifyValue) {
                return currentValue.plus(modifyValue);
            }
        }
        ,
        SUBTRACTION{

            @Override
            public AnyNumber handle(AnyNumber currentValue, AnyNumber modifyValue) {
                return currentValue.minus(modifyValue);
            }
        }
        ,
        SET{

            @Override
            public AnyNumber handle(AnyNumber currentValue, AnyNumber modifyValue) {
                return modifyValue;
            }
        };


        public abstract AnyNumber handle(AnyNumber var1, AnyNumber var2);
    }
}

