/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.asm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.kingdoms.asm.Event;
import org.kingdoms.asm.EventExecutor;
import org.kingdoms.asm.Listener;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.w3c.dom.events.EventException;

public class MethodHandleEventExecutor
implements EventExecutor {
    private final Class<? extends Event> eventClass;
    private final MethodHandle handle;

    public MethodHandleEventExecutor(@NotNull Class<? extends Event> eventClass, @NotNull MethodHandle handle2) {
        this.eventClass = eventClass;
        this.handle = handle2;
    }

    public MethodHandleEventExecutor(@NotNull Class<? extends Event> eventClass, @NotNull Method m) {
        this.eventClass = eventClass;
        try {
            m.setAccessible(true);
            this.handle = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Unable to set accessible", e);
        }
    }

    @Override
    public void execute(@NotNull Listener listener, @NotNull Event event) throws EventException {
        if (!this.eventClass.isInstance(event)) {
            return;
        }
        try {
            this.handle.invoke(listener, event);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

