/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.api;

import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.api.KingdomsActionProcessor;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.managers.land.BuildingProcessor;
import org.kingdoms.managers.land.InteractProcessor;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/api/DefaultKingdomsActionPrcoessor;", "Lorg/kingdoms/api/KingdomsActionProcessor;", "<init>", "()V", "processBuilding", "", "offlinePlayer", "Lorg/bukkit/OfflinePlayer;", "location", "Lorg/kingdoms/server/location/Location;", "placing", "processInteraction", "item", "Lorg/bukkit/inventory/ItemStack;", "canBreak", "itemStack", "canPlace", "canUseBlock", "canUseItem", "canInteractWithEntity", "entity", "Lorg/bukkit/entity/Entity;", "canHurtEntity", "first", "other", "core"})
@SourceDebugExtension(value={"SMAP\nKingdomsDefaultAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KingdomsDefaultAPI.kt\norg/kingdoms/api/DefaultKingdomsActionPrcoessor\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,70:1\n33#2:71\n*S KotlinDebug\n*F\n+ 1 KingdomsDefaultAPI.kt\norg/kingdoms/api/DefaultKingdomsActionPrcoessor\n*L\n25#1:71\n*E\n"})
public final class DefaultKingdomsActionPrcoessor
implements KingdomsActionProcessor {
    @NotNull
    public static final DefaultKingdomsActionPrcoessor INSTANCE = new DefaultKingdomsActionPrcoessor();

    private DefaultKingdomsActionPrcoessor() {
    }

    private final boolean processBuilding(OfflinePlayer offlinePlayer, Location location, boolean placing) {
        KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
        OfflinePlayer $this$asKingdomPlayer$iv = offlinePlayer;
        boolean $i$f$asKingdomPlayer = false;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        SimpleLocation simpleLocation = SimpleLocation.of(location);
        Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"of(...)");
        return new BuildingProcessor(kingdomPlayer, simpleLocation, placing).process().isSuccessful();
    }

    private final boolean processInteraction(OfflinePlayer offlinePlayer, Location location, ItemStack item) {
        Intrinsics.checkNotNull((Object)offlinePlayer, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        return new InteractProcessor(new PlayerInteractEvent((Player)offlinePlayer, Action.RIGHT_CLICK_BLOCK, item, null, BlockFace.SELF)).process().isSuccessful();
    }

    @Override
    public boolean canBreak(@NotNull OfflinePlayer offlinePlayer, @Nullable ItemStack itemStack, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.processBuilding(offlinePlayer, location, false);
    }

    @Override
    public boolean canPlace(@NotNull OfflinePlayer offlinePlayer, @Nullable ItemStack itemStack, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.processBuilding(offlinePlayer, location, false);
    }

    @Override
    public boolean canUseBlock(@NotNull OfflinePlayer offlinePlayer, @Nullable ItemStack itemStack, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.processInteraction(offlinePlayer, location, itemStack);
    }

    @Override
    public boolean canUseItem(@NotNull OfflinePlayer offlinePlayer, @Nullable ItemStack itemStack, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.processInteraction(offlinePlayer, location, itemStack);
    }

    @Override
    public boolean canInteractWithEntity(@NotNull OfflinePlayer offlinePlayer, @NotNull Entity entity2, @Nullable ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"offlinePlayer");
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Location location = BukkitAdapter.adapt(entity2.getLocation());
        Intrinsics.checkNotNull((Object)location);
        return this.processInteraction(offlinePlayer, location, itemStack);
    }

    @Override
    public boolean canHurtEntity(@NotNull Entity first, @NotNull Entity other, @Nullable ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(first instanceof Player) || !(other instanceof Player)) {
            return true;
        }
        return PvPManager.canFight((Player)first, (Player)other);
    }
}

