/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.addons;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.kingdoms.addons.AddonRepository;
import org.kingdoms.libs.snakeyaml.api.Load;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.common.Composer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.cache.single.ExpirableCachedSupplier;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

final class AddonFetcher {
    private static final Map<URI, ExpirableCachedSupplier<MappingNode>> META_FILES = new HashMap<URI, ExpirableCachedSupplier<MappingNode>>();

    AddonFetcher() {
    }

    static String fetchMetaFile(URL metaFileURL) throws IOException {
        KLogger.debug((DebugNS)KingdomsDebug.DOWNLOAD, () -> "Fetching meta file: " + metaFileURL);
        URLConnection con = metaFileURL.openConnection();
        con.setConnectTimeout((int)Duration.ofSeconds(10L).toMillis());
        con.setReadTimeout((int)Duration.ofSeconds(30L).toMillis());
        try (Scanner scanner = new Scanner(con.getInputStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    protected static MappingNode initializeMetaFile(AddonRepository repo) {
        URI uri;
        try {
            uri = repo.getMetaFileURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ExpirableCachedSupplier<MappingNode> metaFile = META_FILES.get(uri);
        if (metaFile == null) {
            metaFile = ExpirableCachedSupplier.of(Duration.ofMinutes(5L), () -> AddonFetcher.fetchAndLoadMetaFile(repo.getMetaFileURL()));
            META_FILES.put(uri, metaFile);
        }
        return metaFile.get();
    }

    private static MappingNode fetchAndLoadMetaFile(URL url) {
        String metaString;
        try {
            metaString = AddonFetcher.fetchMetaFile(url);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while fetching meta file '" + url + "': " + e.getMessage());
        }
        LoadSettings settings = new LoadSettings();
        settings.setLabel(url.toString());
        Load load = new Load(settings);
        Composer composer = load.createComposer(metaString);
        MappingNode root = composer.getRoot();
        load.construct(root);
        return root;
    }

    protected static void fetch(AddonRepository repo) {
        URL url;
        MappingNode root = AddonFetcher.initializeMetaFile(repo);
        ConfigSection section = new ConfigSection(null, root);
        ConfigSection repoSection = section.getSection(repo.getPath());
        Objects.requireNonNull(repoSection, () -> "Unable to find repository section for '" + repo.getPath() + "' in meta file: " + root);
        String downloadUrl = Objects.requireNonNull(repoSection.getString("url"), () -> "Download URL of addon cannot be null: " + root);
        try {
            url = new URL(downloadUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid download URL for addon '" + repo.getName() + "' " + root);
        }
        repo.setDownloadURL(url);
        String version = repoSection.getString("version");
        if (Strings.isNullOrEmpty((String)version)) {
            throw new IllegalStateException("No version specified for addon '" + repo.getName() + "' " + root);
        }
        repo.setVersion(version);
        repo.setSupportedCoreVersion(repoSection.getString("supported-core-version"));
    }
}

