/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.versioning;

import java.util.List;
import java.util.Locale;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.versioning.VersionBase;
import org.kingdoms.versioning.VersionPart;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\bH&J\b\u0010\r\u001a\u00020\u000eH&J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0010H\u00a6\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/versioning/Version;", "Lorg/kingdoms/versioning/VersionBase;", "supersedes", "", "other", "precedes", "canBeComparedTo", "getFriendlyString", "", "short", "asString", "prefix", "getOriginalString", "hashCode", "", "equals", "", "getParts", "", "Lorg/kingdoms/versioning/VersionPart;", "Companion", "shared"})
public interface Version
extends VersionBase<Version> {
    @NotNull
    public static final Companion Companion = org.kingdoms.versioning.Version$Companion.$$INSTANCE;

    @Override
    default public boolean supersedes(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) > 0;
    }

    @Override
    default public boolean precedes(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    @Override
    public boolean canBeComparedTo(@NotNull Version var1);

    @Override
    @NotNull
    default public String getFriendlyString(boolean bl) {
        return this.asString(true, bl);
    }

    @NotNull
    default public String asString(boolean prefix, boolean bl) {
        String string;
        VersionPart previousPart = null;
        StringBuilder str = new StringBuilder();
        for (VersionPart part : this.getParts()) {
            if (previousPart != null) {
                VersionPart versionPart = part;
                if (versionPart instanceof VersionPart.Numeric) {
                    str.append('.');
                } else if (versionPart instanceof VersionPart.Unknown || versionPart instanceof VersionPart.Stage) {
                    str.append('-');
                }
            }
            str.append(part.getFriendlyString(bl));
            previousPart = part;
        }
        if (prefix) {
            string = "" + 'v' + str;
        } else {
            String string2 = str.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    @NotNull
    public String getOriginalString();

    @Override
    public int hashCode();

    @Override
    public boolean equals(@Nullable Object var1);

    @NotNull
    public List<VersionPart> getParts();

    @JvmStatic
    @NotNull
    public static VersionPart parsePart(@NotNull String str) {
        return Companion.parsePart(str);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/versioning/Version$Companion;", "", "<init>", "()V", "parsePart", "Lorg/kingdoms/versioning/VersionPart;", "str", "", "shared"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VersionPart parsePart(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            try {
                int num = Integer.parseInt(str);
                if (num >= 0) {
                    return new VersionPart.Numeric(num);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string = str;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            VersionPart.PreReleaseType preReleaseType = VersionPart.PreReleaseType.MAPPING.get(string2);
            if (preReleaseType != null) {
                VersionPart.PreReleaseType it = preReleaseType;
                boolean bl = false;
                return new VersionPart.Stage(it);
            }
            return new VersionPart.Unknown(str);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

