/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.versioning;

import java.util.Set;
import java.util.logging.Logger;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.versioning.SemVer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\n\u0018\u00010 j\u0004\u0018\u0001`!2\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cj\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006%"}, d2={"Lorg/kingdoms/versioning/LatestMCVersion;", "", "latestBuild", "", "<init>", "(Ljava/lang/String;II)V", "getLatestBuild", "()I", "v1_8", "v1_9", "v1_10", "v1_11", "v1_12", "v1_13", "v1_14", "v1_15", "v1_16", "v1_17", "v1_18", "v1_19", "v1_20", "v1_21", "minorNumber", "latestPatchNumber", "getLatestPatchNumber", "version", "Lorg/kingdoms/versioning/SemVer;", "getVersion", "()Lorg/kingdoms/versioning/SemVer;", "getLatestPaperBuildURL", "", "ensureLatestPatch", "Ljava/lang/RuntimeException;", "Lorg/kingdoms/libs/kotlin/RuntimeException;", "logger", "Ljava/util/logging/Logger;", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nLatestMCVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatestMCVersion.kt\norg/kingdoms/versioning/LatestMCVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class LatestMCVersion
extends Enum<LatestMCVersion> {
    @NotNull
    public static final Companion Companion;
    private final int latestBuild;
    private final int minorNumber;
    private final int latestPatchNumber;
    @NotNull
    private final SemVer version;
    @JvmField
    @NotNull
    public static final SemVer CURRENT_VERSION;
    @JvmField
    @Nullable
    public static final LatestMCVersion CURRENT_MINOR_VERSION;
    @NotNull
    private static final Set<SemVer> ALLOWED_OUTDATED_VERSIONS;
    public static final /* enum */ LatestMCVersion v1_8;
    public static final /* enum */ LatestMCVersion v1_9;
    public static final /* enum */ LatestMCVersion v1_10;
    public static final /* enum */ LatestMCVersion v1_11;
    public static final /* enum */ LatestMCVersion v1_12;
    public static final /* enum */ LatestMCVersion v1_13;
    public static final /* enum */ LatestMCVersion v1_14;
    public static final /* enum */ LatestMCVersion v1_15;
    public static final /* enum */ LatestMCVersion v1_16;
    public static final /* enum */ LatestMCVersion v1_17;
    public static final /* enum */ LatestMCVersion v1_18;
    public static final /* enum */ LatestMCVersion v1_19;
    public static final /* enum */ LatestMCVersion v1_20;
    public static final /* enum */ LatestMCVersion v1_21;
    private static final /* synthetic */ LatestMCVersion[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private LatestMCVersion(int latestBuild) {
        this.latestBuild = latestBuild;
        this.minorNumber = this.ordinal() + 8;
        Integer n = XReflection.getLatestPatchNumberOf((int)this.minorNumber);
        Intrinsics.checkNotNull((Object)n);
        this.latestPatchNumber = n;
        this.version = SemVer.Companion.of(1, this.minorNumber, this.latestPatchNumber);
    }

    public final int getLatestBuild() {
        return this.latestBuild;
    }

    public final int getLatestPatchNumber() {
        return this.latestPatchNumber;
    }

    @NotNull
    public final SemVer getVersion() {
        return this.version;
    }

    @NotNull
    public final String getLatestPaperBuildURL() {
        String fullVersion = this.version.asString(false, false);
        return "https://api.papermc.io/v2/projects/paper/versions/" + fullVersion + "/builds/" + this.latestBuild + "/downloads/paper-" + fullVersion + '-' + this.latestBuild + ".jar";
    }

    @Nullable
    public final RuntimeException ensureLatestPatch(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (XReflection.PATCH_NUMBER < this.latestPatchNumber && !ALLOWED_OUTDATED_VERSIONS.contains(CURRENT_VERSION)) {
            logger.severe("Your server is running an outdated patch of your current Minecraft version: " + XReflection.getVersionInformation() + " You need to download the latest patch (v1." + XReflection.MINOR_NUMBER + '.' + this.latestPatchNumber + ") which you can download from " + this.getLatestPaperBuildURL() + " directly. Because the plugin will not function properly with the older patches.");
            return new IllegalStateException("Unsupported server version");
        }
        return null;
    }

    public static LatestMCVersion[] values() {
        return (LatestMCVersion[])$VALUES.clone();
    }

    public static LatestMCVersion valueOf(String value) {
        return Enum.valueOf(LatestMCVersion.class, value);
    }

    @NotNull
    public static EnumEntries<LatestMCVersion> getEntries() {
        return $ENTRIES;
    }

    @NotNull
    public static final Set<SemVer> getALLOWED_OUTDATED_VERSIONS() {
        return Companion.getALLOWED_OUTDATED_VERSIONS();
    }

    static {
        LatestMCVersion latestMCVersion;
        block1: {
            v1_8 = new LatestMCVersion(445);
            v1_9 = new LatestMCVersion(775);
            v1_10 = new LatestMCVersion(918);
            v1_11 = new LatestMCVersion(1106);
            v1_12 = new LatestMCVersion(1620);
            v1_13 = new LatestMCVersion(657);
            v1_14 = new LatestMCVersion(245);
            v1_15 = new LatestMCVersion(393);
            v1_16 = new LatestMCVersion(794);
            v1_17 = new LatestMCVersion(411);
            v1_18 = new LatestMCVersion(388);
            v1_19 = new LatestMCVersion(550);
            v1_20 = new LatestMCVersion(151);
            v1_21 = new LatestMCVersion(72);
            $VALUES = latestMCVersionArray = new LatestMCVersion[]{LatestMCVersion.v1_8, LatestMCVersion.v1_9, LatestMCVersion.v1_10, LatestMCVersion.v1_11, LatestMCVersion.v1_12, LatestMCVersion.v1_13, LatestMCVersion.v1_14, LatestMCVersion.v1_15, LatestMCVersion.v1_16, LatestMCVersion.v1_17, LatestMCVersion.v1_18, LatestMCVersion.v1_19, LatestMCVersion.v1_20, LatestMCVersion.v1_21};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            CURRENT_VERSION = SemVer.Companion.of(1, XReflection.MINOR_NUMBER, XReflection.PATCH_NUMBER);
            LatestMCVersion[] latestMCVersionArray = LatestMCVersion.values();
            int n = latestMCVersionArray.length;
            for (int i = 0; i < n; ++i) {
                LatestMCVersion latestMCVersion2;
                LatestMCVersion x = latestMCVersion2 = latestMCVersionArray[i];
                boolean bl = false;
                if (!(XReflection.MINOR_NUMBER == x.minorNumber)) continue;
                latestMCVersion = latestMCVersion2;
                break block1;
            }
            latestMCVersion = null;
        }
        CURRENT_MINOR_VERSION = latestMCVersion;
        Object[] objectArray = new SemVer[]{SemVer.Companion.of(1, 21, 0), SemVer.Companion.of(1, 20, 1), SemVer.Companion.of(1, 20, 2), SemVer.Companion.of(1, 20, 4), SemVer.Companion.of(1, 21, 1), SemVer.Companion.of(1, 21, 3), SemVer.Companion.of(1, 21, 4)};
        ALLOWED_OUTDATED_VERSIONS = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kingdoms/versioning/LatestMCVersion$Companion;", "", "<init>", "()V", "CURRENT_VERSION", "Lorg/kingdoms/versioning/SemVer;", "CURRENT_MINOR_VERSION", "Lorg/kingdoms/versioning/LatestMCVersion;", "ALLOWED_OUTDATED_VERSIONS", "", "getALLOWED_OUTDATED_VERSIONS$annotations", "getALLOWED_OUTDATED_VERSIONS", "()Ljava/util/Set;", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<SemVer> getALLOWED_OUTDATED_VERSIONS() {
            return ALLOWED_OUTDATED_VERSIONS;
        }

        @JvmStatic
        public static /* synthetic */ void getALLOWED_OUTDATED_VERSIONS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

