/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.versionsupport;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.utils.Compass;
import org.kingdoms.utils.internal.reflection.Reflect;
import org.kingdoms.utils.versionsupport.NewVersionSupport;
import org.kingdoms.utils.versionsupport.OldVersionSupport;

public final class VersionSupport {
    private static final boolean NEW;
    public static final boolean SUPPORTS_TEXT_DISPLAYS;
    public static final boolean SUPPORTS_BLOCK_DISPLAYS;
    public static final boolean SUPPORTS_MIN_HEIGHT;
    public static final boolean SUPPORTS_ADVANCED_BLOCK_STATES;
    public static final boolean SUPPORTS_BlockBreakEvent_setDropItems;
    public static final boolean SUPPORTS_Player_getLocale;
    public static final boolean SUPPORTS_SpawnEggMeta;
    public static final boolean SUPPORTS_BlockData;
    public static final boolean SUPPORTS_Entity_getHeight;
    public static final boolean SUPPORTS_PRE_SPAWN_FUNCTIONS;

    public static void rotate(Block block, Material material, Player player) {
        if (NEW) {
            NewVersionSupport.rotate(block, player);
        } else {
            OldVersionSupport.rotate(block, material, player);
        }
    }

    public static void rotate(BlockData block, BlockFace facing) {
        NewVersionSupport.rotate(block, facing);
    }

    public static void setPassenger(Entity vehicle, Entity passenger) {
        vehicle.setPassenger(passenger);
    }

    public static <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> entityType, @org.kingdoms.libs.jetbrains.annotations.Nullable Consumer<? super T> preSpawnModification) throws IllegalArgumentException {
        if (SUPPORTS_PRE_SPAWN_FUNCTIONS) {
            return (T)location.getWorld().spawn(location, entityType, preSpawnModification);
        }
        Entity entity2 = location.getWorld().spawn(location, entityType);
        preSpawnModification.accept(entity2);
        return (T)entity2;
    }

    public static Optional<Openable> openable(Block block) {
        Openable openable = NEW ? NewVersionSupport.openable(block) : OldVersionSupport.openable(block);
        return Optional.ofNullable(openable);
    }

    public static void putSign(Block sign, BlockFace facing) {
        if (NEW) {
            NewVersionSupport.putSign(sign, facing);
        } else {
            OldVersionSupport.putSign(sign, facing);
        }
    }

    public static void addDurability(@NonNull ItemStack item, int durability) {
        if (NEW) {
            NewVersionSupport.addDurability(item, durability);
        } else {
            OldVersionSupport.addDurability(item, durability);
        }
    }

    public static @Nullable Block getAttachedBlock(@Nonnull Block sign) {
        if (NEW) {
            return NewVersionSupport.getAttachedBlock(sign);
        }
        return OldVersionSupport.getAttachedBlock(sign);
    }

    public static BlockFace getPlayerFacing(Player player) {
        if (NEW) {
            return player.getFacing();
        }
        return Compass.getCardinalDirection((Entity)player).toBlockFace();
    }

    public static Block getOtherHalfIfDoor(BlockState state) {
        if (NEW) {
            return NewVersionSupport.getOtherHalfIfDoor(state);
        }
        return OldVersionSupport.getOtherHalfIfDoor(state);
    }

    public static int getMinWorldHeight(World world) {
        if (SUPPORTS_MIN_HEIGHT) {
            return world.getMinHeight();
        }
        return 0;
    }

    static {
        boolean supportsPlayerGetLocale;
        boolean supportsSetDropItems;
        boolean supportsAdvancedBlockStates;
        boolean minSupport;
        NEW = XReflection.supports((int)13);
        SUPPORTS_TEXT_DISPLAYS = Reflect.classExists("org.bukkit.entity.TextDisplay");
        SUPPORTS_BLOCK_DISPLAYS = Reflect.classExists("org.bukkit.entity.BlockDisplay");
        SUPPORTS_SpawnEggMeta = Reflect.classExists("org.bukkit.inventory.meta.SpawnEggMeta");
        SUPPORTS_BlockData = Reflect.classExists("org.bukkit.block.data.BlockData");
        SUPPORTS_Entity_getHeight = XReflection.of(Entity.class).method("public double getHeight();").exists();
        SUPPORTS_PRE_SPAWN_FUNCTIONS = XReflection.ofMinecraft().inPackage(MinecraftPackage.BUKKIT).named(new String[]{"RegionAccessor"}).method().named(new String[]{"spawn"}).returns(Entity.class).parameters(new Class[]{Location.class, Class.class, Consumer.class}).exists();
        try {
            Class.forName("org.bukkit.World").getMethod("getMinHeight", new Class[0]);
            minSupport = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            minSupport = false;
        }
        try {
            Class.forName("org.bukkit.block.data.BlockData").getMethod("createBlockState", new Class[0]);
            supportsAdvancedBlockStates = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            supportsAdvancedBlockStates = false;
        }
        try {
            BlockBreakEvent.class.getMethod("setDropItems", Boolean.TYPE);
            supportsSetDropItems = true;
        }
        catch (NoSuchMethodException e) {
            supportsSetDropItems = false;
        }
        try {
            Player.class.getMethod("getLocale", new Class[0]);
            supportsPlayerGetLocale = true;
        }
        catch (NoSuchMethodException e) {
            supportsPlayerGetLocale = false;
        }
        SUPPORTS_MIN_HEIGHT = minSupport;
        SUPPORTS_ADVANCED_BLOCK_STATES = supportsAdvancedBlockStates;
        SUPPORTS_BlockBreakEvent_setDropItems = supportsSetDropItems;
        SUPPORTS_Player_getLocale = supportsPlayerGetLocale;
    }

    public static interface Openable {
        public boolean isOpen();

        public void setOpen(boolean var1);
    }
}

