/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.versionsupport;

import javax.annotation.Nonnull;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.versionsupport.VersionSupport;

final class NewVersionSupport {
    NewVersionSupport() {
    }

    protected static void rotate(Block block, Player player) {
        BlockData data = block.getBlockData();
        if (data instanceof Rotatable) {
            Rotatable skullRotation = (Rotatable)data;
            BlockFace facing = LocationUtils.getPlayerBlockFace(player);
            if (facing != null && !Strings.contains(facing.name(), '-') && facing != BlockFace.UP && facing != BlockFace.DOWN) {
                skullRotation.setRotation(facing);
                block.setBlockData((BlockData)skullRotation);
            }
        }
    }

    public static void rotate(BlockData data, BlockFace facing) {
        if (data instanceof Rotatable) {
            Rotatable skullRotation = (Rotatable)data;
            skullRotation.setRotation(facing);
        }
    }

    protected static Block getOtherHalfIfDoor(BlockState state) {
        BlockData data = state.getBlockData();
        if (!(data instanceof Door)) {
            return null;
        }
        Door door = (Door)data;
        return state.getBlock().getRelative(door.getHalf() == Bisected.Half.TOP ? BlockFace.DOWN : BlockFace.UP);
    }

    protected static @Nullable Block getAttachedBlock(@Nonnull Block sign) {
        BlockData data = sign.getBlockData();
        if (!(data instanceof WallSign)) {
            return null;
        }
        WallSign signData = (WallSign)data;
        BlockFace facing = signData.getFacing().getOppositeFace();
        return sign.getRelative(facing);
    }

    protected static void putSign(Block block, BlockFace facing) {
        WallSign sign = (WallSign)block.getBlockData();
        sign.setFacing(facing);
        block.setBlockData((BlockData)sign);
    }

    protected static void addDurability(@NonNull ItemStack item, int durability) {
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof Damageable)) {
            throw new IllegalArgumentException("Cannot set durability of an item that is not damageable: " + item.getType());
        }
        Damageable damageable = (Damageable)meta;
        damageable.setDamage(Math.max(0, damageable.getDamage() + durability));
    }

    protected static VersionSupport.Openable openable(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Openable)) {
            return null;
        }
        return new NewOpenable(block, (Openable)blockData);
    }

    private static final class NewOpenable
    implements VersionSupport.Openable {
        private final Block block;
        private final Openable openable;

        private NewOpenable(Block block, Openable openable) {
            this.block = block;
            this.openable = openable;
        }

        @Override
        public boolean isOpen() {
            return this.openable.isOpen();
        }

        @Override
        public void setOpen(boolean open) {
            this.openable.setOpen(open);
            this.block.setBlockData((BlockData)this.openable);
        }
    }
}

