/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.time.stopwatch;

import java.time.Duration;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.time.stopwatch.Stopwatch;
import org.kingdoms.utils.time.stopwatch.StopwatchState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0003H'J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0000J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\u0006\u0010#\u001a\u00020\u0000J\b\u0010$\u001a\u00020!H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/kingdoms/utils/time/stopwatch/AbstractStopwatch;", "Lorg/kingdoms/utils/time/stopwatch/Stopwatch;", "passed", "", "<init>", "(J)V", "getPassed", "()J", "setPassed", "lastCheckedTicks", "state", "Lorg/kingdoms/utils/time/stopwatch/StopwatchState;", "getState", "()Lorg/kingdoms/utils/time/stopwatch/StopwatchState;", "setState", "(Lorg/kingdoms/utils/time/stopwatch/StopwatchState;)V", "value", "Ljava/time/Duration;", "elapsed", "getElapsed", "()Ljava/time/Duration;", "setElapsed", "(Ljava/time/Duration;)V", "getCurrentTime", "start", "stop", "reset", "updateTicks", "", "resume", "exception", "", "msg", "", "start0", "pause", "toString", "shared"})
public abstract class AbstractStopwatch
implements Stopwatch {
    private long passed;
    private long lastCheckedTicks;
    @NotNull
    private StopwatchState state;

    public AbstractStopwatch(long passed) {
        this.passed = passed;
        this.state = StopwatchState.NOT_STARTED;
    }

    public /* synthetic */ AbstractStopwatch(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        this(l);
    }

    public final long getPassed() {
        return this.passed;
    }

    public final void setPassed(long l) {
        this.passed = l;
    }

    @Override
    @NotNull
    public StopwatchState getState() {
        return this.state;
    }

    public void setState(@NotNull StopwatchState stopwatchState) {
        Intrinsics.checkNotNullParameter((Object)((Object)stopwatchState), (String)"<set-?>");
        this.state = stopwatchState;
    }

    @Override
    @NotNull
    public Duration getElapsed() {
        if (this.getState() == StopwatchState.TICKING) {
            this.updateTicks();
        }
        Duration duration = Duration.ofMillis(this.passed);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @Override
    public void setElapsed(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.getState() == StopwatchState.TICKING) {
            this.updateTicks();
        }
        this.passed = value.toMillis();
    }

    @ApiStatus.OverrideOnly
    public abstract long getCurrentTime();

    @Override
    @NotNull
    public final AbstractStopwatch start() {
        if (this.getState() != StopwatchState.NOT_STARTED) {
            this.exception("Cannot start in this state");
            throw new KotlinNothingValueException();
        }
        this.start0();
        return this;
    }

    @Override
    @NotNull
    public final AbstractStopwatch stop() {
        if (this.getState() == StopwatchState.STOPPED) {
            this.exception("Already stopped");
            throw new KotlinNothingValueException();
        }
        this.updateTicks();
        this.setState(StopwatchState.STOPPED);
        return this;
    }

    @Override
    @NotNull
    public Stopwatch reset() {
        if (this.getState() == StopwatchState.STOPPED) {
            this.exception("Stopwatch is stopped");
            throw new KotlinNothingValueException();
        }
        this.passed = 0L;
        this.lastCheckedTicks = 0L;
        this.setState(StopwatchState.NOT_STARTED);
        return this;
    }

    private final void updateTicks() {
        if (this.getState() == StopwatchState.NOT_STARTED) {
            return;
        }
        long currTicks = this.getCurrentTime();
        long ticksPassedSinceLastCheck = currTicks - this.lastCheckedTicks;
        this.passed += ticksPassedSinceLastCheck;
        this.lastCheckedTicks = currTicks;
    }

    @Override
    @NotNull
    public final AbstractStopwatch resume() {
        if (this.getState() != StopwatchState.PAUSED) {
            this.exception("Can't resume");
            throw new KotlinNothingValueException();
        }
        this.start0();
        return this;
    }

    private final Void exception(String msg) {
        throw new IllegalStateException(msg + ": " + this);
    }

    private final void start0() {
        this.setState(StopwatchState.TICKING);
        this.lastCheckedTicks = this.getCurrentTime();
    }

    @Override
    @NotNull
    public final AbstractStopwatch pause() {
        if (this.getState() != StopwatchState.TICKING) {
            this.exception("Can't pause");
            throw new KotlinNothingValueException();
        }
        this.setState(StopwatchState.PAUSED);
        this.updateTicks();
        return this;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + (Object)((Object)this.getState()) + " | " + this.getElapsed() + ')';
    }

    public AbstractStopwatch() {
        this(0L, 1, null);
    }
}

