/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.time.internal;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.time.internal.TickTemporalUnit;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/utils/time/internal/TickTemporalAmount;", "Ljava/time/temporal/TemporalAmount;", "ticks", "", "<init>", "(J)V", "getTicks", "()J", "get", "unit", "Ljava/time/temporal/TemporalUnit;", "getUnits", "", "addTo", "Ljava/time/temporal/Temporal;", "temporal", "subtractFrom", "shared"})
public final class TickTemporalAmount
implements TemporalAmount {
    private final long ticks;

    public TickTemporalAmount(long ticks) {
        this.ticks = ticks;
    }

    public final long getTicks() {
        return this.ticks;
    }

    @Override
    public long get(@NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (!(unit instanceof TickTemporalUnit)) {
            throw new UnsupportedOperationException("Unsupported unit: " + unit);
        }
        return this.ticks;
    }

    @Override
    @NotNull
    public List<TemporalUnit> getUnits() {
        Object[] objectArray = new TemporalUnit[]{TickTemporalUnit.INSTANCE};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Temporal addTo(@NotNull Temporal temporal) {
        Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
        Temporal temporal2 = temporal.plus(50L, ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)temporal2, (String)"plus(...)");
        return temporal2;
    }

    @Override
    @NotNull
    public Temporal subtractFrom(@NotNull Temporal temporal) {
        Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
        Temporal temporal2 = temporal.minus(50L, ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)temporal2, (String)"minus(...)");
        return temporal2;
    }
}

