/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string.tree;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.utils.string.tree.TreeColorScheme;
import org.kingdoms.utils.string.tree.TreeTokenType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010C\u001a\u00020DR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0012R\u001a\u0010\"\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001a\u0010.\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0010\"\u0004\b0\u0010\u0012R\u001a\u00101\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0010\"\u0004\b3\u0010\u0012R\u001a\u00104\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001b\"\u0004\b6\u0010\u001dR.\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R(\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006E"}, d2={"Lorg/kingdoms/utils/string/tree/TreeStyle;", "", "characters", "", "Lorg/kingdoms/utils/string/tree/TreeTokenType;", "", "colors", "Lorg/kingdoms/utils/string/tree/TreeColorScheme;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getCharacters", "()Ljava/util/Map;", "getColors", "maxColumns", "", "getMaxColumns", "()I", "setMaxColumns", "(I)V", "maxRows", "getMaxRows", "setMaxRows", "columizeFromLevel", "getColumizeFromLevel", "setColumizeFromLevel", "columnIdentation", "getColumnIdentation", "()Ljava/lang/String;", "setColumnIdentation", "(Ljava/lang/String;)V", "calculatedMaxRows", "indentation", "getIndentation", "setIndentation", "lines", "getLines", "setLines", "indentFirstLevel", "", "getIndentFirstLevel", "()Z", "setIndentFirstLevel", "(Z)V", "flatten", "getFlatten", "setFlatten", "maxNestLevel", "getMaxNestLevel", "setMaxNestLevel", "maxEntries", "getMaxEntries", "setMaxEntries", "ellipsis", "getEllipsis", "setEllipsis", "entryModifier", "Ljava/util/function/BiFunction;", "getEntryModifier", "()Ljava/util/function/BiFunction;", "setEntryModifier", "(Ljava/util/function/BiFunction;)V", "columnSpaceModifier", "Ljava/util/function/Function;", "getColumnSpaceModifier", "()Ljava/util/function/Function;", "setColumnSpaceModifier", "(Ljava/util/function/Function;)V", "validate", "", "core"})
@SourceDebugExtension(value={"SMAP\nStringTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringTree.kt\norg/kingdoms/utils/string/tree/TreeStyle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1#2:396\n*E\n"})
public final class TreeStyle {
    @NotNull
    private final Map<TreeTokenType, String> characters;
    @NotNull
    private final Map<TreeColorScheme, String> colors;
    private int maxColumns;
    private int maxRows;
    private int columizeFromLevel;
    @NotNull
    private String columnIdentation;
    private int indentation;
    private int lines;
    private boolean indentFirstLevel;
    private boolean flatten;
    private int maxNestLevel;
    private int maxEntries;
    @NotNull
    private String ellipsis;
    @Nullable
    private BiFunction<Integer, String, String> entryModifier;
    @Nullable
    private Function<String, Integer> columnSpaceModifier;

    public TreeStyle(@NotNull Map<TreeTokenType, String> characters, @NotNull Map<TreeColorScheme, String> colors) {
        Intrinsics.checkNotNullParameter(characters, (String)"characters");
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.characters = characters;
        this.colors = colors;
        this.maxColumns = 1;
        this.maxRows = Integer.MAX_VALUE;
        this.columizeFromLevel = Integer.MAX_VALUE;
        this.columnIdentation = " ";
        this.indentation = 2;
        this.lines = 1;
        this.indentFirstLevel = true;
        this.flatten = true;
        this.maxNestLevel = Integer.MAX_VALUE;
        this.maxEntries = Integer.MAX_VALUE;
        this.ellipsis = "...";
    }

    public /* synthetic */ TreeStyle(Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new EnumMap(TreeTokenType.class);
        }
        if ((n & 2) != 0) {
            map2 = new EnumMap(TreeColorScheme.class);
        }
        this(map, map2);
    }

    @NotNull
    public final Map<TreeTokenType, String> getCharacters() {
        return this.characters;
    }

    @NotNull
    public final Map<TreeColorScheme, String> getColors() {
        return this.colors;
    }

    public final int getMaxColumns() {
        return this.maxColumns;
    }

    public final void setMaxColumns(int n) {
        this.maxColumns = n;
    }

    public final int getMaxRows() {
        return this.maxRows;
    }

    public final void setMaxRows(int n) {
        this.maxRows = n;
    }

    public final int getColumizeFromLevel() {
        return this.columizeFromLevel;
    }

    public final void setColumizeFromLevel(int n) {
        this.columizeFromLevel = n;
    }

    @NotNull
    public final String getColumnIdentation() {
        return this.columnIdentation;
    }

    public final void setColumnIdentation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.columnIdentation = string;
    }

    public final int calculatedMaxRows() {
        return this.maxColumns == 1 ? Integer.MAX_VALUE : this.maxRows;
    }

    public final int getIndentation() {
        return this.indentation;
    }

    public final void setIndentation(int n) {
        this.indentation = n;
    }

    public final int getLines() {
        return this.lines;
    }

    public final void setLines(int n) {
        this.lines = n;
    }

    public final boolean getIndentFirstLevel() {
        return this.indentFirstLevel;
    }

    public final void setIndentFirstLevel(boolean bl) {
        this.indentFirstLevel = bl;
    }

    public final boolean getFlatten() {
        return this.flatten;
    }

    public final void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public final int getMaxNestLevel() {
        return this.maxNestLevel;
    }

    public final void setMaxNestLevel(int n) {
        this.maxNestLevel = n;
    }

    public final int getMaxEntries() {
        return this.maxEntries;
    }

    public final void setMaxEntries(int n) {
        this.maxEntries = n;
    }

    @NotNull
    public final String getEllipsis() {
        return this.ellipsis;
    }

    public final void setEllipsis(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ellipsis = string;
    }

    @Nullable
    public final BiFunction<Integer, String, String> getEntryModifier() {
        return this.entryModifier;
    }

    public final void setEntryModifier(@Nullable BiFunction<Integer, String, String> biFunction) {
        this.entryModifier = biFunction;
    }

    @Nullable
    public final Function<String, Integer> getColumnSpaceModifier() {
        return this.columnSpaceModifier;
    }

    public final void setColumnSpaceModifier(@Nullable Function<String, Integer> function) {
        this.columnSpaceModifier = function;
    }

    public final void validate() {
        if (!(this.maxColumns >= 0)) {
            boolean $i$a$-require-TreeStyle$validate$72 = false;
            String $i$a$-require-TreeStyle$validate$72 = "Max columns must be positive: " + this.maxColumns;
            throw new IllegalArgumentException($i$a$-require-TreeStyle$validate$72.toString());
        }
        if (!(this.maxRows >= 0)) {
            boolean $i$a$-require-TreeStyle$validate$82 = false;
            String $i$a$-require-TreeStyle$validate$82 = "Max rows must be positive: " + this.maxRows;
            throw new IllegalArgumentException($i$a$-require-TreeStyle$validate$82.toString());
        }
        if (!(this.indentation >= 0)) {
            boolean $i$a$-require-TreeStyle$validate$92 = false;
            String $i$a$-require-TreeStyle$validate$92 = "Indentation must be positive: " + this.indentation;
            throw new IllegalArgumentException($i$a$-require-TreeStyle$validate$92.toString());
        }
        if (!(this.lines >= 0)) {
            boolean $i$a$-require-TreeStyle$validate$102 = false;
            String $i$a$-require-TreeStyle$validate$102 = "Lines must be positive: " + this.lines;
            throw new IllegalArgumentException($i$a$-require-TreeStyle$validate$102.toString());
        }
        if (!(this.maxNestLevel >= 0)) {
            boolean $i$a$-require-TreeStyle$validate$112 = false;
            String $i$a$-require-TreeStyle$validate$112 = "Max nest level must be positive: " + this.maxNestLevel;
            throw new IllegalArgumentException($i$a$-require-TreeStyle$validate$112.toString());
        }
        if (!(this.maxEntries >= 0)) {
            boolean bl = false;
            String string = "Max entries must be positive: " + this.maxEntries;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public TreeStyle() {
        this(null, null, 3, null);
    }
}

