/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.string.tree.EntryPrinter;
import org.kingdoms.utils.string.tree.PrinterContext;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.StringTreeKt;
import org.kingdoms.utils.string.tree.TreeColorScheme;
import org.kingdoms.utils.string.tree.TreeTokenType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/utils/string/tree/ContainerPrinter;", "Lorg/kingdoms/utils/string/tree/EntryPrinter;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName$core", "()Ljava/lang/String;", "setName$core", "children", "", "getChildren$core", "()Ljava/util/List;", "print", "", "context", "Lorg/kingdoms/utils/string/tree/PrinterContext;", "printChildren", "", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStringTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringTree.kt\norg/kingdoms/utils/string/tree/ContainerPrinter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1#2:396\n*E\n"})
public class ContainerPrinter
implements EntryPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final List<EntryPrinter> children;
    @NotNull
    public static final String ROOT = "";

    public ContainerPrinter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.children = new ArrayList();
    }

    @NotNull
    public final String getName$core() {
        return this.name;
    }

    public final void setName$core(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final List<EntryPrinter> getChildren$core() {
        return this.children;
    }

    @Override
    public void print(@NotNull PrinterContext context) {
        boolean columize;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StringTree tree = context.getTree();
        int nestLevel = context.getNestLevel();
        if (!Intrinsics.areEqual((Object)this.name, (Object)ROOT)) {
            tree.writeEntry(nestLevel, this.name);
            if (nestLevel > tree.getStyle$core().getMaxNestLevel()) {
                tree.getCurrentBuilder().append(tree.getStyle$core().getEllipsis());
                return;
            }
            tree.newLine();
        }
        boolean bl = columize = tree.getStyle$core().getColumizeFromLevel() <= nestLevel;
        if (!columize) {
            this.printChildren(this.children, context);
            return;
        }
        List leftChildren = this.children;
        int maxRows = tree.getStyle$core().calculatedMaxRows();
        int maxColumns = tree.getStyle$core().getMaxColumns();
        int rows = maxRows == Integer.MAX_VALUE ? (int)Math.ceil((double)this.children.size() / (double)maxColumns) : maxRows;
        int currentLinePos = tree.getLinePosition();
        int i = 0;
        if (i <= maxColumns) {
            while (true) {
                int n;
                List children = CollectionsKt.take((Iterable)leftChildren, (int)rows);
                leftChildren = CollectionsKt.drop((Iterable)leftChildren, (int)rows);
                this.printChildren(children, context);
                if (this.maxEntriesExceeded(context)) {
                    return;
                }
                if (leftChildren.isEmpty()) break;
                tree.revertLinePosition(currentLinePos);
                Iterable iterable = CollectionsKt.drop((Iterable)tree.getLines(), (int)tree.getLinePosition());
                PrinterContext printerContext = context;
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                StringBuilder x = (StringBuilder)iterator.next();
                boolean bl2 = false;
                Function<String, Integer> function = tree.getStyle$core().getColumnSpaceModifier();
                int n2 = function != null && (function = function.apply(x.toString())) != null ? (Integer)((Object)function) : (n = x.length());
                while (iterator.hasNext()) {
                    StringBuilder x2 = (StringBuilder)iterator.next();
                    $i$a$-maxOf-ContainerPrinter$print$1 = false;
                    Function<String, Integer> function2 = tree.getStyle$core().getColumnSpaceModifier();
                    int n3 = function2 != null && (function2 = function2.apply(x2.toString())) != null ? ((Integer)((Object)function2)).intValue() : x2.length();
                    if (n >= n3) continue;
                    n = n3;
                }
                int n4 = n;
                printerContext.setCurrentColumnLongestEntry(n4);
                if (i == maxColumns) break;
                ++i;
            }
        }
        tree.setLinePosition(tree.getLines().size() - 1);
        tree.setCurrentBuilder((StringBuilder)CollectionsKt.last((List)tree.getLines()));
    }

    private final void printChildren(List<? extends EntryPrinter> children, PrinterContext context) {
        StringTree tree = context.getTree();
        int nestLevel = context.getNestLevel();
        String nest = StringTreeKt.getOrEmpty(tree.getStyle$core().getCharacters(), TreeTokenType.INDICATOR_VERTICAL_LINE) + StringsKt.repeat((CharSequence)" ", (int)tree.getStyle$core().getIndentation());
        String nestColor = StringTreeKt.getOrEmpty(tree.getStyle$core().getColors(), TreeColorScheme.INDICATORS);
        Iterator iterator = ((Iterable)children).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TreeTokenType token;
            int index = n++;
            EntryPrinter child = (EntryPrinter)iterator.next();
            TreeTokenType treeTokenType = index == 0 ? TreeTokenType.INDICATOR_CORNERS_FIRST : (token = index + 1 < children.size() ? TreeTokenType.INDICATOR_MIDDLE : TreeTokenType.INDICATOR_CORNERS_LAST);
            if (tree.getStyle$core().getIndentFirstLevel() || nestLevel > 0) {
                int spaces = tree.getStyle$core().getIndentFirstLevel() ? nestLevel : nestLevel - 1;
                boolean writeIndicator = false;
                if (context.getCurrentColumnLongestEntry() <= 0) {
                    tree.getCurrentBuilder().append(nestColor).append(StringsKt.repeat((CharSequence)nest, (int)spaces));
                    writeIndicator = true;
                } else {
                    StringBuilder stringBuilder;
                    String currBuilder;
                    writeIndicator = false;
                    Intrinsics.checkNotNullExpressionValue((Object)tree.getCurrentBuilder().toString(), (String)"toString(...)");
                    Function<String, Integer> function = tree.getStyle$core().getColumnSpaceModifier();
                    int rawBuilderLength = function != null && (function = function.apply(currBuilder)) != null ? ((Integer)((Object)function)).intValue() : currBuilder.length();
                    int netPadding = RangesKt.coerceAtLeast((int)0, (int)(context.getCurrentColumnLongestEntry() - rawBuilderLength));
                    StringBuilder $this$printChildren_u24lambda_u241 = stringBuilder = tree.getCurrentBuilder();
                    boolean bl = false;
                    $this$printChildren_u24lambda_u241.setLength(0);
                    $this$printChildren_u24lambda_u241.append(currBuilder);
                    $this$printChildren_u24lambda_u241.append(StringsKt.repeat((CharSequence)" ", (int)netPadding));
                    $this$printChildren_u24lambda_u241.append(context.getTree().getStyle$core().getColumnIdentation());
                }
                tree.writeIndicator(writeIndicator, token);
            }
            child.print(new PrinterContext(nestLevel + 1, tree, context.getColumn(), context.getCurrentColumnLongestEntry()));
            if (this.maxEntriesExceeded(context)) {
                return;
            }
            if (index + 1 >= children.size()) continue;
            tree.newLine();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.name;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/utils/string/tree/ContainerPrinter$Companion;", "", "<init>", "()V", "ROOT", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

