/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string;

import com.google.common.base.Function;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.commands.ConfigCommand;
import org.kingdoms.utils.internal.numbers.Numbers;

public final class Strings {
    public static final int INDEX_NOT_FOUND = -1;

    public static String from(char[] chars, int startIndex, int endIndex) {
        return new String(chars, startIndex, endIndex - startIndex);
    }

    public static String toDetailedString(Object obj) {
        if (obj == null) {
            return "null";
        }
        String str = obj.toString();
        String className = obj.getClass().getSimpleName();
        if (className.length() < 10) {
            className = obj.getClass().getTypeName();
        }
        return str.contains(className) ? str : className + '(' + str + ')';
    }

    public static String random(int minLength, int maxLength, String characters) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int length = rand.nextInt(minLength, maxLength + 1);
        char[] buffer = new char[length <= 0 ? rand.nextInt(Math.abs(length)) : length];
        while (length-- > 0) {
            buffer[length] = characters.charAt(rand.nextInt(characters.length()));
        }
        return new String(buffer);
    }

    public static String filterRegex(Pattern regex, String str) {
        Matcher matcher = regex.matcher(str);
        StringBuilder finalStr = new StringBuilder();
        while (matcher.find()) {
            finalStr.append(matcher.group());
        }
        return finalStr.toString();
    }

    public static boolean startsWith(char[] searchIn, int from, int to, String searchFor) {
        int len = searchFor.length();
        if (to - from < len) {
            return false;
        }
        int j = 0;
        for (int i = from; i < from + len; ++i) {
            if (searchIn[i] == searchFor.charAt(j++)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String capitalize(@Nullable String str) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        boolean capitalizeNext = true;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ' || ch == '_' || ch == '-') {
                if (ch == '_' || ch == '-') {
                    builder.append(' ');
                }
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }

    public static boolean contains(String str, char searchChar) {
        return str.indexOf(searchChar) >= 0;
    }

    public static boolean containsAny(String str, char ... searchChars) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            for (char searchCh : searchChars) {
                if (ch != searchCh) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> splitByLength(List<String> strings, int length) {
        ArrayList<String> cutStrings = new ArrayList<String>(strings.size());
        for (String string : strings) {
            while (string.length() > length) {
                cutStrings.add(string.substring(0, length));
                string = string.substring(length);
            }
            cutStrings.add(string);
        }
        return cutStrings;
    }

    public static String configOption(@Nullable Enum<?> enumeral) {
        return enumeral == null ? null : Strings.configOption(enumeral.name());
    }

    public static String configOptionToEnum(@Nullable String str) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            chars[i] = ch == '-' ? 95 : (char)(ch & 0x5F);
        }
        return new String(chars);
    }

    public static String configOption(@Nullable Namespace namespace) {
        return Strings.configOption(namespace.asNormalizedString());
    }

    public static String configOption(@Nullable String str) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            chars[i] = ch == '_' ? 45 : (char)(ch | 0x20);
        }
        return new String(chars);
    }

    public static void logComponents(BaseComponent ... components) {
        for (BaseComponent component : components) {
            String color = component.getColor().name();
            StringBuilder formats = new StringBuilder();
            if (component.isBold()) {
                formats.append('b');
            }
            if (component.isItalic()) {
                formats.append('i');
            }
            if (component.isObfuscated()) {
                formats.append('k');
            }
            if (component.isUnderlined()) {
                formats.append('_');
            }
            if (component.isStrikethrough()) {
                formats.append('-');
            }
            if (formats.length() != 0) {
                formats.insert(0, " &2Formats&8: &3");
            }
            String text = component instanceof TextComponent ? "&2Text&8: &r'" + ((TextComponent)component).getText() + "' " : "";
            MessageHandler.sendConsolePluginMessage(text + "&2Color&8: &e" + color + formats);
        }
    }

    public static String findSimilar(String name, Collection<String> names) {
        String lowerCaseName = name.toLowerCase();
        Optional<String> exact = names.stream().filter(x -> lowerCaseName.equals(x.toLowerCase())).findFirst();
        return exact.orElseGet(() -> names.stream().filter(x -> {
            boolean contains;
            String fn = x.toLowerCase();
            boolean bl = contains = lowerCaseName.contains(fn) || fn.contains(lowerCaseName);
            if (!contains) {
                return false;
            }
            int len1 = lowerCaseName.length();
            int len2 = fn.length();
            return Math.abs(len1 - len2) < (len1 >= 5 && len2 >= 5 ? 10 : 3);
        }).findFirst().orElse(null));
    }

    public static boolean areElementsEmpty(Collection<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return true;
        }
        for (String string : strings) {
            if (string.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static String repeat(String str, int times) {
        if (str.isEmpty() || times == 0) {
            return "";
        }
        char[] chars = str.toCharArray();
        char[] builder = new char[chars.length * times];
        int index = 0;
        while (times-- > 0) {
            for (char character : chars) {
                builder[index++] = character;
            }
        }
        return new String(builder);
    }

    public static String repeat(char ch, int times) {
        char[] builder = new char[times];
        Arrays.fill(builder, ch);
        return new String(builder);
    }

    public static boolean containsWhitespace(String str) {
        for (char ch : str.toCharArray()) {
            if (!Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String toLatinLowerCase(@Nullable String str) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        boolean changed = false;
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch | 0x20);
                changed = true;
            }
            chars[i] = ch;
        }
        return changed ? new String(chars) : str;
    }

    public static String replaceOnce(String text, char search, String replacement) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        int end = text.indexOf(search);
        if (end == -1) {
            return text;
        }
        return text.substring(0, end) + replacement + text.substring(end + 1);
    }

    public static CharSequence replace(String text, char search, String replacement) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        int end = text.indexOf(search);
        if (end == -1) {
            return text;
        }
        int increase = Math.max(0, replacement.length() - 1) * 50;
        StringBuilder buf = new StringBuilder(text.length() + increase);
        int start = 0;
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + 1;
            end = text.indexOf(search, start);
        }
        return buf.append(text.substring(start));
    }

    public static CharSequence replace(String text, char search, char replacement) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        int index = text.indexOf(search);
        if (index < 0) {
            return text;
        }
        char[] chars = text.toCharArray();
        while (index > 0) {
            chars[index] = replacement;
            index = text.indexOf(search, index + 1);
        }
        return new String(chars);
    }

    public static String generatedToString(Object instance) {
        StringBuilder builder = new StringBuilder(instance.getClass().getSimpleName() + '{');
        for (Field declaredField : instance.getClass().getDeclaredFields()) {
            declaredField.setAccessible(true);
            try {
                Object result = declaredField.get(instance);
                builder.append(declaredField.getName()).append('=').append(result).append(", ");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.append('}').toString();
    }

    @Nullable
    public static String toLatinUpperCase(@Nullable String str) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        boolean changed = false;
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch >= 'a' && ch <= 'z') {
                ch = (char)(ch & 0x5F);
                changed = true;
            }
            chars[i] = ch;
        }
        return changed ? new String(chars) : str;
    }

    public static String upperCaseReplaceChar(@Nullable String str, char variable, char replacement) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch == variable) {
                ch = replacement;
            } else if (ch >= 'a' && ch <= 'z') {
                ch = (char)(ch & 0x5F);
            }
            chars[i] = ch;
        }
        return new String(chars);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return Strings.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int bufSize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((bufSize = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String lowerCaseReplaceChar(@Nullable String str, char variable, char replacement) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch == variable) {
                ch = replacement;
            } else if (ch >= 'a' && ch <= 'z') {
                ch = (char)(ch | 0x20);
            }
            chars[i] = ch;
        }
        return new String(chars);
    }

    public static boolean isEnglish(@Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char chr = str.charAt(i);
            if (chr == '_' || chr == ' ' || Strings.isEnglishLetterOrDigit(chr)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(@Nullable String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNullOrBlank(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }

    public static URL validateURL(String str) {
        try {
            URL url = new URL(str);
            url.toURI();
            return url;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    public static boolean hasSymbol(@Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char chr = str.charAt(i);
            if (chr == '_' || chr == ' ' || Character.isLetterOrDigit(chr)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnglishLetter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    @Nonnull
    public static List<String> cleanSplit(@Nonnull String str, char separator) {
        return Strings.split(Strings.deleteWhitespace(str), separator, false);
    }

    @Nonnull
    public static List<String> cleanSplitManaged(@Nonnull String str, char separator) {
        if (separator != ' ') {
            str = Strings.deleteWhitespace(str);
        }
        return Strings.split(str, separator, false);
    }

    @Nullable
    public static String deleteWhitespace(@Nullable String str) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        int len = str.length();
        char[] chs = new char[len];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') continue;
            chs[count++] = ch;
        }
        if (count == len) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static CharSequence join(char delimiter, CharSequence ... elements) {
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return elements[0];
        }
        for (CharSequence ele : elements) {
            len += ele.length();
        }
        char[] builder = new char[len - 1];
        len = elements.length;
        int i = 0;
        for (CharSequence ele : elements) {
            int eleLen = ele.length();
            for (int j = 0; j < eleLen; ++j) {
                builder[i++] = ele.charAt(j);
            }
            if (--len <= 0) continue;
            builder[i++] = delimiter;
        }
        return new String(builder);
    }

    public static String join(String delimiter, Collection<String> elements, Function<String, String> decorator) {
        return Strings.join(delimiter, elements, decorator, "[]");
    }

    public static String join(String delimiter, Collection<String> elements, Function<String, String> decorator, String empty) {
        if (elements.isEmpty()) {
            return empty;
        }
        StringBuilder joined = new StringBuilder();
        int i = 0;
        for (String element : elements) {
            if (i++ != 0) {
                joined.append(delimiter);
            }
            joined.append((String)decorator.apply((Object)element));
        }
        return joined.toString();
    }

    @Nonnull
    public static List<String> split(@Nonnull String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            throw new IllegalArgumentException("Cannot split a null string: " + str);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (str.isEmpty()) {
            list.add("");
            return list;
        }
        boolean match = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = i + 1;
                continue;
            }
            match = true;
        }
        if (match || preserveAllTokens) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    @Nonnull
    public static List<SplitInfo> advancedSplit(@Nonnull String str, char separatorChar, boolean preserveAllTokens) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            throw new IllegalArgumentException("Cannot split a null or empty string: " + str);
        }
        ArrayList<SplitInfo> list = new ArrayList<SplitInfo>();
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(new SplitInfo(str.substring(start, i), start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(new SplitInfo(str.substring(start, len), start, len));
        }
        return list;
    }

    public static String[] splitLocation(@Nonnull String str, int size) {
        String[] split = new String[size];
        int len = str.length();
        int start = 0;
        size = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) != ',') continue;
            split[size++] = str.substring(start, i);
            start = i += 2;
        }
        split[size] = str.substring(start, len);
        return split;
    }

    public static boolean isEnglishLetterOrDigit(char ch) {
        return Numbers.isEnglishDigit(ch) || Strings.isEnglishLetter(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Dimension getImageSize(@Nonnull URL url) {
        try (InputStream stream = url.openStream();
             ImageInputStream in = ImageIO.createImageInputStream(stream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static <K, V> StringBuilder associatedArrayMap(Map<K, V> map) {
        return Strings.associatedArrayMap(map, 1);
    }

    private static <K, V> StringBuilder associatedArrayMap(Map<K, V> map, int nestLevel) {
        if (map == null) {
            return new StringBuilder("<null>");
        }
        StringBuilder builder = new StringBuilder(map.size() * 15);
        builder.append(map.getClass().getSimpleName()).append('{');
        for (Map.Entry<K, V> entry : map.entrySet()) {
            builder.append('\n');
            builder.append(Strings.spaces(nestLevel * 2));
            builder.append(entry.getKey()).append(" => ");
            V val = entry.getValue();
            builder.append((Object)(val instanceof Map ? Strings.associatedArrayMap((Map)val, nestLevel + 1) : val));
            builder.append('\n');
        }
        return builder.append('}');
    }

    public static String spaces(int times) {
        if (times <= 0) {
            return "";
        }
        char[] spaces = new char[times];
        Arrays.fill(spaces, ' ');
        return new String(spaces);
    }

    public static int indexOfAny(String str, String[] searchStrs) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(searchStrs);
        int ret = Integer.MAX_VALUE;
        for (String search : searchStrs) {
            int tmp;
            if (search == null || (tmp = str.indexOf(search)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    @Nonnull
    public static String getGroupedOption(@Nonnull String option, int ... grouped) {
        Objects.requireNonNull(option, "Enum option name cannot be null");
        option = Strings.toLatinLowerCase(option);
        if (grouped.length == 0) {
            return option.replace('_', '-');
        }
        String[] split = Strings.splitArray(option, '_', false);
        if (split.length < grouped.length) {
            throw new IllegalArgumentException("Groups cannot be greater than enum separators: " + option);
        }
        boolean[] groups = new boolean[split.length];
        for (int groupedInt : grouped) {
            groups[groupedInt - 1] = true;
        }
        StringBuilder sb = new StringBuilder(option.length());
        for (int i = 0; i < split.length; ++i) {
            sb.append(split[i]);
            if (groups[i]) {
                sb.append('.');
                continue;
            }
            sb.append('-');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String[] splitArray(String str, char separatorChar) {
        return Strings.splitArray(str, separatorChar, false);
    }

    public static String[] splitArray(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[0]);
    }

    public static String reverse(String input) {
        char[] chars = input.toCharArray();
        int begin = 0;
        for (int end = chars.length - 1; end > begin; --end, ++begin) {
            char temp = chars[begin];
            chars[begin] = chars[end];
            chars[end] = temp;
        }
        return new String(chars);
    }

    public static boolean isOneOf(@Nullable String str, String ... strings) {
        return !com.google.common.base.Strings.isNullOrEmpty((String)str) && Arrays.asList(strings).contains(str);
    }

    @Nullable
    public static String remove(@Nullable String str, char remove) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (char ch : chars) {
            if (ch == remove) continue;
            chars[pos++] = ch;
        }
        return chars.length == pos ? str : new String(chars, 0, pos);
    }

    public static String remove(String str, String remove) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(remove);
        return Strings.replace(str, remove, "", -1);
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return Strings.replace(text, searchString, replacement, 1);
    }

    public static String replace(String text, String searchString, String replacement) {
        return Strings.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (text.isEmpty() || searchString.isEmpty() || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = Math.max(increase, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : Math.min(max, 64)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static boolean containsAny(@Nullable String str, String ... strings) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return false;
        }
        for (String string : strings) {
            if (!str.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static String buildArguments(@Nonnull String[] args, @Nonnull String joinStr, int from) {
        Objects.requireNonNull(args, "Cannot build arguments for null argument list");
        Validate.isTrue(from >= 0, "Start index should be at least 0: " + from);
        Validate.isTrue(from < args.length, "Start index cannot be equal or greater than arguments length: " + from);
        return String.join((CharSequence)joinStr, (CharSequence[])Arrays.stream(args).skip(from).toArray(String[]::new));
    }

    @Deprecated
    public static void performCommands(OfflinePlayer offlinePlayer, Collection<String> commands) {
        Objects.requireNonNull(offlinePlayer, "Cannot perform commands for null player");
        Player player = offlinePlayer.getPlayer();
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider();
        if (player == null) {
            settings.withContext(offlinePlayer);
        } else {
            settings.withContext(player);
        }
        ConfigCommand.execute(player, ConfigCommand.parse(commands), new MessagePlaceholderProvider().withContext(offlinePlayer), false);
    }

    public static String buildArguments(@Nonnull String[] args, @Nonnull String joinStr) {
        return Strings.buildArguments(args, joinStr, 0);
    }

    public static String buildArguments(@Nonnull String[] args, int from) {
        return Strings.buildArguments(args, " ", from);
    }

    public static String buildArguments(@Nonnull String[] args) {
        return Strings.buildArguments(args, " ", 0);
    }

    public static final class SplitInfo {
        public final String text;
        public final int index;
        public final int endIndex;

        public SplitInfo(String text, int index, int endIndex) {
            this.text = text;
            this.index = index;
            this.endIndex = endIndex;
        }
    }
}

