/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.security;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.kingdoms.data.Pair;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.security.GZIPCompressor;

public final class RSAAESHybrid {
    public static final String AES_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    public static final String RSA_CIPHER_ALGORITHM = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    private static final int KEY_SIZE = 2048;
    private static final PublicKey PUBLIC_RSA_KEY;
    private static final SecretKey AES_SECRET_KEY;
    private static final boolean SUPPORTED;

    public static String getMainMethod(String cipherAlgorithm) {
        return cipherAlgorithm.substring(0, cipherAlgorithm.indexOf(47));
    }

    public static Pair<String, Pair<byte[], byte[]>> encrypt(byte[] inputData) {
        if (!SUPPORTED) {
            return null;
        }
        try {
            Pair<byte[], byte[]> pair = RSAAESHybrid.encrypt0(inputData);
            byte[] merged = RSAAESHybrid.merge(pair.getKey(), pair.getValue());
            String str = new String(Base64.getEncoder().encode(GZIPCompressor.compress(merged)), StandardCharsets.UTF_8);
            return Pair.of(str, pair);
        }
        catch (Exception ex) {
            if (KLogger.isDebugging()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static byte[] merge(byte[] aes, byte[] content) {
        int fal = aes.length;
        int sal = content.length;
        byte[] result = new byte[fal + sal];
        System.arraycopy(aes, 0, result, 0, fal);
        System.arraycopy(content, 0, result, fal, sal);
        return result;
    }

    public static Pair<byte[], byte[]> splitString(String whole) {
        int byteSize = 256;
        byte[] bytes = GZIPCompressor.decompress(Base64.getDecoder().decode(whole.getBytes(StandardCharsets.UTF_8)));
        byte[] encryptedAesKey = new byte[byteSize];
        byte[] encryptedData = new byte[bytes.length - byteSize];
        for (int i = 0; i < bytes.length; ++i) {
            if (i < byteSize) {
                encryptedAesKey[i] = bytes[i];
                continue;
            }
            encryptedData[i - byteSize] = bytes[i];
        }
        return Pair.of(encryptedAesKey, encryptedData);
    }

    public static Pair<byte[], byte[]> encrypt0(byte[] content) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_CIPHER_ALGORITHM);
        cipher.init(1, PUBLIC_RSA_KEY);
        byte[] encryptedKey = cipher.doFinal(AES_SECRET_KEY.getEncoded());
        Cipher aesCipher = Cipher.getInstance(AES_CIPHER_ALGORITHM);
        aesCipher.init(1, AES_SECRET_KEY);
        byte[] encryptedData = aesCipher.doFinal(content);
        return Pair.of(encryptedKey, encryptedData);
    }

    public static byte[] decrypt0(PrivateKey privateKey, byte[] encryptedAESKey, byte[] encryptedData) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_CIPHER_ALGORITHM);
        cipher.init(2, privateKey);
        byte[] decryptedKey = cipher.doFinal(encryptedAESKey);
        SecretKeySpec originalKey = new SecretKeySpec(decryptedKey, 0, decryptedKey.length, RSAAESHybrid.getMainMethod(AES_CIPHER_ALGORITHM));
        Cipher aesCipher = Cipher.getInstance(AES_CIPHER_ALGORITHM);
        aesCipher.init(2, originalKey);
        return aesCipher.doFinal(encryptedData);
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator RSAGen = KeyPairGenerator.getInstance(RSAAESHybrid.getMainMethod(RSA_CIPHER_ALGORITHM));
        RSAGen.initialize(2048);
        return RSAGen.generateKeyPair();
    }

    public static void generateAndPrintKeyPair() {
        try {
            KeyPair pair = RSAAESHybrid.generateKeyPair();
            System.out.println("AES: " + Arrays.toString(AES_SECRET_KEY.getEncoded()));
            System.out.println("Private: " + Arrays.toString(pair.getPrivate().getEncoded()));
            System.out.println("Public: " + Arrays.toString(pair.getPublic().getEncoded()));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        boolean supported = true;
        SecretKey secKey = null;
        PublicKey pubKey = null;
        try {
            KeyGenerator aesGen = KeyGenerator.getInstance(RSAAESHybrid.getMainMethod(AES_CIPHER_ALGORITHM));
            aesGen.init(128);
            secKey = aesGen.generateKey();
            pubKey = KeyFactory.getInstance(RSAAESHybrid.getMainMethod(RSA_CIPHER_ALGORITHM)).generatePublic(new X509EncodedKeySpec(new byte[]{48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -46, 18, 91, 66, -53, 114, 89, -53, 66, 72, 84, 54, 117, -11, 83, -45, -44, 8, 123, -45, -90, 112, 40, -86, -68, -21, -79, -110, -64, 73, 62, 70, -126, 2, -83, 18, -34, 35, 8, 41, -11, -37, -104, -81, -24, 55, 0, -120, 92, 45, 48, 105, -15, -115, 41, 110, -12, 103, -10, 6, -15, 117, 48, -91, -50, 51, 118, 118, -124, -117, -61, 5, 95, 112, -114, -6, 15, 98, -1, 52, -70, 57, 75, -80, -6, -46, -124, 34, 42, 31, 40, -108, -67, 95, 22, 90, -102, 121, -98, -10, -4, 4, 88, -115, -54, -79, 60, 110, -9, -79, -70, -60, -44, 98, 27, -100, -70, -106, -96, 5, 4, -49, 18, -84, -48, -50, -114, 63, 62, -66, 0, -122, -37, -38, 100, -29, 115, 83, 117, 3, -1, 59, 1, 121, 35, 63, 120, -65, 38, -127, 82, 74, -50, -23, -21, 60, 77, 35, -20, 41, 47, 68, -53, -28, 11, 36, 1, -40, 54, -128, -47, 66, 73, 11, 55, 117, -13, -119, 84, 100, 97, 94, 59, 53, 98, 78, 82, -101, -111, -91, 90, 40, -111, -74, -15, -55, 113, -94, 124, -114, 41, -74, -94, -92, 1, -63, 26, -67, -9, 117, 115, -113, 4, 65, 87, 122, 22, 63, 73, 12, 101, 101, -54, -26, 45, -119, 39, 107, 47, -90, -68, 24, -87, -125, 13, -49, 32, 121, -91, -51, 12, 114, 23, -36, 113, 17, 61, 48, 92, 44, -32, -25, 72, 23, -111, -59, 2, 3, 1, 0, 1}));
            RSAAESHybrid.encrypt("Hello World!".getBytes());
        }
        catch (Throwable ex) {
            try {
                if (KLogger.isDebugging()) {
                    ex.printStackTrace();
                }
            }
            catch (Throwable exx) {
                exx.printStackTrace();
            }
            supported = false;
        }
        AES_SECRET_KEY = secKey;
        PUBLIC_RSA_KEY = pubKey;
        SUPPORTED = supported;
    }
}

