/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class GZIPCompressor {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (ByteArrayOutputStream obj = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(obj);){
                gzip.write(bytes);
                gzip.close();
                byArray = obj.toByteArray();
            }
            return byArray;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));){
            byte[] byArray;
            byte[] buffer = new byte[1024];
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int len;
                while ((len = gis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

