/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.playerselector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.messenger.CombinedMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.playerselector.AbstractPlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorGUI;
import org.kingdoms.utils.playerselector.PlayerSelectorInfo;
import org.kingdoms.utils.playerselector.PlayerSelectorProvider;
import org.kingdoms.utils.playerselector.PlayerSelectorRegistry;
import org.kingdoms.utils.playerselector.SimplePlayerSelectorProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R \u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorUnion;", "Lorg/kingdoms/utils/playerselector/AbstractPlayerSelector;", "<init>", "()V", "OR", "", "getOR$annotations", "getOR", "()Z", "setOR", "(Z)V", "elements", "", "Lorg/kingdoms/utils/playerselector/PlayerSelector;", "getElements", "()Ljava/util/List;", "isValid", "provider", "Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "getProvider", "()Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "test", "info", "Lorg/kingdoms/utils/playerselector/PlayerSelectorInfo;", "serialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "deserialize", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "addMessageContextEdits", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerSelectorUnion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSelectorUnion.kt\norg/kingdoms/utils/playerselector/PlayerSelectorUnion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1755#2,3:153\n1755#2,3:156\n1734#2,3:159\n*S KotlinDebug\n*F\n+ 1 PlayerSelectorUnion.kt\norg/kingdoms/utils/playerselector/PlayerSelectorUnion\n*L\n110#1:153,3\n114#1:156,3\n114#1:159,3\n*E\n"})
public final class PlayerSelectorUnion
extends AbstractPlayerSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean OR = true;
    @NotNull
    private final List<PlayerSelector> elements = new ArrayList();
    @JvmField
    @NotNull
    public static final SimplePlayerSelectorProvider<PlayerSelectorUnion> PROVIDER;

    public PlayerSelectorUnion() {
        super(PROVIDER.getNamespace());
    }

    public final boolean getOR() {
        return this.OR;
    }

    public final void setOR(boolean bl) {
        this.OR = bl;
    }

    public static /* synthetic */ void getOR$annotations() {
    }

    @NotNull
    public final List<PlayerSelector> getElements() {
        return this.elements;
    }

    @Override
    public boolean isValid() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PlayerSelector it = (PlayerSelector)element$iv;
                    boolean bl2 = false;
                    if (!it.isValid()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public PlayerSelectorProvider<PlayerSelectorUnion> getProvider() {
        return PROVIDER;
    }

    @Override
    public boolean test(@NotNull PlayerSelectorInfo info) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (this.OR) {
                Iterable $this$any$iv = this.elements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerSelector it = (PlayerSelector)element$iv;
                        boolean bl2 = false;
                        if (!it.test(info)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                Iterable $this$all$iv = this.elements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PlayerSelector it = (PlayerSelector)element$iv;
                        boolean bl3 = false;
                        if (it.test(info)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        context.getDataProvider().setBoolean("OR", this.OR);
        context.getDataProvider().get("elements").setCollection((Collection)this.elements, (arg_0, arg_1) -> PlayerSelectorUnion.serialize$lambda$3(context, arg_0, arg_1));
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.OR = context.getDataProvider().getBoolean("OR");
        context.getDataProvider().get("elements").asCollection((Collection)this.elements, (arg_0, arg_1) -> PlayerSelectorUnion.deserialize$lambda$4(context, arg_0, arg_1));
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.raw("ORmode", this.OR);
        context.raw("elementsSize", this.elements.size());
        CombinedMessenger linker = new CombinedMessenger(new Messenger[0]);
        Object object = context.providePlaceholder("depth");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = "";
        }
        String depth = string;
        Iterator iterator = ((Iterable)this.elements).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            PlayerSelector element = (PlayerSelector)iterator.next();
            linker.add(new StaticMessenger("%depth%{$dot} "));
            linker.add(PlayerSelectorGUI.buildPlayerSelectorInfo(element, depth));
            if (index + 1 == this.elements.size()) continue;
            linker.add(new StaticMessenger("\n"));
        }
        context.raw("elements", linker);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "::" + (this.OR ? "OR" : "AND") + '(' + CollectionsKt.joinToString$default((Iterable)this.elements, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    private static final void serialize$lambda$3(SerializationContext $context, SectionCreatableDataSetter setter, PlayerSelector data) {
        Intrinsics.checkNotNullParameter((Object)setter, (String)"setter");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SerializationContext<DataSetter> serializationContext = $context.createFor((DataSetter)setter.createSection());
        Intrinsics.checkNotNullExpressionValue(serializationContext, (String)"createFor(...)");
        data.serialize(serializationContext);
    }

    private static final void deserialize$lambda$4(DeserializationContext $context, List elements, SectionableDataGetter getter) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        DeserializationContext<DataGetter> deserializationContext = $context.createFor((DataGetter)getter);
        Intrinsics.checkNotNullExpressionValue(deserializationContext, (String)"createFor(...)");
        elements.add(PlayerSelectorRegistry.Companion.deserialize(deserializationContext));
    }

    static {
        Namespace namespace = Namespace.kingdoms("UNION");
        Supplier<PlayerSelectorUnion> supplier = PlayerSelectorUnion::new;
        PROVIDER = new SimplePlayerSelectorProvider<PlayerSelectorUnion>(namespace, supplier){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $super_call_param$2);
            }

            public CompletionStage<PlayerSelectorUnion> prompt(Player player, PlayerSelectorUnion selector) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                CompletableFuture<PlayerSelectorUnion> completable = new CompletableFuture<PlayerSelectorUnion>();
                new Companion.UnionGUI(selector, player, completable).openUnionGUI();
                return completable;
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorUnion$Companion;", "", "<init>", "()V", "PROVIDER", "Lorg/kingdoms/utils/playerselector/SimplePlayerSelectorProvider;", "Lorg/kingdoms/utils/playerselector/PlayerSelectorUnion;", "UnionGUI", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorUnion$Companion$UnionGUI;", "", "union", "Lorg/kingdoms/utils/playerselector/PlayerSelectorUnion;", "player", "Lorg/bukkit/entity/Player;", "completable", "Ljava/util/concurrent/CompletableFuture;", "<init>", "(Lorg/kingdoms/utils/playerselector/PlayerSelectorUnion;Lorg/bukkit/entity/Player;Ljava/util/concurrent/CompletableFuture;)V", "shouldComplete", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getShouldComplete", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "openUnionGUI", "", "core"})
        private static final class UnionGUI {
            @NotNull
            private final PlayerSelectorUnion union;
            @NotNull
            private final Player player;
            @NotNull
            private final CompletableFuture<PlayerSelectorUnion> completable;
            @NotNull
            private final AtomicBoolean shouldComplete;

            public UnionGUI(@NotNull PlayerSelectorUnion union, @NotNull Player player, @NotNull CompletableFuture<PlayerSelectorUnion> completable) {
                Intrinsics.checkNotNullParameter((Object)union, (String)"union");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter(completable, (String)"completable");
                this.union = union;
                this.player = player;
                this.completable = completable;
                this.shouldComplete = new AtomicBoolean(false);
            }

            @NotNull
            public final AtomicBoolean getShouldComplete() {
                return this.shouldComplete;
            }

            public final void openUnionGUI() {
                Object t = new GUIBuilder("player-selectors/union").forPlayer(this.player).editMessageContext(arg_0 -> UnionGUI.openUnionGUI$lambda$0(this, arg_0)).build();
                Intrinsics.checkNotNull(t);
                Object unionGUI = t;
                ReusableOptionHandler reusableOptionHandler = ((InteractiveGUI)unionGUI).getReusableOption("elements");
                Intrinsics.checkNotNull((Object)reusableOptionHandler);
                ReusableOptionHandler elementsOption = reusableOptionHandler;
                for (PlayerSelector element : this.union.getElements()) {
                    if (!elementsOption.hasNext()) break;
                    elementsOption.getMessageContext().inheritContext(element.getMessageContext(), true);
                    elementsOption.getMessageContext().raw("type", element.getNamespace().getConfigOptionName()).raw("player_selector_name", PlayerSelectorGUI.getSelectorName(element)).raw("player_selector_info", PlayerSelectorGUI.buildPlayerSelectorInfo(element));
                    PlayerSelectorGUI.handleGrouped(elementsOption, this.union.getElements(), element, () -> UnionGUI.openUnionGUI$lambda$2(element, this), () -> UnionGUI.openUnionGUI$lambda$3(this));
                }
                ((InteractiveGUI)unionGUI).push("logic-toggle", () -> UnionGUI.openUnionGUI$lambda$4(this), new Object[0]);
                ((InteractiveGUI)unionGUI).option("back").on(ClickType.LEFT, () -> UnionGUI.openUnionGUI$lambda$5(this)).on(ClickType.RIGHT, () -> UnionGUI.openUnionGUI$lambda$6(this)).done();
                ((InteractiveGUI)unionGUI).push("add", () -> UnionGUI.openUnionGUI$lambda$9(this), new Object[0]);
                ((InteractiveGUI)unionGUI).onClose(() -> UnionGUI.openUnionGUI$lambda$10(unionGUI, this));
                InteractiveGUI.open$default(unionGUI, false, false, 3, null);
            }

            private static final void openUnionGUI$lambda$0(UnionGUI this$0, MessagePlaceholderProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.inheritPlaceholders(this$0.union.getMessageContext());
                it.parse("mode", this$0.union.getOR() ? "&dOR" : "&5AND");
            }

            private static final void openUnionGUI$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void openUnionGUI$lambda$2(PlayerSelector $element, UnionGUI this$0) {
                PlayerSelectorProvider<? extends PlayerSelector> playerSelectorProvider = $element.getProvider();
                Player player = this$0.player;
                Object t = Fn.cast($element);
                Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
                playerSelectorProvider.prompt(player, (PlayerSelector)t).thenAccept(arg_0 -> UnionGUI.openUnionGUI$lambda$2$lambda$1(new Function1(this$0){
                    final /* synthetic */ UnionGUI this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void invoke(PlayerSelector playerSelector) {
                        this.this$0.openUnionGUI();
                    }
                }, arg_0));
            }

            private static final void openUnionGUI$lambda$3(UnionGUI this$0) {
                this$0.openUnionGUI();
            }

            private static final void openUnionGUI$lambda$4(UnionGUI this$0) {
                this$0.union.setOR(!this$0.union.getOR());
                this$0.openUnionGUI();
            }

            private static final void openUnionGUI$lambda$5(UnionGUI this$0) {
                boolean andSet = this$0.shouldComplete.getAndSet(false);
                boolean bl = andSet ? this$0.completable.complete(this$0.union) : this$0.completable.complete(null);
            }

            private static final void openUnionGUI$lambda$6(UnionGUI this$0) {
                this$0.shouldComplete.set(false);
                this$0.completable.complete(null);
            }

            private static final Unit openUnionGUI$lambda$9$lambda$7(UnionGUI this$0, PlayerSelector it) {
                if (it != null) {
                    this$0.union.getElements().add(it);
                    this$0.shouldComplete.set(true);
                }
                this$0.openUnionGUI();
                return Unit.INSTANCE;
            }

            private static final void openUnionGUI$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void openUnionGUI$lambda$9(UnionGUI this$0) {
                PlayerSelectorGUI.createPlayerSelector(this$0.player).thenAccept(arg_0 -> UnionGUI.openUnionGUI$lambda$9$lambda$8(arg_0 -> UnionGUI.openUnionGUI$lambda$9$lambda$7(this$0, arg_0), arg_0));
            }

            private static final void openUnionGUI$lambda$10(InteractiveGUI $unionGUI, UnionGUI this$0) {
                if ($unionGUI.wasSwitched() || $unionGUI.wasRefreshed()) {
                    return;
                }
                if (this$0.shouldComplete.getAndSet(false)) {
                    this$0.completable.complete(this$0.union);
                }
            }
        }
    }
}

