/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.playerselector;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.ContextualMessenger;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.internal.iterator.ListUtils;
import org.kingdoms.utils.playerselector.PlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorProvider;
import org.kingdoms.utils.playerselector.PlayerSelectorRegistry;

public final class PlayerSelectorGUI {
    public static CompletionStage<PlayerSelector> createPlayerSelector(Player viewer) {
        CompletableFuture<PlayerSelector> completable = new CompletableFuture<PlayerSelector>();
        Object gui = new GUIBuilder("player-selectors/types").forPlayer(viewer).build();
        for (PlayerSelectorProvider psProvider : PlayerSelectorRegistry.INSTANCE.getRegistry().values()) {
            ((InteractiveGUI)gui).option(psProvider.getNamespace().getConfigOptionName()).onNormalClicks(() -> psProvider.prompt(gui.getOwner()).thenAccept(completable::complete)).done();
        }
        ((InteractiveGUI)gui).push("cancel", () -> completable.complete(null), new Object[0]);
        ((InteractiveGUI)gui).open();
        return completable;
    }

    public static <T> void handleGrouped(OptionHandler option, List<T> entries, T target, Runnable openTarget, Runnable reopen) {
        option.on(ClickType.SHIFT_LEFT, () -> {
            ListUtils.moveOneElementCloserToStart(entries, target);
            reopen.run();
        }).on(ClickType.SHIFT_RIGHT, () -> {
            ListUtils.moveOneElementCloserToEnd(entries, target);
            reopen.run();
        }).on(ClickType.LEFT, openTarget).on(ClickType.DROP, () -> {
            entries.remove(target);
            reopen.run();
        }).done();
    }

    public static Messenger getSelectorName(PlayerSelector playerSelector) {
        if (playerSelector == null) {
            return KingdomsLang.NONE;
        }
        return new LanguageEntryMessenger("player-selectors", playerSelector.getNamespace().getConfigOptionName(), "name").or(() -> new StaticMessenger(playerSelector.getNamespace().asString()));
    }

    public static Messenger buildPlayerSelectorInfo(PlayerSelector playerSelector) {
        return PlayerSelectorGUI.buildPlayerSelectorInfo(playerSelector, "");
    }

    public static Messenger buildPlayerSelectorInfo(PlayerSelector playerSelector, String depth) {
        if (playerSelector == null) {
            return KingdomsLang.NONE;
        }
        DefaultedMessenger infoMessage = new LanguageEntryMessenger("player-selectors", playerSelector.getNamespace().getConfigOptionName(), "info").or(() -> new StaticMessenger(playerSelector.toString()));
        MessagePlaceholderProvider ctx = new MessagePlaceholderProvider().raw("depth", depth + "  ");
        playerSelector.addMessageContextEdits(ctx);
        return new ContextualMessenger(infoMessage, ctx);
    }
}

