/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.playerselector;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.playerselector.AbstractPlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorByRank;
import org.kingdoms.utils.playerselector.PlayerSelectorInfo;
import org.kingdoms.utils.playerselector.PlayerSelectorProvider;
import org.kingdoms.utils.playerselector.SimplePlayerSelectorProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorByRank;", "Lorg/kingdoms/utils/playerselector/AbstractPlayerSelector;", "<init>", "()V", "rankNode", "", "getRankNode", "()Ljava/lang/String;", "setRankNode", "(Ljava/lang/String;)V", "isValid", "", "()Z", "provider", "Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "getProvider", "()Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "test", "info", "Lorg/kingdoms/utils/playerselector/PlayerSelectorInfo;", "serialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "deserialize", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "addMessageContextEdits", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "Companion", "core"})
public final class PlayerSelectorByRank
extends AbstractPlayerSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public String rankNode;
    private final boolean isValid;
    @JvmField
    @NotNull
    public static final SimplePlayerSelectorProvider<PlayerSelectorByRank> PROVIDER;

    public PlayerSelectorByRank() {
        super(PROVIDER.getNamespace());
        this.isValid = true;
    }

    @NotNull
    public final String getRankNode() {
        String string = this.rankNode;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rankNode");
        return null;
    }

    public final void setRankNode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.rankNode = string;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public PlayerSelectorProvider<PlayerSelectorByRank> getProvider() {
        return PROVIDER;
    }

    @Override
    public boolean test(@NotNull PlayerSelectorInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        KingdomPlayer kp = info.getKingdomPlayer();
        if (kp.getKingdom() == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)kp.getRankNode(), (Object)this.getRankNode());
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        context.getDataProvider().setString("node", this.getRankNode());
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        String string = context.getDataProvider().getString("node");
        Intrinsics.checkNotNull((Object)string);
        this.setRankNode(string);
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.raw("rank_node", this.getRankNode());
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getRankNode() + ')';
    }

    static {
        Namespace namespace = Namespace.kingdoms("RANK");
        Supplier<PlayerSelectorByRank> supplier = PlayerSelectorByRank::new;
        PROVIDER = new SimplePlayerSelectorProvider<PlayerSelectorByRank>(namespace, supplier){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $super_call_param$2);
            }

            public CompletionStage<PlayerSelectorByRank> prompt(Player player, PlayerSelectorByRank selector) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                KingdomsLang.PLAYER_SELECTORS_RANK_PROMPT.sendMessage((CommandSender)player);
                CompletableFuture<PlayerSelectorByRank> completableFuture = ChatInputManager.awaitInput(player, Companion.PROVIDER.1::prompt$lambda$1);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"awaitInput(...)");
                return completableFuture;
            }

            private static final PlayerSelectorByRank prompt$lambda$1(String input) {
                PlayerSelectorByRank playerSelectorByRank;
                PlayerSelectorByRank $this$prompt_u24lambda_u241_u24lambda_u240 = playerSelectorByRank = new PlayerSelectorByRank();
                boolean bl = false;
                $this$prompt_u24lambda_u241_u24lambda_u240.setRankNode(input);
                return playerSelectorByRank;
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorByRank$Companion;", "", "<init>", "()V", "PROVIDER", "Lorg/kingdoms/utils/playerselector/SimplePlayerSelectorProvider;", "Lorg/kingdoms/utils/playerselector/PlayerSelectorByRank;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

