/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.playerselector;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.playerselector.AbstractPlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorByNation;
import org.kingdoms.utils.playerselector.PlayerSelectorInfo;
import org.kingdoms.utils.playerselector.PlayerSelectorProvider;
import org.kingdoms.utils.playerselector.SimplePlayerSelectorProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorByNation;", "Lorg/kingdoms/utils/playerselector/AbstractPlayerSelector;", "<init>", "()V", "nation", "Ljava/util/UUID;", "getNation", "()Ljava/util/UUID;", "setNation", "(Ljava/util/UUID;)V", "isValid", "", "()Z", "provider", "Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "getProvider", "()Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "test", "info", "Lorg/kingdoms/utils/playerselector/PlayerSelectorInfo;", "serialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "deserialize", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "addMessageContextEdits", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerSelectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSelectors.kt\norg/kingdoms/utils/playerselector/PlayerSelectorByNation\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,269:1\n37#2:270\n37#2:271\n*S KotlinDebug\n*F\n+ 1 PlayerSelectors.kt\norg/kingdoms/utils/playerselector/PlayerSelectorByNation\n*L\n185#1:270\n204#1:271\n*E\n"})
public final class PlayerSelectorByNation
extends AbstractPlayerSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public UUID nation;
    @JvmField
    @NotNull
    public static final SimplePlayerSelectorProvider<PlayerSelectorByNation> PROVIDER;

    public PlayerSelectorByNation() {
        super(PROVIDER.getNamespace());
    }

    @NotNull
    public final UUID getNation() {
        UUID uUID = this.nation;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nation");
        return null;
    }

    public final void setNation(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.nation = uUID;
    }

    @Override
    public boolean isValid() {
        KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
        UUID $this$asNation$iv = this.getNation();
        boolean $i$f$asNation = false;
        return Nation.getNation($this$asNation$iv) != null;
    }

    @NotNull
    public PlayerSelectorProvider<PlayerSelectorByNation> getProvider() {
        return PROVIDER;
    }

    @Override
    public boolean test(@NotNull PlayerSelectorInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        KingdomPlayer kp = info.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return false;
        }
        Kingdom kingdom2 = kingdom;
        return kingdom2.getNationId() == this.getNation();
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        context.getDataProvider().setUUID("nation", this.getNation());
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        UUID uUID = context.getDataProvider().get("nation").asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        this.setNation(uUID);
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
        UUID $this$asNation$iv = this.getNation();
        boolean $i$f$asNation = false;
        Nation nation = Nation.getNation($this$asNation$iv);
        if (nation != null) {
            context.withContext(nation);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getNation() + ')';
    }

    static {
        Namespace namespace = Namespace.kingdoms("NATION");
        Supplier<PlayerSelectorByNation> supplier = PlayerSelectorByNation::new;
        PROVIDER = new SimplePlayerSelectorProvider<PlayerSelectorByNation>(namespace, supplier){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $super_call_param$2);
            }

            public CompletionStage<PlayerSelectorByNation> prompt(Player player, PlayerSelectorByNation selector) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                KingdomsLang.PLAYER_SELECTORS_NATION_PROMPT.sendMessage((CommandSender)player);
                CompletableFuture<PlayerSelectorByNation> completableFuture = ChatInputManager.awaitInput(player, arg_0 -> Companion.PROVIDER.1.prompt$lambda$1(player, arg_0));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"awaitInput(...)");
                return completableFuture;
            }

            private static final PlayerSelectorByNation prompt$lambda$1(Player $player, String input) {
                PlayerSelectorByNation playerSelectorByNation;
                Nation nation = Nation.getNation(input);
                if (nation == null) {
                    Object[] objectArray = new Object[]{"nation", input};
                    KingdomsLang.NOT_FOUND_NATION.sendError((CommandSender)$player, objectArray);
                    return null;
                }
                PlayerSelectorByNation $this$prompt_u24lambda_u241_u24lambda_u240 = playerSelectorByNation = new PlayerSelectorByNation();
                boolean bl = false;
                $this$prompt_u24lambda_u241_u24lambda_u240.setNation(nation.getId());
                return playerSelectorByNation;
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorByNation$Companion;", "", "<init>", "()V", "PROVIDER", "Lorg/kingdoms/utils/playerselector/SimplePlayerSelectorProvider;", "Lorg/kingdoms/utils/playerselector/PlayerSelectorByNation;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

