/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.util.Base64;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.kingdoms.libs.xseries.reflection.ReflectiveNamespace;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.jvm.MemberHandle;
import org.kingdoms.libs.xseries.reflection.jvm.classes.ClassHandle;
import org.kingdoms.libs.xseries.reflection.jvm.classes.DynamicClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.platform.bukkit.item.ItemNBT;

public final class JsonItemStack {
    private static final MethodHandle MOJANG_PARSER;
    private static final MethodHandle NBT_TAG_COMPOUND;
    private static final MethodHandle LOAD_FROM_NBT;
    private static final MethodHandle SAVE_NBT_TO;
    private static final MethodHandle CustomData_CTOR;
    private static final Object DataComponenets_CUSTOM_DATA;
    private static final Object REGISTRY_ACCESS;

    public static ItemStack deserialize(String json) {
        try {
            Object nbtTagCompound = MOJANG_PARSER.invoke(json);
            Object itemStack = XReflection.supports((int)21) ? LOAD_FROM_NBT.invoke(REGISTRY_ACCESS, nbtTagCompound) : LOAD_FROM_NBT.invoke(nbtTagCompound);
            return ItemNBT.AS_BUKKIT_COPY.invoke(itemStack);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static String serialize(ItemStack item) {
        try {
            Object tag;
            Object nms = ItemNBT.AS_NMS_COPY.invoke(item);
            if (XReflection.supports((int)21)) {
                tag = SAVE_NBT_TO.invoke(nms, REGISTRY_ACCESS);
            } else {
                tag = NBT_TAG_COMPOUND.invoke();
                SAVE_NBT_TO.invoke(nms, tag);
            }
            return tag.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static String encodeInventory(Inventory inventory) {
        String string;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BukkitObjectOutputStream data = new BukkitObjectOutputStream((OutputStream)output);
        try {
            data.writeInt(inventory.getSize());
            data.writeChars(((HumanEntity)inventory.getViewers().iterator().next()).getName());
            for (int i = 0; i < inventory.getSize(); ++i) {
                data.writeObject((Object)inventory.getItem(i));
            }
            string = Base64.getEncoder().encodeToString(output.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return "";
            }
        }
        data.close();
        return string;
    }

    public static Inventory decodeInventory(String encoded) {
        Inventory inventory;
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.getDecoder().decode(encoded));
        BukkitObjectInputStream data = new BukkitObjectInputStream((InputStream)input);
        try {
            Inventory inventory2 = Bukkit.createInventory(null, (int)data.readInt(), (String)data.readObject().toString());
            for (int i = 0; i < inventory2.getSize(); ++i) {
                inventory2.setItem(i, (ItemStack)data.readObject());
            }
            inventory = inventory2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        data.close();
        return inventory;
    }

    static {
        MinecraftClassHandle CompoundTag = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, "CompoundTag").map(MinecraftMapping.SPIGOT, "NBTTagCompound");
        Class NBTBase = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, "Tag").map(MinecraftMapping.SPIGOT, "NBTBase").unreflect();
        MinecraftClassHandle nmsItemStack = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.item").map(MinecraftMapping.MOJANG, "ItemStack").map(MinecraftMapping.SPIGOT, "ItemStack");
        MinecraftClassHandle craftItemStack = XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "inventory").named(new String[]{"CraftItemStack"});
        MinecraftClassHandle TagParserClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "nbt").map(MinecraftMapping.MOJANG, "TagParser").map(MinecraftMapping.SPIGOT, "MojangsonParser");
        MOJANG_PARSER = (MethodHandle)TagParserClass.method().asStatic().map(MinecraftMapping.MOJANG, "parseTag").map(MinecraftMapping.OBFUSCATED, (String)XReflection.v((int)18, (Object)"a").orElse((Object)"parse")).parameters(new Class[]{String.class}).returns((ClassHandle)CompoundTag).unreflect();
        NBT_TAG_COMPOUND = (MethodHandle)CompoundTag.constructor().unreflect();
        if (XReflection.supports((int)21)) {
            ReflectiveNamespace ns = XReflection.namespaced();
            MinecraftClassHandle CustomData = ns.ofMinecraft("package nms.world.item.component; public final class CustomData");
            MinecraftClassHandle DataComponentHolder = ns.ofMinecraft("package nms.core.component; public interface DataComponentHolder");
            MinecraftClassHandle DataComponentType = ns.ofMinecraft("package nms.core.component; public interface DataComponentType");
            MinecraftClassHandle DataComponents = ns.ofMinecraft("package nms.core.component; public class DataComponents");
            MethodHandle DataComponenets_CUSTOM_DATA$field = (MethodHandle)DataComponents.field("public static DataComponentType<CustomData> CUSTOM_DATA").map(MinecraftMapping.OBFUSCATED, "b").getter().unreflect();
            try {
                DataComponenets_CUSTOM_DATA = DataComponenets_CUSTOM_DATA$field.invoke();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            Class HolderLookup$Provider = (Class)((MinecraftClassHandle)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core").named(new String[]{"HolderLookup"}).inner((DynamicClassHandle)XReflection.ofMinecraft().map(MinecraftMapping.MOJANG, "Provider").map(MinecraftMapping.SPIGOT, "a"))).unreflect();
            Class DataComponentPatch = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core.component").named(new String[]{"DataComponentPatch"}).unreflect();
            CustomData_CTOR = (MethodHandle)CustomData.constructor(new ClassHandle[]{CompoundTag}).makeAccessible().unreflect();
            LOAD_FROM_NBT = (MethodHandle)nmsItemStack.method().parameters(new Class[]{HolderLookup$Provider, (Class)CompoundTag.unreflect()}).returns((ClassHandle)nmsItemStack).map(MinecraftMapping.MOJANG, "parseOptional").map(MinecraftMapping.OBFUSCATED, "a").unreflect();
            SAVE_NBT_TO = (MethodHandle)nmsItemStack.method().returns(NBTBase).parameters(new Class[]{HolderLookup$Provider}).map(MinecraftMapping.MOJANG, "save").map(MinecraftMapping.OBFUSCATED, "a").unreflect();
            MinecraftClassHandle MinecraftServer2 = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server").named(new String[]{"MinecraftServer"});
            try {
                Object minecraftServer = MinecraftServer2.method("public static MinecraftServer getServer()").reflect().invoke();
                MinecraftClassHandle RegistryAccess = (MinecraftClassHandle)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core").map(MinecraftMapping.MOJANG, "RegistryAccess").map(MinecraftMapping.SPIGOT, "IRegistryCustom").inner((DynamicClassHandle)XReflection.ofMinecraft().map(MinecraftMapping.MOJANG, "Frozen").map(MinecraftMapping.SPIGOT, "Dimension"));
                REGISTRY_ACCESS = ((MethodHandle)MinecraftServer2.method().map(MinecraftMapping.MOJANG, "registryAccess").map(MinecraftMapping.SPIGOT, "bc").returns((ClassHandle)RegistryAccess).unreflect()).invoke(minecraftServer);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        DataComponenets_CUSTOM_DATA = null;
        REGISTRY_ACCESS = null;
        CustomData_CTOR = null;
        LOAD_FROM_NBT = (MethodHandle)((MemberHandle)XReflection.v((int)13, (Object)nmsItemStack.method().asStatic().named(new String[]{"a", "of"}).returns((ClassHandle)nmsItemStack).parameters(new ClassHandle[]{CompoundTag})).orElse((Object)nmsItemStack.constructor(new ClassHandle[]{CompoundTag}))).unreflect();
        SAVE_NBT_TO = (MethodHandle)nmsItemStack.method().returns((ClassHandle)CompoundTag).parameters(new ClassHandle[]{CompoundTag}).map(MinecraftMapping.MOJANG, "save").map(MinecraftMapping.OBFUSCATED, (String)XReflection.v((int)18, (Object)"b").orElse((Object)"save")).unreflect();
    }
}

