/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class EntitySpawner<T extends Entity> {
    private final Class<T> entityType;
    private Location location;
    private Consumer<T> modifier;

    public EntitySpawner(Class<T> entityType) {
        this.entityType = entityType;
    }

    public static <T extends Entity> EntitySpawner<T> of(Class<T> clazz) {
        return new EntitySpawner<T>(clazz);
    }

    public EntitySpawner<T> at(Location location) {
        this.location = Objects.requireNonNull(location);
        return this;
    }

    public EntitySpawner<T> modify(Consumer<T> modifier) {
        this.modifier = Objects.requireNonNull(modifier);
        return this;
    }

    public T spawn() {
        Objects.requireNonNull(this.location, "No location provided for entity");
        if (this.modifier != null && VersionSupport.SUPPORTS_PRE_SPAWN_FUNCTIONS) {
            return (T)this.location.getWorld().spawn(this.location, this.entityType, this.modifier);
        }
        Entity entity2 = this.location.getWorld().spawn(this.location, this.entityType);
        if (this.modifier != null) {
            this.modifier.accept(entity2);
        }
        return (T)entity2;
    }
}

