/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.utils.cache.EnumCache;

public final class EntityFactory {
    private static final MethodHandle SPAWN_PACKET;
    private static final MethodHandle CREATE_ENTITY;
    private static final MethodHandle ADD_ENTITY;
    private static final MethodHandle GET_BUKKIT_ENTITY;
    private static final MethodHandle DESTROY_PACKET;
    private static final MethodHandle GET_NMS_WORLD;
    private static final BiMap<EntityType, XMaterial> ENTITY_MATERIAL_MAPPING;

    public static @Nullable XMaterial getMaterialFromEntity(Entity entity2) {
        Objects.requireNonNull(entity2, "Null entity");
        return (XMaterial)ENTITY_MATERIAL_MAPPING.get((Object)entity2.getType());
    }

    public static @Nullable EntityType getEntityTypeFromMaterial(XMaterial material) {
        Objects.requireNonNull(material, "Null material");
        return (EntityType)ENTITY_MATERIAL_MAPPING.inverse().get((Object)material);
    }

    public static Object getNMSWorld(World world) {
        try {
            return GET_NMS_WORLD.invoke(world);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Entity> T createEntity(Location location, EntityType type) {
        try {
            Object nmsEntity = CREATE_ENTITY.invoke(location.getWorld(), location, type.getEntityClass());
            return EntityFactory.getBukkitEntity(nmsEntity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> T getBukkitEntity(Object nmsEntity) {
        try {
            return (T)GET_BUKKIT_ENTITY.invoke(nmsEntity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void removeEntity(Collection<? extends Player> players, List<Integer> entities) {
        Object packet;
        try {
            void var4_5;
            int[] ids = new int[entities.size()];
            boolean bl = false;
            while (var4_5 < entities.size()) {
                ids[var4_5] = entities.get((int)var4_5);
                ++var4_5;
            }
            packet = DESTROY_PACKET.invoke(ids);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        for (Player player : players) {
            MinecraftConnection.sendPacket((Player)player, (Object[])new Object[]{packet});
        }
    }

    public static Object createSpawnPacket(Object nmsLivingEntity) {
        try {
            return SPAWN_PACKET.invoke(nmsLivingEntity);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addEntity(World world, Object nmsEntity) {
        try {
            ADD_ENTITY.invoke(world, nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        ENTITY_MATERIAL_MAPPING = HashBiMap.create();
        for (EntityType entityType : EnumCache.ENTITY_TYPES) {
            Optional.of(XMaterial.matchXMaterial((String)entityType.name())).orElseGet(() -> XMaterial.matchXMaterial((String)(entityType.name() + "_SPAWN_EGG"))).ifPresent(mat -> ENTITY_MATERIAL_MAPPING.put((Object)entityType, mat));
        }
        Class craftWorldClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB).named(new String[]{"CraftWorld"}).unreflect();
        Class WorldServer = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerLevel").map(MinecraftMapping.SPIGOT, "WorldServer").unreflect();
        Class nmsEntity = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "Entity").map(MinecraftMapping.SPIGOT, "Entity").unreflect();
        Class craftEntity = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named(new String[]{"CraftEntity"}).unreflect();
        Class NMSEntityLiving = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "LivingEntity").map(MinecraftMapping.SPIGOT, "EntityLiving").unreflect();
        Class PacketPlayOutEntityDestroy = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundRemoveEntitiesPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutEntityDestroy").unreflect();
        Class packetSpawnClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundAddEntityPacket").map(MinecraftMapping.SPIGOT, (String)XReflection.v((int)19, (Object)"PacketPlayOutSpawnEntity").orElse((Object)"PacketPlayOutSpawnEntityLiving")).unreflect();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle createEntity = null;
        MethodHandle getNMSWorld = null;
        MethodHandle addEntity = null;
        MethodHandle getBukkitEntity = null;
        MethodHandle destroyPacket = null;
        MethodHandle spawnPacket = null;
        try {
            getNMSWorld = lookup.findVirtual(craftWorldClass, "getHandle", MethodType.methodType(WorldServer));
            spawnPacket = lookup.findConstructor(packetSpawnClass, (MethodType)XReflection.v((int)19, (Object)MethodType.methodType(Void.TYPE, nmsEntity)).orElse((Object)MethodType.methodType(Void.TYPE, NMSEntityLiving)));
            createEntity = lookup.findVirtual(craftWorldClass, "createEntity", MethodType.methodType((Class)XReflection.v((int)20, (int)4, Entity.class).orElse((Object)nmsEntity), Location.class, Class.class));
            getBukkitEntity = lookup.findVirtual(nmsEntity, "getBukkitEntity", MethodType.methodType(craftEntity));
            addEntity = lookup.findVirtual(craftWorldClass, "addEntity", MethodType.methodType(Entity.class, nmsEntity, CreatureSpawnEvent.SpawnReason.class));
            destroyPacket = lookup.findConstructor(PacketPlayOutEntityDestroy, MethodType.methodType(Void.TYPE, int[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        GET_NMS_WORLD = getNMSWorld;
        SPAWN_PACKET = spawnPacket;
        GET_BUKKIT_ENTITY = getBukkitEntity;
        CREATE_ENTITY = createEntity;
        ADD_ENTITY = addEntity;
        DESTROY_PACKET = destroyPacket.asFixedArity();
    }
}

