/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.io.CloseableKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cache.single.ExpirableCachedSupplier;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.fs.FSUtil;
import org.kingdoms.utils.network.CommitDifference;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0007\u00a2\u0006\u0002\u0010\nJ)\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J#\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0007\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0007J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"J\b\u0010&\u001a\u00020\u0007H\u0007R\u0016\u0010\u0011\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0003R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lorg/kingdoms/utils/network/JSONRequester;", "", "<init>", "()V", "get", "T", "urlString", "", "rootType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "url", "Ljava/net/URL;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "inputStreamToString", "input", "Ljava/io/InputStream;", "API_URL", "getAPI_URL$annotations", "USER_AGENT", "MASTER_SHA", "Lorg/kingdoms/utils/cache/single/ExpirableCachedSupplier;", "getMASTER_SHA$annotations", "getMASTER_SHA", "()Lorg/kingdoms/utils/cache/single/ExpirableCachedSupplier;", "getDifference", "Lorg/kingdoms/utils/network/CommitDifference;", "lastCommit", "folderFilter", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/kingdoms/utils/network/CommitDifference;", "downloadGitHubFile", "path", "to", "Ljava/nio/file/Path;", "downloadFile", "", "link", "getMasterSHA", "core"})
@SourceDebugExtension(value={"SMAP\nJSONRequester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONRequester.kt\norg/kingdoms/utils/network/JSONRequester\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class JSONRequester {
    @NotNull
    public static final JSONRequester INSTANCE;
    @NotNull
    private static final URL API_URL;
    @NotNull
    private static final String USER_AGENT;
    @NotNull
    private static final ExpirableCachedSupplier<String> MASTER_SHA;

    private JSONRequester() {
    }

    @JvmStatic
    public static final <T> T get(@NotNull String urlString, @NotNull Class<T> rootType) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        return JSONRequester.get(new URL(urlString), rootType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T get(@NotNull URL url, @NotNull Class<T> rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout((int)Duration.ofSeconds(30L).toMillis());
        connection.setReadTimeout((int)Duration.ofSeconds(10L).toMillis());
        connection.setRequestProperty("User-Agent", USER_AGENT);
        Closeable closeable = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        Throwable throwable = null;
        try {
            Object object;
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            try {
                object = new Gson().fromJson((Reader)it, rootType);
            }
            catch (Throwable ex) {
                Path savePath = FSUtil.findSlotForCounterFile(Kingdoms.getFolder(), "json-response", "json");
                Closeable closeable2 = connection.getInputStream();
                Throwable throwable2 = null;
                try {
                    InputStream errorSteam = (InputStream)closeable2;
                    boolean bl2 = false;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(errorSteam, savePath, copyOptionArray);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                throw new IllegalStateException("Failed to fetch from URL: " + url + " (The json response has been saved to " + savePath + ')', ex);
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String inputStreamToString(InputStream input) {
        String string = new BufferedReader(new InputStreamReader(input)).lines().collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
        return string;
    }

    @JvmStatic
    private static /* synthetic */ void getAPI_URL$annotations() {
    }

    @NotNull
    public static final ExpirableCachedSupplier<String> getMASTER_SHA() {
        return MASTER_SHA;
    }

    @JvmStatic
    public static /* synthetic */ void getMASTER_SHA$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final CommitDifference getDifference(@NotNull String lastCommit, @NotNull String[] folderFilter) {
        Intrinsics.checkNotNullParameter((Object)lastCommit, (String)"lastCommit");
        Intrinsics.checkNotNullParameter((Object)folderFilter, (String)"folderFilter");
        JsonObject json = JSONRequester.get("https://api.github.com/repos/CryptoMorin/KingdomsX/compare/" + lastCommit + "...master?per_page=1", JsonObject.class);
        String htmlURL = json.get("html_url").getAsString();
        int totalCommitDiff = json.get("total_commits").getAsInt();
        List files = new ArrayList();
        Iterator iterator = json.get("files").getAsJsonArray().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String filterStart;
            String string;
            String fileName;
            block2: {
                JsonElement file = (JsonElement)iterator2.next();
                fileName = file.getAsJsonObject().get("filename").getAsString();
                String[] stringArray = folderFilter;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String x = string2 = stringArray[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)fileName);
                    if (!StringsKt.startsWith$default((String)fileName, (String)x, (boolean)false, (int)2, null)) continue;
                    string = string2;
                    break block2;
                }
                string = null;
            }
            if ((filterStart = string) == null) continue;
            Intrinsics.checkNotNull((Object)fileName);
            String string3 = fileName.substring(filterStart.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            files.add(string3);
        }
        Intrinsics.checkNotNull((Object)htmlURL);
        return new CommitDifference(lastCommit, "master", totalCommitDiff, htmlURL, files);
    }

    @JvmStatic
    @Nullable
    public static final URL downloadGitHubFile(@NotNull String path, @NotNull Path to) throws IOException {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        URL url = new URL("https://github.com/CryptoMorin/KingdomsX/blob/master/" + path + "?raw=true");
        try {
            INSTANCE.downloadFile(url, to);
            uRL = url;
        }
        catch (FileNotFoundException ex) {
            uRL = null;
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadFile(@NotNull URL link, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        KLogger.debug((DebugNS)KingdomsDebug.DOWNLOAD, "Downloading: " + link);
        Closeable closeable = Channels.newChannel(link.openStream());
        Throwable throwable = null;
        try {
            long l;
            ReadableByteChannel readChan = (ReadableByteChannel)closeable;
            boolean bl = false;
            Files.createDirectories(to.getParent(), new FileAttribute[0]);
            Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            object = FileChannel.open(to, object);
            Throwable throwable2 = null;
            try {
                FileChannel output = (FileChannel)object;
                boolean bl2 = false;
                l = output.transferFrom(readChan, 0L, Long.MAX_VALUE);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final String getMasterSHA() {
        String string;
        try {
            JsonObject res = JSONRequester.get(API_URL, JsonObject.class);
            string = res.get("sha").getAsString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    static {
        URL uRL;
        INSTANCE = new JSONRequester();
        try {
            uRL = new URL("https://api.github.com/repos/CryptoMorin/KingdomsX/commits/master?per_page=1");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        API_URL = uRL;
        USER_AGENT = "KingdomsX/" + Kingdoms.get().getDescription().getVersion() + " (" + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("java.vendor") + "; " + System.getProperty("java.version") + ") " + Bukkit.getName() + '/' + Bukkit.getVersion() + " (" + Bukkit.getBukkitVersion() + ')';
        KLogger.debug((DebugNS)KingdomsDebug.DOWNLOAD, "User-Agent: " + USER_AGENT);
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        MASTER_SHA = new ExpirableCachedSupplier<String>(duration, JSONRequester::getMasterSHA);
    }
}

