/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.kingdoms;

import java.util.Objects;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;

public final class Shields {
    private Shields() {
    }

    public static boolean isEffectivelyPacifist(Kingdom kingdom) {
        return kingdom.isPacifist() && !KingdomsConfig.Invasions.MASSWAR_ALLOW_INVADING_PACIFISTS.getManager().getBoolean();
    }

    @NotNull
    public static Group getShieldToUse(@NotNull Kingdom kingdom) {
        Objects.requireNonNull(kingdom, "Null kingdom");
        if (kingdom.hasNation()) {
            boolean forceNationShield = KingdomsConfig.Invasions.NATIONS_USE_SHIELD.getManager().getBoolean();
            if (!forceNationShield && kingdom.getShield().hasShield()) {
                return kingdom;
            }
            long nationShieldAccessLoss = KingdomsConfig.Invasions.SHIELDS_NATION_SHIELD_ACCESS_LOSS.getManager().getTime(new PlaceholderContextBuilder().withContext(kingdom)).toMillis();
            if (nationShieldAccessLoss > 0L) {
                long lastInvasion = kingdom.getLastInvasion();
                long timePassedSinceLastInvade = System.currentTimeMillis() - lastInvasion;
                if (timePassedSinceLastInvade < nationShieldAccessLoss) {
                    return kingdom;
                }
            }
            return kingdom.getNation();
        }
        return kingdom;
    }
}

