/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.kingdoms;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupRelationshipChangeEvent;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.utils.internal.MapUtil;
import org.kingdoms.utils.string.Strings;

public final class RelationUtil {
    public static List<String> getRelationableKingdoms(CommandTabContext context, Kingdom kingdom, KingdomRelation relation) {
        return context.getKingdoms(0, x -> !kingdom.getName().equalsIgnoreCase((String)x) && kingdom.getRelationWith(Kingdom.getKingdom(x)) != relation);
    }

    public static int maxRelationsExceeded(Group group, KingdomRelation relation) {
        int relations = group.countRelationships(relation);
        int maxRelations = KingdomsConfig.Relations.RELATIONS.getManager().withProperty(Strings.configOption(relation)).withProperty("limit").getInt();
        if (maxRelations > 0 && relations >= maxRelations) {
            return maxRelations;
        }
        return 0;
    }

    public static List<String> handleRelationTab(CommandTabContext context, KingdomRelation relation) {
        Player player;
        KingdomPlayer kp;
        if (context.isPlayer() && (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)(player = context.senderAsPlayer()))).hasKingdom()) {
            Kingdom kingdom = kp.getKingdom();
            return RelationUtil.getRelationableKingdoms(context, kingdom, relation);
        }
        return new ArrayList<String>();
    }

    public static void eachOther(Nation first, Nation second, KingdomRelation relation) {
        Map<UUID, KingdomRelation> firstRels = MapUtil.toHashMap(relation, first.getKingdoms(), Group::getId);
        Map<UUID, KingdomRelation> secondRels = MapUtil.toHashMap(relation, second.getKingdoms(), Group::getId);
        for (Kingdom nationKingdom : first.getKingdoms()) {
            nationKingdom.getRelations().putAll(secondRels);
        }
        for (Kingdom nationKingdom : second.getKingdoms()) {
            nationKingdom.getRelations().putAll(firstRels);
        }
    }

    public static boolean event(KingdomPlayer player, Group first, Group second, KingdomRelation relation) {
        GroupRelationshipChangeEvent event = new GroupRelationshipChangeEvent(player, first, second, relation);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    public static GroupRelationshipChangeEvent acceptRequest(Player player, Group group, Group to, KingdomRelation relation, Messenger notifier) {
        return RelationUtil.acceptRequest(player, group, to, relation, notifier, notifier);
    }

    public static GroupRelationshipChangeEvent acceptRequest(Player player, Group group, Group to, KingdomRelation relation, Messenger senderNotifier, Messenger receiverNotifier) {
        Objects.requireNonNull(relation);
        GroupRelationshipChangeEvent event = new GroupRelationshipChangeEvent(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), group, to, relation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player).other(PlaceholderTarget.of(to));
        for (Player member : group.getOnlineMembers()) {
            senderNotifier.sendMessage((CommandSender)member, settings);
        }
        settings.switchTargets();
        for (Player member : to.getOnlineMembers()) {
            receiverNotifier.sendMessage((CommandSender)member, settings);
        }
        if (relation == KingdomRelation.NEUTRAL) {
            group.getRelations().remove(to.getId());
            to.getRelations().remove(group.getId());
        } else {
            group.getRelations().put(to.getId(), relation);
            to.getRelations().put(group.getId(), relation);
        }
        to.getRelationshipRequests().remove(group.getId());
        group.getRelationshipRequests().remove(to.getId());
        return event;
    }

    public static boolean hasAnyRelationManagementPermissions(KingdomPlayer kp) {
        if (!kp.hasAnyPermission(StandardKingdomPermission.ALLIANCE, StandardKingdomPermission.TRUCE, StandardKingdomPermission.ENEMY)) {
            KingdomsLang.RELATIONS_NO_PERMISSION.sendError((CommandSender)kp.getPlayer(), new Object[0]);
            return false;
        }
        return true;
    }

    @Nullable
    public static KingdomRelation getRelation(String input, Language locale) {
        try {
            return KingdomRelation.valueOf(input.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ignored) {
            for (KingdomRelation relation : KingdomRelation.VALUES) {
                String name = relation.getName().buildPlain(new MessagePlaceholderProvider().lang(locale));
                if (!input.equalsIgnoreCase(name)) continue;
                return relation;
            }
            return null;
        }
    }

    public static KingdomsLang getAcceptMsgOf(KingdomRelation relation) {
        switch (relation) {
            case ALLY: {
                return KingdomsLang.COMMAND_ALLY_ALLIES;
            }
            case TRUCE: {
                return KingdomsLang.COMMAND_TRUCE_TRUCES;
            }
            case NEUTRAL: {
                return KingdomsLang.COMMAND_REVOKE_NEUTRALS;
            }
        }
        return null;
    }
}

