/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface StringMatcher {
    public boolean matches(String var1);

    public String asString();

    default public Collection<StringMatcher> unwrap() {
        if (this instanceof Aggregate) {
            return Arrays.asList(((Aggregate)this).matchers);
        }
        return Collections.singletonList(this);
    }

    public static StringMatcher optimize(Collection<StringMatcher> matchers) {
        StringMatcher matcher;
        Iterator iter;
        HashSet<String> hashed;
        int startIndex;
        int countExact;
        int size = matchers.size();
        if (size == 0) {
            return Constant.FALSE;
        }
        if (size == 1) {
            return matchers.iterator().next();
        }
        ArrayList<StringMatcher> finalized = new ArrayList<StringMatcher>();
        for (StringMatcher matcher2 : matchers) {
            finalized.add(matcher2);
            if (!(matcher2 instanceof Constant)) continue;
            break;
        }
        if ((countExact = (int)finalized.stream().filter(x -> x instanceof Exact).count()) > 3) {
            int index = 0;
            startIndex = -1;
            hashed = new HashSet<String>(countExact);
            iter = finalized.iterator();
            while (iter.hasNext()) {
                matcher = (StringMatcher)iter.next();
                if (matcher instanceof Exact) {
                    iter.remove();
                    startIndex = index;
                    hashed.add(((Exact)matcher).exact);
                }
                ++index;
            }
            finalized.add(startIndex, new Hashed(hashed));
        }
        if ((countExact = (int)finalized.stream().filter(x -> x instanceof ExactCaseInsensitive).count()) > 3) {
            int index = 0;
            startIndex = -1;
            hashed = new HashSet(countExact);
            iter = finalized.iterator();
            while (iter.hasNext()) {
                matcher = (StringMatcher)iter.next();
                if (matcher instanceof ExactCaseInsensitive) {
                    iter.remove();
                    startIndex = index;
                    hashed.add(((ExactCaseInsensitive)matcher).exact.toLowerCase(Locale.ENGLISH));
                }
                ++index;
            }
            finalized.add(startIndex, new HashedCaseInsensitive(hashed));
        }
        return Aggregate.aggregate(finalized);
    }

    public static StringMatcher group(Collection<StringMatcher> matchers) {
        return StringMatcher.optimize(matchers);
    }

    public static StringMatcher parseAndGroup(Collection<String> matchers) {
        return StringMatcher.optimize(matchers.stream().map(StringMatcher::fromString).collect(Collectors.toList()));
    }

    public static Collection<StringMatcher> parse(Collection<String> matchers) {
        return matchers.stream().map(StringMatcher::fromString).collect(Collectors.toList());
    }

    public static StringMatcher fromString(String text) {
        Objects.requireNonNull(text, "Cannot construct checker from null text");
        if (text.equals("*")) {
            return Constant.TRUE;
        }
        int handlerIndexEnd = text.indexOf(58);
        if (handlerIndexEnd == -1) {
            return new Exact(text);
        }
        String handlerName = text.substring(0, handlerIndexEnd);
        String realText = text.substring(handlerIndexEnd + 1);
        switch (handlerName) {
            case "CI": {
                return new ExactCaseInsensitive(realText);
            }
            case "CONTAINS": {
                return new Contains(realText);
            }
            case "STARTS": {
                return new StartsWith(realText);
            }
            case "ENDS": {
                return new EndsWith(realText);
            }
            case "REGEX": {
                return new Regex(Pattern.compile(realText));
            }
            case "REGEX@CI": {
                return new Regex(Pattern.compile(realText, 2));
            }
        }
        return new Exact(text);
    }

    public static final class Aggregate
    implements StringMatcher {
        private final StringMatcher[] matchers;

        private Aggregate(StringMatcher[] matchers) {
            this.matchers = matchers;
        }

        private static StringMatcher aggregate(Collection<StringMatcher> matchers) {
            int size = matchers.size();
            if (size == 0) {
                return Constant.FALSE;
            }
            if (size == 1) {
                return matchers.iterator().next();
            }
            return new Aggregate(matchers.toArray(new StringMatcher[0]));
        }

        @Override
        public boolean matches(String string) {
            for (StringMatcher matcher : this.matchers) {
                if (!matcher.matches(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            return "Aggregate:" + Arrays.stream(this.matchers).map(StringMatcher::asString).collect(Collectors.toList());
        }
    }

    public static final class Constant
    implements StringMatcher {
        private static final Constant TRUE = new Constant(true);
        private static final Constant FALSE = new Constant(false);
        private final boolean constant;

        private Constant(boolean constant) {
            this.constant = constant;
        }

        @Override
        public boolean matches(String string) {
            return this.constant;
        }

        @Override
        public String asString() {
            return "CONSTANT::" + this.constant;
        }
    }

    public static final class Exact
    implements StringMatcher {
        private final String exact;

        private Exact(String exact) {
            this.exact = exact;
        }

        @Override
        public boolean matches(String string) {
            return this.exact.equals(string);
        }

        @Override
        public String asString() {
            return this.exact;
        }
    }

    public static final class Hashed
    implements StringMatcher {
        private final Set<String> hashed;

        public Hashed(Set<String> hashed) {
            this.hashed = hashed;
        }

        @Override
        public boolean matches(String string) {
            return this.hashed.contains(string);
        }

        @Override
        public String asString() {
            return "Hashed:" + this.hashed;
        }
    }

    public static final class ExactCaseInsensitive
    implements StringMatcher {
        private final String exact;

        private ExactCaseInsensitive(String exact) {
            this.exact = exact;
        }

        @Override
        public boolean matches(String string) {
            return this.exact.equalsIgnoreCase(string);
        }

        @Override
        public String asString() {
            return "CI:" + this.exact;
        }
    }

    public static final class HashedCaseInsensitive
    implements StringMatcher {
        private final Set<String> hashed;

        public HashedCaseInsensitive(Set<String> hashed) {
            this.hashed = hashed;
        }

        @Override
        public boolean matches(String string) {
            return this.hashed.contains(string.toLowerCase(Locale.ENGLISH));
        }

        @Override
        public String asString() {
            return "HashedCaseInsensitive:" + this.hashed;
        }
    }

    public static final class Contains
    implements StringMatcher {
        private final String contains;

        private Contains(String contains) {
            this.contains = contains;
        }

        @Override
        public boolean matches(String string) {
            return string.contains(this.contains);
        }

        @Override
        public String asString() {
            return "CONTAINS:" + this.contains;
        }
    }

    public static final class StartsWith
    implements StringMatcher {
        private final String startsWith;

        private StartsWith(String startsWith) {
            this.startsWith = startsWith;
        }

        @Override
        public boolean matches(String string) {
            return string.startsWith(this.startsWith);
        }

        @Override
        public String asString() {
            return "STARTS:" + this.startsWith;
        }
    }

    public static final class EndsWith
    implements StringMatcher {
        private final String endsWith;

        private EndsWith(String endsWith) {
            this.endsWith = endsWith;
        }

        @Override
        public boolean matches(String string) {
            return string.endsWith(this.endsWith);
        }

        @Override
        public String asString() {
            return "ENDS:" + this.endsWith;
        }
    }

    public static final class Regex
    implements StringMatcher {
        private final Pattern pattern;

        private Regex(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String string) {
            return this.pattern.matcher(string).matches();
        }

        @Override
        public String asString() {
            return "REGEX" + ((this.pattern.flags() & 2) != 0 ? "-CI" : "") + ':' + this.pattern.pattern();
        }
    }
}

