/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.string;

import java.util.Collection;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.string.ObjectPrettyStringFactory;
import org.kingdoms.utils.internal.string.PrettyString;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/utils/internal/string/PrettyStringContext;", "", "string", "Ljava/lang/StringBuilder;", "Lorg/kingdoms/libs/kotlin/text/StringBuilder;", "nestLevel", "", "<init>", "(Ljava/lang/StringBuilder;I)V", "getString", "()Ljava/lang/StringBuilder;", "getNestLevel", "()I", "line", "getLine", "column", "getColumn", "delegate", "", "obj", "shared"})
public final class PrettyStringContext {
    @NotNull
    private final StringBuilder string;
    private final int nestLevel;

    public PrettyStringContext(@NotNull StringBuilder string, int nestLevel) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.string = string;
        this.nestLevel = nestLevel;
    }

    @NotNull
    public final StringBuilder getString() {
        return this.string;
    }

    public final int getNestLevel() {
        return this.nestLevel;
    }

    public final int getLine() {
        String string = this.string.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = new char[]{'\n'};
        return ((Collection)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)).size();
    }

    public final int getColumn() {
        String string = this.string.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.substringAfterLast$default((String)string, (char)'\n', null, (int)2, null).length();
    }

    public final void delegate(@Nullable Object obj) {
        if (obj == null) {
            this.string.append("null");
            return;
        }
        PrettyString<?> specialized = ObjectPrettyStringFactory.findSpecialized(obj.getClass());
        if (specialized != null) {
            PrettyStringContext newContext = new PrettyStringContext(this.string, this.nestLevel + 1);
            specialized.toPrettyString(Fn.cast(obj), newContext);
        } else {
            String space = StringsKt.repeat((CharSequence)" ", (int)((this.nestLevel + 1) * 2));
            StringBuilder stringBuilder = this.string.append(obj.toString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            char[] cArray = new char[]{'\n'};
            CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)stringBuilder, (char[])cArray, (boolean)false, (int)0, (int)6, null), null, null, null, (int)0, null, arg_0 -> PrettyStringContext.delegate$lambda$0(space, arg_0), (int)31, null);
        }
    }

    private static final CharSequence delegate$lambda$0(String $space, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $space + '\n';
    }
}

