/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.kingdoms.utils.internal.arrays.ArrayUtils;

public final class Reflect {
    public static boolean classExists(String className) {
        try {
            Class.forName(className, false, Reflect.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String ... names) throws NoSuchFieldException {
        Throwable error = null;
        for (String name : names) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException ex) {
                if (error == null) {
                    error = new NoSuchFieldException("Couldn't find any of the fields " + Arrays.toString(names) + " in class: " + clazz);
                }
                error.addSuppressed(ex);
            }
        }
        throw error;
    }

    public static Class<?>[] getClassHierarchy(Class<?> clazz, boolean allowAnonymous) {
        ArrayList classes = new ArrayList();
        Class<?> lastUpperClass = clazz;
        while ((lastUpperClass = allowAnonymous ? lastUpperClass.getEnclosingClass() : lastUpperClass.getDeclaringClass()) != null) {
            if (classes.isEmpty()) {
                classes.add(clazz);
            }
            classes.add(lastUpperClass);
        }
        if (classes.isEmpty()) {
            return new Class[]{clazz};
        }
        Class[] reversed = classes.toArray(new Class[0]);
        return ArrayUtils.reverse(reversed);
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> hierarchy : Reflect.getClassHierarchy(clazz, false)) {
            fields.addAll(Arrays.asList(hierarchy.getDeclaredFields()));
        }
        return fields;
    }

    public static String toString(Object obj) {
        Class<?> clazz = obj.getClass();
        List<Field> fields = Reflect.getFields(clazz);
        StringBuilder string = new StringBuilder(clazz.getSimpleName()).append('{');
        StringJoiner joiner = new StringJoiner(", ");
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                joiner.add(field.getName() + '=' + field.get(obj));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return string.append(joiner).append('}').toString();
    }
}

